/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML {
    private static final String[] chardata_escapes = new String[]{"#0;", "#1;", "#2;", "#3;", "#4;", "#5;", "#6;", "#7;", "#8;", null, null, "#11;", "#12;", null, "#14;", "#15;", "#16;", "#17;", "#18;", "#19;", "#20;", "#21;", "#22;", "#23;", "#24;", "#25;", "#26;", "#27;", "#28;", "#29;", "#30;", "#31;", null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;"};
    private static final String[] attribute_escapes = new String[]{"#0;", "#1;", "#2;", "#3;", "#4;", "#5;", "#6;", "#7;", "#8;", null, null, "#11;", "#12;", null, "#14;", "#15;", "#16;", "#17;", "#18;", "#19;", "#20;", "#21;", "#22;", "#23;", "#24;", "#25;", "#26;", "#27;", "#28;", "#29;", "#30;", "#31;", null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;"};

    public static void escapeCharData(String str, Writer out) throws IOException {
        XML.escape(str, out, chardata_escapes);
    }

    public static void escapeAttributeValue(String str, Writer out) throws IOException {
        XML.escape(str, out, attribute_escapes);
    }

    public static void escapeAttributeValue(char[] chars, int start, int length, Writer out) throws IOException {
        XML.escape(chars, start, length, out, attribute_escapes);
    }

    public static final void writeXML(Writer out, String tag, String val) throws IOException {
        out.write(60);
        out.write(tag);
        if (val == null) {
            out.write(47);
            out.write(62);
        } else {
            out.write(62);
            XML.escapeCharData(val, out);
            out.write(60);
            out.write(47);
            out.write(tag);
            out.write(62);
        }
    }

    public static final void writeUnescapedXML(Writer out, String tag, String val, Object ... attrs) throws IOException {
        out.write(60);
        out.write(tag);
        for (int i = 0; i < attrs.length; ++i) {
            out.write(32);
            out.write(attrs[i++].toString());
            out.write(61);
            out.write(34);
            out.write(attrs[i].toString());
            out.write(34);
        }
        if (val == null) {
            out.write(47);
            out.write(62);
        } else {
            out.write(62);
            out.write(val);
            out.write(60);
            out.write(47);
            out.write(tag);
            out.write(62);
        }
    }

    public static final void writeXML(Writer out, String tag, String val, Object ... attrs) throws IOException {
        out.write(60);
        out.write(tag);
        for (int i = 0; i < attrs.length; ++i) {
            out.write(32);
            out.write(attrs[i++].toString());
            out.write(61);
            out.write(34);
            XML.escapeAttributeValue(attrs[i].toString(), out);
            out.write(34);
        }
        if (val == null) {
            out.write(47);
            out.write(62);
        } else {
            out.write(62);
            XML.escapeCharData(val, out);
            out.write(60);
            out.write(47);
            out.write(tag);
            out.write(62);
        }
    }

    public static void writeXML(Writer out, String tag, String val, Map<String, String> attrs) throws IOException {
        out.write(60);
        out.write(tag);
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            out.write(32);
            out.write(entry.getKey());
            out.write(61);
            out.write(34);
            XML.escapeAttributeValue(entry.getValue(), out);
            out.write(34);
        }
        if (val == null) {
            out.write(47);
            out.write(62);
        } else {
            out.write(62);
            XML.escapeCharData(val, out);
            out.write(60);
            out.write(47);
            out.write(tag);
            out.write(62);
        }
    }

    private static void escape(char[] chars, int offset, int length, Writer out, String[] escapes) throws IOException {
        for (int i = offset; i < length; ++i) {
            String replacement;
            char ch = chars[i];
            if (ch < escapes.length && (replacement = escapes[ch]) != null) {
                out.write(replacement);
                continue;
            }
            out.write(ch);
        }
    }

    private static void escape(String str, Writer out, String[] escapes) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            String replacement;
            char ch = str.charAt(i);
            if (ch < escapes.length && (replacement = escapes[ch]) != null) {
                out.write(replacement);
                continue;
            }
            out.write(ch);
        }
    }
}

