/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.internal;

import bitronix.tm.BitronixXid;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.MonotonicClock;
import java.util.Date;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAResourceHolderState {
    private static final Logger log = LoggerFactory.getLogger(XAResourceHolderState.class);
    private final ResourceBean bean;
    private final XAResourceHolder xaResourceHolder;
    private volatile BitronixXid xid;
    private volatile boolean started;
    private volatile boolean ended;
    private volatile boolean suspended;
    private volatile Date transactionTimeoutDate;
    private volatile boolean isTimeoutAlreadySet;
    private volatile boolean failed;
    private volatile int hashCode;

    public XAResourceHolderState(XAResourceHolder resourceHolder, ResourceBean bean) {
        this.bean = bean;
        this.xaResourceHolder = resourceHolder;
        this.started = false;
        this.ended = false;
        this.suspended = false;
        this.isTimeoutAlreadySet = false;
        this.xid = null;
        this.hashCode = 17 * bean.hashCode();
    }

    public XAResourceHolderState(XAResourceHolderState resourceHolderState) {
        this.bean = resourceHolderState.bean;
        this.xaResourceHolder = resourceHolderState.xaResourceHolder;
        this.started = false;
        this.ended = false;
        this.suspended = false;
        this.isTimeoutAlreadySet = false;
        this.xid = null;
        this.hashCode = 17 * this.bean.hashCode();
    }

    public BitronixXid getXid() {
        return this.xid;
    }

    public void setXid(BitronixXid xid) throws BitronixSystemException {
        if (log.isDebugEnabled()) {
            log.debug("assigning <" + xid + "> to <" + this + ">");
        }
        if (this.xid != null && !xid.equals(this.xid)) {
            throw new BitronixSystemException("a XID has already been assigned to " + this);
        }
        this.xid = xid;
        this.hashCode = 17 * (this.bean.hashCode() + (xid != null ? xid.hashCode() : 0));
    }

    public XAResource getXAResource() {
        return this.xaResourceHolder.getXAResource();
    }

    public XAResourceHolder getXAResourceHolder() {
        return this.xaResourceHolder;
    }

    public Date getTransactionTimeoutDate() {
        return this.transactionTimeoutDate;
    }

    public void setTransactionTimeoutDate(Date transactionTimeoutDate) {
        this.transactionTimeoutDate = transactionTimeoutDate;
    }

    public String getUniqueName() {
        return this.bean.getUniqueName();
    }

    public boolean getUseTmJoin() {
        return this.bean.getUseTmJoin();
    }

    public int getTwoPcOrderingPosition() {
        return this.bean.getTwoPcOrderingPosition();
    }

    public boolean getIgnoreRecoveryFailures() {
        return this.bean.getIgnoreRecoveryFailures();
    }

    public boolean isEnded() {
        return this.ended;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void end(int flags) throws XAException {
        boolean ended = this.ended;
        boolean suspended = this.suspended;
        if (this.ended && flags == 0x2000000) {
            if (log.isDebugEnabled()) {
                log.debug("resource already ended, changing state to suspended: " + this);
            }
            this.suspended = true;
            return;
        }
        if (this.ended) {
            throw new BitronixXAException("resource already ended: " + this, -6);
        }
        if (flags == 0x2000000) {
            if (!this.started) {
                throw new BitronixXAException("resource hasn't been started, cannot suspend it: " + this, -6);
            }
            if (this.suspended) {
                throw new BitronixXAException("resource already suspended: " + this, -6);
            }
            if (log.isDebugEnabled()) {
                log.debug("suspending " + this + " with " + Decoder.decodeXAResourceFlag(flags));
            }
            suspended = true;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("ending " + this + " with " + Decoder.decodeXAResourceFlag(flags));
            }
            ended = true;
        }
        try {
            this.getXAResource().end(this.xid, flags);
            if (log.isDebugEnabled()) {
                log.debug("ended " + this + " with " + Decoder.decodeXAResourceFlag(flags));
            }
        }
        catch (XAException ex) {
            this.failed = true;
            throw ex;
        }
        finally {
            this.suspended = suspended;
            this.ended = ended;
            this.started = false;
        }
    }

    public void start(int flags) throws XAException {
        boolean suspended = this.suspended;
        boolean started = this.started;
        if (this.ended && flags == 0x8000000) {
            if (log.isDebugEnabled()) {
                log.debug("resource already ended, changing state to resumed: " + this);
            }
            this.suspended = false;
            return;
        }
        if (flags == 0x8000000) {
            if (!this.suspended) {
                throw new BitronixXAException("resource hasn't been suspended, cannot resume it: " + this, -6);
            }
            if (!this.started) {
                throw new BitronixXAException("resource hasn't been started, cannot resume it: " + this, -6);
            }
            if (log.isDebugEnabled()) {
                log.debug("resuming " + this + " with " + Decoder.decodeXAResourceFlag(flags));
            }
            suspended = false;
        } else {
            if (this.started) {
                throw new BitronixXAException("resource already started: " + this, -6);
            }
            if (log.isDebugEnabled()) {
                log.debug("starting " + this + " with " + Decoder.decodeXAResourceFlag(flags));
            }
            started = true;
        }
        if (!this.isTimeoutAlreadySet && this.transactionTimeoutDate != null && this.bean.getApplyTransactionTimeout()) {
            int timeoutInSeconds = (int)((this.transactionTimeoutDate.getTime() - MonotonicClock.currentTimeMillis() + 999L) / 1000L);
            timeoutInSeconds = Math.max(1, timeoutInSeconds);
            if (log.isDebugEnabled()) {
                log.debug("applying resource timeout of " + timeoutInSeconds + "s on " + this);
            }
            this.getXAResource().setTransactionTimeout(timeoutInSeconds);
            this.isTimeoutAlreadySet = true;
        }
        this.getXAResource().start(this.xid, flags);
        this.suspended = suspended;
        this.started = started;
        this.ended = false;
        if (log.isDebugEnabled()) {
            log.debug("started " + this + " with " + Decoder.decodeXAResourceFlag(flags));
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XAResourceHolderState) || this.hashCode != obj.hashCode()) {
            return false;
        }
        XAResourceHolderState other = (XAResourceHolderState)obj;
        return this.equals(other.bean, this.bean) && this.equals(other.xid, this.xid);
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public String toString() {
        return "an XAResourceHolderState with uniqueName=" + this.bean.getUniqueName() + " XAResource=" + this.getXAResource() + (this.started ? " (started)" : "") + (this.ended ? " (ended)" : "") + (this.suspended ? " (suspended)" : "") + " with XID " + this.xid;
    }
}

