/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.Misc;
import ucar.nc2.util.URLnaming;
import ucar.nc2.util.xml.Parse;

@Deprecated
public class NcMLWriter {
    public static final Namespace ncmlDefaultNamespace = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    private static final Logger log = LoggerFactory.getLogger(NcMLWriter.class);
    public static final Predicate<Variable> writeNoVariablesPredicate = Predicates.alwaysFalse();
    public static final Predicate<Variable> writeMetadataVariablesPredicate = Variable::isMetadata;
    public static final Predicate<Variable> writeCoordinateVariablesPredicate = Variable::isCoordinateVariable;
    public static final Predicate<Variable> writeAllVariablesPredicate = Predicates.alwaysTrue();
    private Namespace namespace;
    private Format xmlFormat;
    private Predicate<Variable> writeVariablesPredicate;
    private final XMLOutputter xmlOutputter = new XMLOutputter();

    public NcMLWriter() {
        this.namespace = ncmlDefaultNamespace;
        this.xmlFormat = Format.getPrettyFormat().setLineSeparator(LineSeparator.UNIX);
        this.writeVariablesPredicate = writeMetadataVariablesPredicate;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
    }

    public Format getXmlFormat() {
        return this.xmlFormat;
    }

    public void setXmlFormat(Format xmlFormat) {
        this.xmlFormat = (Format)Preconditions.checkNotNull((Object)xmlFormat);
    }

    public Predicate<Variable> getWriteVariablesPredicate() {
        return this.writeVariablesPredicate;
    }

    public void setWriteVariablesPredicate(Predicate<Variable> predicate) {
        this.writeVariablesPredicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    public String writeToString(Element elem) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            this.writeToWriter(elem, writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("CAN'T HAPPEN: StringWriter.close() is a no-op.", e);
            }
        }
        writer.close();
        return string;
    }

    public void writeToFile(Element elem, File outFile) throws IOException {
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile, false));){
            this.writeToStream(elem, outStream);
        }
    }

    public void writeToStream(Element elem, OutputStream outStream) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outStream), this.xmlFormat.getEncoding()));){
            this.writeToWriter(elem, writer);
        }
    }

    public void writeToWriter(Element elem, Writer writer) throws IOException {
        this.xmlOutputter.setFormat(this.xmlFormat);
        elem.detach();
        this.xmlOutputter.output(new Document(elem), writer);
    }

    public Element makeExplicitNetcdfElement(NetcdfFile ncFile, String location) {
        Element netcdfElem = this.makeNetcdfElement(ncFile, location);
        netcdfElem.addContent(0, (Content)new Element("explicit", this.namespace));
        return netcdfElem;
    }

    public Element makeNetcdfElement(NetcdfFile ncFile, String location) {
        Element rootElem = this.makeGroupElement(ncFile.getRootGroup());
        rootElem.setName("netcdf");
        rootElem.removeAttribute("name");
        rootElem.addNamespaceDeclaration(this.namespace);
        if (null == location) {
            location = ncFile.getLocation();
        }
        if (null != location) {
            rootElem.setAttribute("location", URLnaming.canonicalizeWrite(location));
        }
        if (null != ncFile.getId()) {
            rootElem.setAttribute("id", ncFile.getId());
        }
        if (null != ncFile.getTitle()) {
            rootElem.setAttribute("title", ncFile.getTitle());
        }
        return rootElem;
    }

    public Element makeGroupElement(Group group) {
        Element elem = new Element("group", this.namespace);
        elem.setAttribute("name", group.getShortName());
        for (EnumTypedef etd : group.getEnumTypedefs()) {
            elem.addContent((Content)this.makeEnumTypedefElement(etd));
        }
        for (Dimension dim : group.getDimensions()) {
            elem.addContent((Content)this.makeDimensionElement(dim));
        }
        for (Variable var : group.getVariables()) {
            boolean showValues = this.writeVariablesPredicate.apply((Object)var);
            elem.addContent((Content)this.makeVariableElement(var, showValues));
        }
        for (Group g : group.getGroups()) {
            Element groupElem = new Element("group", this.namespace);
            groupElem.setAttribute("name", g.getShortName());
            elem.addContent((Content)this.makeGroupElement(g));
        }
        for (Attribute att : group.attributes()) {
            elem.addContent((Content)this.makeAttributeElement(att));
        }
        return elem;
    }

    public Element makeEnumTypedefElement(EnumTypedef etd) {
        Element typeElem = new Element("enumTypedef", this.namespace);
        typeElem.setAttribute("name", etd.getShortName());
        typeElem.setAttribute("type", etd.getBaseType().toString());
        TreeMap<Integer, String> map = new TreeMap<Integer, String>((Map<Integer, String>)etd.getMap());
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            typeElem.addContent((Content)new Element("enum", this.namespace).setAttribute("key", Integer.toString(entry.getKey())).addContent(entry.getValue()));
        }
        return typeElem;
    }

    public Element makeDimensionElement(Dimension dim) throws IllegalArgumentException {
        if (!dim.isShared()) {
            throw new IllegalArgumentException("Cannot create private dimension: in NcML, <dimension> elements are always shared.");
        }
        Element dimElem = new Element("dimension", this.namespace);
        dimElem.setAttribute("name", dim.getShortName());
        dimElem.setAttribute("length", Integer.toString(dim.getLength()));
        if (dim.isUnlimited()) {
            dimElem.setAttribute("isUnlimited", "true");
        }
        return dimElem;
    }

    public Element makeVariableElement(Variable var, boolean showValues) {
        Element varElem;
        block11: {
            block10: {
                boolean isStructure = var instanceof Structure;
                varElem = new Element("variable", this.namespace);
                varElem.setAttribute("name", var.getShortName());
                StringBuilder buff = new StringBuilder();
                ImmutableList<Dimension> dims = var.getDimensions();
                for (int i = 0; i < dims.size(); ++i) {
                    Dimension dim = (Dimension)dims.get(i);
                    if (i > 0) {
                        buff.append(" ");
                    }
                    if (dim.isShared()) {
                        buff.append(dim.getShortName());
                        continue;
                    }
                    if (dim.isVariableLength()) {
                        buff.append("*");
                        continue;
                    }
                    buff.append(dim.getLength());
                }
                varElem.setAttribute("shape", buff.toString());
                DataType dt = var.getDataType();
                if (dt != null) {
                    varElem.setAttribute("type", dt.toString());
                    if (dt.isEnum()) {
                        varElem.setAttribute("typedef", var.getEnumTypedef().getShortName());
                    }
                }
                for (Attribute att : var.attributes()) {
                    varElem.addContent((Content)this.makeAttributeElement(att));
                }
                if (!isStructure) break block10;
                Structure s = (Structure)var;
                for (Variable variable : s.getVariables()) {
                    varElem.addContent((Content)this.makeVariableElement(variable, showValues));
                }
                break block11;
            }
            if (!showValues) break block11;
            try {
                varElem.addContent((Content)this.makeValuesElement(var, true));
            }
            catch (IOException e) {
                String message = String.format("Couldn't read values for %s. Omitting <values> element.%n\t%s", var.getFullName(), e.getMessage());
                log.warn(message);
            }
        }
        return varElem;
    }

    public Element makeAttributeElement(Attribute attribute) {
        Element attElem = new Element("attribute", this.namespace);
        attElem.setAttribute("name", attribute.getShortName());
        DataType dt = attribute.getDataType();
        if (dt != null && dt != DataType.STRING) {
            attElem.setAttribute("type", dt.toString());
        }
        if (attribute.getLength() == 0) {
            return attElem;
        }
        if (attribute.isString()) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < attribute.getLength(); ++i) {
                String sval = attribute.getStringValue(i);
                if (i > 0) {
                    buff.append("|");
                }
                buff.append(sval);
            }
            attElem.setAttribute("value", Parse.cleanCharacterData(buff.toString()));
            if (attribute.getLength() > 1) {
                attElem.setAttribute("separator", "|");
            }
        } else {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < attribute.getLength(); ++i) {
                Number val = attribute.getNumericValue(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(val);
            }
            attElem.setAttribute("value", buff.toString());
        }
        return attElem;
    }

    public Element makeValuesElement(Variable variable, boolean allowRegular) throws IOException {
        Element elem = new Element("values", this.namespace);
        StringBuilder buff = new StringBuilder();
        Array a = variable.read();
        if (variable.getDataType() == DataType.CHAR) {
            char[] data = (char[])a.getStorage();
            elem.setText(new String(data));
        } else if (variable.getDataType() == DataType.STRING) {
            elem.setAttribute("separator", "|");
            int count = 0;
            IndexIterator iter = a.getIndexIterator();
            while (iter.hasNext()) {
                if (count++ > 0) {
                    buff.append("|");
                }
                buff.append(iter.getObjectNext());
            }
            elem.setText(buff.toString());
        } else {
            if (allowRegular && a.getRank() == 1 && a.getSize() > 2L) {
                Index ima = a.getIndex();
                double start = a.getDouble(ima.set(0));
                double incr = a.getDouble(ima.set(1)) - start;
                boolean isRegular = true;
                int i = 2;
                while ((long)i < a.getSize()) {
                    double v0;
                    double v1 = a.getDouble(ima.set(i));
                    if (!Misc.nearlyEquals(v1 - (v0 = a.getDouble(ima.set(i - 1))), incr)) {
                        isRegular = false;
                    }
                    ++i;
                }
                if (isRegular) {
                    elem.setAttribute("start", Double.toString(start));
                    elem.setAttribute("increment", Double.toString(incr));
                    elem.setAttribute("npts", Long.toString(variable.getSize()));
                    return elem;
                }
            }
            IndexIterator iter = a.getIndexIterator();
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    buff.append(" ");
                }
                switch (variable.getDataType()) {
                    case FLOAT: {
                        buff.append(iter.getFloatNext());
                        break;
                    }
                    case DOUBLE: {
                        buff.append(iter.getDoubleNext());
                        break;
                    }
                    default: {
                        buff.append(iter.getIntNext());
                    }
                }
                first = false;
            }
            elem.setText(buff.toString());
        }
        return elem;
    }

    public static class WriteVariablesWithNamesPredicate
    implements Predicate<Variable> {
        private final Set<String> variableNames;

        public WriteVariablesWithNamesPredicate(Iterable<String> variableNames) {
            this.variableNames = Sets.newHashSet(variableNames);
        }

        public boolean apply(Variable var) {
            return this.variableNames.contains(var.getFullName());
        }
    }
}

