/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;

public final class QuasiRegular {
    float[] data;

    public QuasiRegular(float[] quasi, Object gds) {
        int[] parallels = null;
        int ni = 0;
        int nj = 0;
        if (gds instanceof Grib2GridDefinitionSection) {
            parallels = ((Grib2GridDefinitionSection)gds).getOlonPoints();
            ni = ((Grib2GridDefinitionSection)gds).getNx();
            nj = ((Grib2GridDefinitionSection)gds).getNy();
        } else if (gds instanceof Grib1GridDefinitionSection) {
            parallels = ((Grib1GridDefinitionSection)gds).getNumPV();
            ni = ((Grib1GridDefinitionSection)gds).getNx();
            nj = ((Grib1GridDefinitionSection)gds).getNy();
        } else {
            return;
        }
        int npts = ni * nj;
        this.data = new float[npts];
        double x1_der = 1.0E30;
        double xn_der = 1.0E30;
        int inputIdx = 0;
        int outputIdx = 0;
        for (int j = 0; j < nj; ++j) {
            int i;
            int npoints = parallels[j];
            if (npoints == ni) {
                for (i = 0; i < ni; ++i) {
                    this.data[outputIdx++] = quasi[inputIdx++];
                }
                continue;
            }
            double[] second_d = new double[npoints];
            this.secondDerivative(quasi, inputIdx, npoints, x1_der, xn_der, second_d);
            for (i = 0; i < ni; ++i) {
                double mapped_i = (float)i / ((float)ni - 1.0f) * ((float)npoints - 1.0f);
                this.cubicSpline(quasi, inputIdx, second_d, mapped_i, this.data, outputIdx++);
            }
            inputIdx += npoints;
        }
        quasi = null;
    }

    private void secondDerivative(float[] inpt, int idx, int n, double x1d, double xnd, double[] y2d) {
        double qn;
        double un;
        int i;
        double[] scratch = new double[n - 1];
        if (x1d > 9.9E29) {
            scratch[0] = 0.0;
            y2d[0] = 0.0;
        } else {
            y2d[0] = 0.5;
            scratch[0] = 3.0 * ((double)(inpt[idx + 1] - inpt[idx]) / (1.0 - x1d));
        }
        for (i = 1; i < n - 1; ++i) {
            double sig = 0.5;
            double p = sig * y2d[i - 1] + 2.0;
            y2d[i] = (sig - 1.0) / p;
            scratch[i] = inpt[idx + i + 1] - inpt[idx + i] - (inpt[idx + i] - inpt[idx + i - 1]);
            scratch[i] = (6.0 * scratch[i] / 2.0 - sig * scratch[i - 1]) / p;
        }
        if (xnd > 9.9E29) {
            un = 0.0;
            qn = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 * (xnd - (double)(inpt[idx + n - 1] - inpt[idx + n - 2]));
        }
        y2d[n - 1] = (un - qn * scratch[n - 2]) / (qn * y2d[n - 2] + 1.0);
        for (i = n - 2; i >= 0; --i) {
            y2d[i] = y2d[i] * y2d[i + 1] + scratch[i];
        }
    }

    private void cubicSpline(float[] inpt, int iIdx, double[] y2d, double x, float[] outpt, int oIdx) {
        if (Math.floor(x) == x) {
            outpt[oIdx] = inpt[iIdx + (int)x];
            return;
        }
        int hi = (int)Math.ceil(x);
        int low = (int)Math.floor(x);
        double a = (double)hi - x;
        double b = x - (double)low;
        outpt[oIdx] = (float)(a * (double)inpt[iIdx + low] + b * (double)inpt[iIdx + hi] + ((a * a * a - a) * y2d[low] + (b * b * b - b) * y2d[hi]) / 6.0);
    }

    public float[] getData() {
        return this.data;
    }
}

