/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

public class Path {
    private static final int DEFAULT_CAPACITY = 8;
    private static final int INVALID_HASH_CODE = -1;
    private int[] blockIdList = new int[8];
    private int length = 0;
    private int cachedHashCode;
    private static final String SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%^&*()";

    public Path() {
        this.invalidate();
    }

    public void append(int id) {
        this.grow(this.length);
        this.blockIdList[this.length] = id;
        ++this.length;
        this.invalidate();
    }

    public int getBlockIdAt(int index) {
        return this.blockIdList[index];
    }

    public int getLength() {
        return this.length;
    }

    public Path duplicate() {
        Path dup = new Path();
        dup.copyFrom(this);
        return dup;
    }

    public void copyFrom(Path other) {
        this.grow(other.length - 1);
        System.arraycopy(other.blockIdList, 0, this.blockIdList, 0, other.length);
        this.length = other.length;
        this.cachedHashCode = other.cachedHashCode;
    }

    private void invalidate() {
        this.cachedHashCode = -1;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            int value = 0;
            for (int i = 0; i < this.length; ++i) {
                value += i * 1009 * this.blockIdList[i];
            }
            this.cachedHashCode = value;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Path other = (Path)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.blockIdList[i] == other.blockIdList[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            int block = this.blockIdList[i];
            if (block < SYMBOLS.length()) {
                buf.append(SYMBOLS.charAt(block));
                continue;
            }
            buf.append("'" + block + "'");
        }
        return buf.toString();
    }

    private void grow(int index) {
        if (index >= this.blockIdList.length) {
            int newLen = this.blockIdList.length;
            while (index >= (newLen *= 2)) {
            }
            int[] arr = new int[newLen];
            System.arraycopy(this.blockIdList, 0, arr, 0, this.length);
            this.blockIdList = arr;
        }
    }
}

