/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.jhotdraw.geom.Geom;

public class Shapes {
    private Shapes() {
    }

    public static boolean outlineContains(Shape shape, Point2D.Double p, double tolerance) {
        PathIterator i = shape.getPathIterator(new AffineTransform(), tolerance);
        if (!i.isDone()) {
            double[] coords = new double[6];
            int type = i.currentSegment(coords);
            double prevX = coords[0];
            double prevY = coords[1];
            i.next();
            while (!i.isDone()) {
                i.currentSegment(coords);
                if (Geom.lineContainsPoint(prevX, prevY, coords[0], coords[1], p.x, p.y, tolerance)) {
                    return true;
                }
                prevX = coords[0];
                prevY = coords[1];
                i.next();
            }
        }
        return false;
    }
}

