/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.FieldOptions;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermVectorComponent
extends SearchComponent
implements SolrCoreAware {
    public static final String COMPONENT_NAME = "tv";
    protected NamedList initParams;
    public static final String TERM_VECTORS = "termVectors";

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        DocIterator iter;
        String fldLst;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        NamedList termVectors = new NamedList();
        rb.rsp.add(TERM_VECTORS, termVectors);
        FieldOptions allFields = new FieldOptions();
        allFields.termFreq = params.getBool("tv.tf", false);
        allFields.positions = params.getBool("tv.positions", false);
        allFields.offsets = params.getBool("tv.offsets", false);
        allFields.docFreq = params.getBool("tv.df", false);
        allFields.tfIdf = params.getBool("tv.tf_idf", false);
        boolean all = params.getBool("tv.all", false);
        if (all) {
            allFields.termFreq = true;
            allFields.positions = true;
            allFields.offsets = true;
            allFields.docFreq = true;
            allFields.tfIdf = true;
        }
        if ((fldLst = params.get("tv.fl")) == null) {
            fldLst = params.get("fl");
        }
        IndexSchema schema = rb.req.getSchema();
        HashMap<String, FieldOptions> fieldOptions = new HashMap<String, FieldOptions>();
        NamedList warnings = new NamedList();
        ArrayList<String> noTV = new ArrayList<String>();
        ArrayList<String> noPos = new ArrayList<String>();
        ArrayList<String> noOff = new ArrayList<String>();
        if (fldLst != null) {
            String[] fields;
            for (String field : fields = SolrPluginUtils.split(fldLst)) {
                SchemaField sf = schema.getFieldOrNull(field);
                if (sf != null) {
                    if (sf.storeTermVector()) {
                        FieldOptions option = (FieldOptions)fieldOptions.get(field);
                        if (option == null) {
                            option = new FieldOptions();
                            option.fieldName = field;
                            fieldOptions.put(field, option);
                        }
                        option.termFreq = params.getFieldBool(field, "tv.tf", allFields.termFreq);
                        option.docFreq = params.getFieldBool(field, "tv.df", allFields.docFreq);
                        option.tfIdf = params.getFieldBool(field, "tv.tf_idf", allFields.tfIdf);
                        option.positions = params.getFieldBool(field, "tv.positions", allFields.positions);
                        if (option.positions && !sf.storeTermPositions()) {
                            noPos.add(field);
                        }
                        option.offsets = params.getFieldBool(field, "tv.offsets", allFields.offsets);
                        if (!option.offsets || sf.storeTermOffsets()) continue;
                        noOff.add(field);
                        continue;
                    }
                    noTV.add(field);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: " + field);
            }
        }
        boolean hasWarnings = false;
        if (!noTV.isEmpty()) {
            warnings.add("noTermVectors", noTV);
            hasWarnings = true;
        }
        if (!noPos.isEmpty()) {
            warnings.add("noPositions", noPos);
            hasWarnings = true;
        }
        if (!noOff.isEmpty()) {
            warnings.add("noOffsets", noOff);
            hasWarnings = true;
        }
        if (hasWarnings) {
            termVectors.add("warnings", (Object)warnings);
        }
        DocListAndSet listAndSet = rb.getResults();
        List<Integer> docIds = this.getInts(params.getParams("tv.docIds"));
        if (docIds != null && !docIds.isEmpty()) {
            iter = docIds.iterator();
        } else {
            DocList list = listAndSet.docList;
            iter = list.iterator();
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        SolrIndexReader reader = searcher.getReader();
        SchemaField keyField = schema.getUniqueKeyField();
        String uniqFieldName = null;
        if (keyField != null) {
            uniqFieldName = keyField.getName();
        }
        SetBasedFieldSelector fieldSelector = new SetBasedFieldSelector(Collections.singleton(uniqFieldName), Collections.emptySet());
        TVMapper mapper = new TVMapper((IndexReader)reader);
        mapper.fieldOptions = allFields;
        while (iter.hasNext()) {
            Integer docId = (Integer)iter.next();
            NamedList docNL = new NamedList();
            mapper.docNL = docNL;
            termVectors.add("doc-" + docId, (Object)docNL);
            if (keyField != null) {
                Document document = reader.document(docId, (FieldSelector)fieldSelector);
                Field uniqId = document.getField(uniqFieldName);
                String uniqVal = null;
                if (uniqId != null) {
                    uniqVal = keyField.getType().storedToReadable((Fieldable)uniqId);
                }
                if (uniqVal != null) {
                    docNL.add("uniqueKey", (Object)uniqVal);
                    termVectors.add("uniqueKeyFieldName", (Object)uniqFieldName);
                }
            }
            if (!fieldOptions.isEmpty()) {
                for (Map.Entry entry : fieldOptions.entrySet()) {
                    mapper.fieldOptions = (FieldOptions)entry.getValue();
                    reader.getTermFreqVector(docId, (String)entry.getKey(), mapper);
                }
                continue;
            }
            reader.getTermFreqVector(docId, mapper);
        }
    }

    private List<Integer> getInts(String[] vals) {
        ArrayList<Integer> result = null;
        if (vals != null && vals.length > 0) {
            result = new ArrayList<Integer>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                try {
                    result.add(new Integer(vals[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        int result = ResponseBuilder.STAGE_DONE;
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            HashMap<String, ArrayList<ShardDoc>> shardMap = new HashMap<String, ArrayList<ShardDoc>>();
            for (ShardDoc sdoc : rb.resultIds.values()) {
                ArrayList<ShardDoc> shardDocs = (ArrayList<ShardDoc>)shardMap.get(sdoc.shard);
                if (shardDocs == null) {
                    shardDocs = new ArrayList<ShardDoc>();
                    shardMap.put(sdoc.shard, shardDocs);
                }
                shardDocs.add(sdoc);
            }
            for (Collection shardDocs : shardMap.values()) {
                ShardRequest sreq = new ShardRequest();
                sreq.purpose = 64;
                sreq.shards = new String[]{((ShardDoc)shardDocs.iterator().next()).shard};
                sreq.params = new ModifiableSolrParams();
                sreq.params.add(rb.req.getParams());
                sreq.params.remove("q");
                ArrayList<String> ids = new ArrayList<String>(shardDocs.size());
                for (ShardDoc shardDoc : shardDocs) {
                    ids.add(shardDoc.id.toString());
                }
                sreq.params.add("tv.docIds", new String[]{StrUtils.join(ids, (char)',')});
                rb.addRequest(this, sreq);
            }
            result = ResponseBuilder.STAGE_DONE;
        }
        return result;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void inform(SolrCore core) {
    }

    @Override
    public String getVersion() {
        return "$Revision$";
    }

    @Override
    public String getSourceId() {
        return "$Id:$";
    }

    @Override
    public String getSource() {
        return "$Revision:$";
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Vectors";
    }

    private static class TVMapper
    extends TermVectorMapper {
        private IndexReader reader;
        private NamedList docNL;
        FieldOptions fieldOptions;
        private boolean useOffsets;
        private boolean usePositions;
        private NamedList fieldNL;
        private Term currentTerm;

        public TVMapper(IndexReader reader) {
            this.reader = reader;
        }

        public void map(String term, int frequency, TermVectorOffsetInfo[] offsets, int[] positions) {
            int i;
            NamedList termInfo = new NamedList();
            this.fieldNL.add(term, (Object)termInfo);
            if (this.fieldOptions.termFreq) {
                termInfo.add("tf", (Object)frequency);
            }
            if (this.useOffsets) {
                NamedList theOffsets = new NamedList();
                termInfo.add("offsets", (Object)theOffsets);
                for (i = 0; i < offsets.length; ++i) {
                    TermVectorOffsetInfo offset = offsets[i];
                    theOffsets.add("start", (Object)offset.getStartOffset());
                    theOffsets.add("end", (Object)offset.getEndOffset());
                }
            }
            if (this.usePositions) {
                NamedList positionsNL = new NamedList();
                for (i = 0; i < positions.length; ++i) {
                    positionsNL.add("position", (Object)positions[i]);
                }
                termInfo.add("positions", (Object)positionsNL);
            }
            if (this.fieldOptions.docFreq) {
                termInfo.add("df", (Object)this.getDocFreq(term));
            }
            if (this.fieldOptions.tfIdf) {
                double tfIdfVal = (double)frequency / (double)this.getDocFreq(term);
                termInfo.add("tf-idf", (Object)tfIdfVal);
            }
        }

        private int getDocFreq(String term) {
            int result = 1;
            this.currentTerm = this.currentTerm.createTerm(term);
            try {
                TermEnum termEnum = this.reader.terms(this.currentTerm);
                if (termEnum != null && termEnum.term().equals((Object)this.currentTerm)) {
                    result = termEnum.docFreq();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public void setExpectations(String field, int numTerms, boolean storeOffsets, boolean storePositions) {
            if (this.fieldOptions.docFreq && this.reader != null) {
                this.currentTerm = new Term(field);
            }
            this.useOffsets = storeOffsets && this.fieldOptions.offsets;
            this.usePositions = storePositions && this.fieldOptions.positions;
            this.fieldNL = new NamedList();
            this.docNL.add(field, (Object)this.fieldNL);
        }

        public boolean isIgnoringPositions() {
            return !this.fieldOptions.positions;
        }

        public boolean isIgnoringOffsets() {
            return !this.fieldOptions.offsets;
        }
    }
}

