/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import javax.transaction.Synchronization;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.util.WeakIdentityHashMap;

public class PostTransactionWorkQueueSynchronization
implements Synchronization {
    private final QueueingProcessor queueingProcessor;
    private boolean consumed;
    private final WeakIdentityHashMap queuePerTransaction;
    private WorkQueue queue = new WorkQueue();

    public PostTransactionWorkQueueSynchronization(QueueingProcessor queueingProcessor, WeakIdentityHashMap queuePerTransaction) {
        this.queueingProcessor = queueingProcessor;
        this.queuePerTransaction = queuePerTransaction;
    }

    public void add(Work work) {
        this.queueingProcessor.add(work, this.queue);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void beforeCompletion() {
        this.queueingProcessor.prepareWorks(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                this.queueingProcessor.performWorks(this.queue);
            } else {
                this.queueingProcessor.cancelWorks(this.queue);
            }
        }
        finally {
            this.consumed = true;
            if (this.queuePerTransaction != null) {
                this.queuePerTransaction.removeValue(this);
            }
        }
    }

    public void flushWorks() {
        WorkQueue subQueue = this.queue.splitQueue();
        this.queueingProcessor.prepareWorks(subQueue);
        this.queueingProcessor.performWorks(subQueue);
    }
}

