/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ASTFactory;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.gui.AbstractTreeTableModel;
import com.puppycrawl.tools.checkstyle.gui.TreeTableModel;

public class ParseTreeModel
extends AbstractTreeTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Tree", "Type", "Line", "Column", "Text"};

    public ParseTreeModel(DetailAST parseTree) {
        super((Object)ParseTreeModel.createArtificialTreeRoot());
        this.setParseTree(parseTree);
    }

    private static DetailAST createArtificialTreeRoot() {
        ASTFactory factory = new ASTFactory();
        factory.setASTNodeClass(DetailAST.class.getName());
        return (DetailAST)factory.create(1, "ROOT");
    }

    void setParseTree(DetailAST parseTree) {
        DetailAST root = (DetailAST)((Object)this.getRoot());
        root.setFirstChild((AST)parseTree);
        Object[] path = new Object[]{root};
        this.fireTreeStructureChanged(this, path, null, null);
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return TreeTableModel.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return String.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(Object node, int column) {
        DetailAST ast = (DetailAST)((Object)node);
        switch (column) {
            case 0: {
                return null;
            }
            case 1: {
                return TokenTypes.getTokenName(ast.getType());
            }
            case 2: {
                return new Integer(ast.getLineNo());
            }
            case 3: {
                return new Integer(ast.getColumnNo());
            }
            case 4: {
                return ast.getText();
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public Object getChild(Object parent, int index) {
        DetailAST ast = (DetailAST)((Object)parent);
        AST child = ast.getFirstChild();
        for (int i = 0; i < index; ++i) {
            child = child.getNextSibling();
        }
        return child;
    }

    public int getChildCount(Object parent) {
        DetailAST ast = (DetailAST)((Object)parent);
        return ast.getChildCount();
    }
}

