/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;

public class FindHEmismatch
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean hasFields = false;
    boolean visibleOutsidePackage = false;
    boolean hasHashCode = false;
    boolean hasEqualsObject = false;
    boolean hashCodeIsAbstract = false;
    boolean equalsObjectIsAbstract = false;
    boolean equalsMethodIsInstanceOfEquals = false;
    boolean hasCompareToObject = false;
    boolean hasEqualsSelf = false;
    boolean hasCompareToSelf = false;
    boolean extendsObject = false;
    MethodAnnotation equalsMethod = null;
    MethodAnnotation compareToMethod = null;
    MethodAnnotation compareToObjectMethod = null;
    MethodAnnotation compareToSelfMethod = null;
    MethodAnnotation hashCodeMethod = null;
    HashSet<String> nonHashableClasses = new HashSet();
    OpcodeStack stack = new OpcodeStack();
    Map<String, BugInstance> potentialBugs = new HashMap<String, BugInstance>();
    private BugReporter bugReporter;
    static final Pattern mapPattern = Pattern.compile("HashMap<L([^;<]*);");
    static final Pattern hashTablePattern = Pattern.compile("Hashtable<L([^;<]*);");
    static final Pattern setPattern = Pattern.compile("HashSet<L([^;<]*);");

    public boolean isHashableClassName(String dottedClassName) {
        return !this.nonHashableClasses.contains(dottedClassName);
    }

    public FindHEmismatch(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitAfter(JavaClass obj) {
        if (!obj.isClass()) {
            return;
        }
        if (this.getDottedClassName().equals("java.lang.Object")) {
            return;
        }
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 0x200) != 0) {
            return;
        }
        this.visibleOutsidePackage = obj.isPublic() || obj.isProtected();
        String whereEqual = this.getDottedClassName();
        boolean classThatDefinesEqualsIsAbstract = false;
        boolean inheritedHashCodeIsFinal = false;
        boolean inheritedEqualsIsFinal = false;
        boolean inheritedEqualsIsAbstract = false;
        if (!this.hasEqualsObject) {
            JavaClass we = Lookup.findSuperImplementor((JavaClass)obj, (String)"equals", (String)"(Ljava/lang/Object;)Z", (BugReporter)this.bugReporter);
            if (we == null) {
                whereEqual = "java.lang.Object";
            } else {
                whereEqual = we.getClassName();
                classThatDefinesEqualsIsAbstract = we.isAbstract();
                Method m = this.findMethod(we, "equals", "(Ljava/lang/Object;)Z");
                if (m != null && m.isFinal()) {
                    inheritedEqualsIsFinal = true;
                }
                if (m != null && m.isAbstract()) {
                    inheritedEqualsIsAbstract = true;
                }
            }
        }
        boolean usesDefaultEquals = whereEqual.equals("java.lang.Object");
        String whereHashCode = this.getDottedClassName();
        if (!this.hasHashCode) {
            JavaClass wh = Lookup.findSuperImplementor((JavaClass)obj, (String)"hashCode", (String)"()I", (BugReporter)this.bugReporter);
            if (wh == null) {
                whereHashCode = "java.lang.Object";
            } else {
                whereHashCode = wh.getClassName();
                Method m = this.findMethod(wh, "hashCode", "()I");
                if (m != null && m.isFinal()) {
                    inheritedHashCodeIsFinal = true;
                }
            }
        }
        boolean usesDefaultHashCode = whereHashCode.equals("java.lang.Object");
        if (!this.hasEqualsObject && this.hasEqualsSelf) {
            String bugPattern;
            if (usesDefaultEquals) {
                int priority = 1;
                if (usesDefaultHashCode || obj.isAbstract()) {
                    ++priority;
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                bugPattern = "EQ_SELF_USE_OBJECT";
                BugInstance bug = new BugInstance((Detector)this, bugPattern, priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            } else {
                int priority = 2;
                if (this.hasFields) {
                    --priority;
                }
                if (obj.isAbstract()) {
                    ++priority;
                }
                bugPattern = "EQ_SELF_NO_OBJECT";
                String superclassName = obj.getSuperclassName();
                if (superclassName.equals("java.lang.Enum")) {
                    bugPattern = "EQ_DONT_DEFINE_EQUALS_FOR_ENUM";
                    priority = 1;
                }
                BugInstance bug = new BugInstance((Detector)this, bugPattern, priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            }
        }
        if ((this.hasCompareToObject || this.hasCompareToSelf) && usesDefaultEquals) {
            BugInstance bug = new BugInstance((Detector)this, "EQ_COMPARETO_USE_OBJECT_EQUALS", obj.isAbstract() ? 3 : 2).addClass((PreorderVisitor)this);
            if (this.compareToSelfMethod != null) {
                bug.addMethod(this.compareToSelfMethod);
            } else {
                bug.addMethod(this.compareToObjectMethod);
            }
            this.bugReporter.reportBug(bug);
        }
        if (!this.hasCompareToObject && this.hasCompareToSelf && !this.extendsObject) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CO_SELF_NO_OBJECT", 2).addClass(this.getDottedClassName()).addMethod(this.compareToMethod));
        }
        if (this.hasHashCode && !this.hashCodeIsAbstract && !this.hasEqualsObject && !this.hasEqualsSelf) {
            int priority = 3;
            if (usesDefaultEquals) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_HASHCODE_USE_OBJECT_EQUALS", priority).addClass(this.getDottedClassName()).addMethod(this.hashCodeMethod));
            } else if (!inheritedEqualsIsFinal) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_HASHCODE_NO_EQUALS", priority).addClass(this.getDottedClassName()).addMethod(this.hashCodeMethod));
            }
        }
        if (!this.hasHashCode && (this.hasEqualsObject && !this.equalsObjectIsAbstract || this.hasEqualsSelf)) {
            BugInstance bug;
            if (usesDefaultHashCode) {
                int priority = 1;
                if (this.equalsMethodIsInstanceOfEquals) {
                    priority += 2;
                } else if (obj.isAbstract() || !this.hasEqualsObject) {
                    ++priority;
                }
                if (priority == 1) {
                    this.nonHashableClasses.add(this.getDottedClassName());
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                bug = new BugInstance((Detector)this, "HE_EQUALS_USE_HASHCODE", priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            } else if (!inheritedHashCodeIsFinal && !whereHashCode.startsWith("java.util.Abstract")) {
                int priority = 3;
                if (this.hasEqualsObject && inheritedEqualsIsAbstract) {
                    ++priority;
                }
                if (this.hasFields) {
                    --priority;
                }
                if (this.equalsMethodIsInstanceOfEquals || !this.hasEqualsObject) {
                    priority += 2;
                } else if (obj.isAbstract()) {
                    ++priority;
                }
                bug = new BugInstance((Detector)this, "HE_EQUALS_NO_HASHCODE", priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            }
        }
        if (!(this.hasHashCode || this.hasEqualsObject || this.hasEqualsSelf || usesDefaultEquals || !usesDefaultHashCode || obj.isAbstract() || !classThatDefinesEqualsIsAbstract)) {
            BugInstance bug = new BugInstance((Detector)this, "HE_INHERITS_EQUALS_USE_HASHCODE", 2).addClass(this.getDottedClassName());
            if (this.equalsMethod != null) {
                bug.addMethod(this.equalsMethod);
            }
            this.bugReporter.reportBug(bug);
        }
    }

    public void visit(JavaClass obj) {
        this.extendsObject = this.getDottedSuperclassName().equals("java.lang.Object");
        this.hasFields = false;
        this.hasHashCode = false;
        this.hasCompareToObject = false;
        this.hasCompareToSelf = false;
        this.hasEqualsObject = false;
        this.hasEqualsSelf = false;
        this.hashCodeIsAbstract = false;
        this.equalsObjectIsAbstract = false;
        this.equalsMethodIsInstanceOfEquals = false;
        this.equalsMethod = null;
        this.compareToMethod = null;
        this.compareToSelfMethod = null;
        this.compareToObjectMethod = null;
        this.hashCodeMethod = null;
    }

    public void visit(Field obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        if (!obj.getName().startsWith("this$")) {
            this.hasFields = true;
        }
    }

    public void visit(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        String name = obj.getName();
        String sig = obj.getSignature();
        if ((accessFlags & 0x400) != 0) {
            if (name.equals("equals") && sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
            if (name.equals("compareTo") && sig.equals("(L" + this.getClassName() + ";)I")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CO_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
        }
        boolean sigIsObject = sig.equals("(Ljava/lang/Object;)Z");
        if (name.equals("hashCode") && sig.equals("()I")) {
            this.hasHashCode = true;
            if (obj.isAbstract()) {
                this.hashCodeIsAbstract = true;
            }
            this.hashCodeMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
        } else if (name.equals("equals")) {
            if (sigIsObject) {
                Code code;
                byte[] codeBytes;
                this.equalsMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
                this.hasEqualsObject = true;
                if (obj.isAbstract()) {
                    this.equalsObjectIsAbstract = true;
                } else if (!obj.isNative() && ((codeBytes = (code = obj.getCode()).getCode()).length == 5 && (codeBytes[1] & 0xFF) == 193 || codeBytes.length == 15 && (codeBytes[1] & 0xFF) == 193 && (codeBytes[11] & 0xFF) == 183)) {
                    this.equalsMethodIsInstanceOfEquals = true;
                }
            } else if (sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.hasEqualsSelf = true;
                if (this.equalsMethod == null) {
                    this.equalsMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
                }
            }
        } else if (name.equals("compareTo")) {
            MethodAnnotation tmp = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
            if (sig.equals("(Ljava/lang/Object;)I")) {
                this.hasCompareToObject = true;
                this.compareToObjectMethod = this.compareToMethod = tmp;
            } else if (sig.equals("(L" + this.getClassName() + ";)I")) {
                this.hasCompareToSelf = true;
                this.compareToSelfMethod = this.compareToMethod = tmp;
            }
        }
    }

    Method findMethod(JavaClass clazz, String name, String sig) {
        Method[] m;
        Method[] arr$ = m = clazz.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method aM = arr$[i$];
            if (!aM.getName().equals(name) || !aM.getSignature().equals(sig)) continue;
            return aM;
        }
        return null;
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 182) {
            String className = this.getClassConstantOperand();
            if (className.equals("java/util/Map") || className.equals("java/util/HashMap") || className.equals("java/util/LinkedHashMap") || className.equals("java/util/concurrent/ConcurrentHashMap")) {
                if (this.getNameConstantOperand().equals("put") && this.getSigConstantOperand().equals("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;") && this.stack.getStackDepth() >= 3) {
                    this.check(1);
                } else if ((this.getNameConstantOperand().equals("get") || this.getNameConstantOperand().equals("remove")) && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && this.stack.getStackDepth() >= 2) {
                    this.check(0);
                }
            } else if ((className.equals("java/util/Set") || className.equals("java/util/HashSet")) && (this.getNameConstantOperand().equals("add") || this.getNameConstantOperand().equals("contains") || this.getNameConstantOperand().equals("remove") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() >= 2)) {
                this.check(0);
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    private void check(int pos) {
        OpcodeStack.Item item = this.stack.getStackItem(pos);
        JavaClass type = null;
        try {
            type = item.getJavaClass();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        if (type == null) {
            return;
        }
        int priority = 2;
        if (this.getClassConstantOperand().indexOf("Hash") >= 0) {
            --priority;
        }
        if (!AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(type)) {
            ++priority;
        }
        if (type.isAbstract() || type.isInterface()) {
            ++priority;
        }
        this.potentialBugs.put(type.getClassName(), new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClassAndMethod((PreorderVisitor)this).addTypeOfNamedClass(type.getClassName()).describe("TYPE_UNHASHABLE").addTypeOfNamedClass(this.getClassConstantOperand()).addSourceLine((BytecodeScanningDetector)this));
    }

    @CheckForNull
    String findHashedClassInSignature(String sig) {
        Matcher m = mapPattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        m = hashTablePattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        m = setPattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        return null;
    }

    public void visit(Signature obj) {
        String sig = obj.getSignature();
        String className = this.findHashedClassInSignature(sig);
        if (className == null) {
            return;
        }
        JavaClass type = null;
        try {
            type = Repository.lookupClass((String)className);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        if (type == null) {
            return;
        }
        int priority = 2;
        if (sig.indexOf("Hash") >= 0) {
            --priority;
        }
        if (type.isAbstract() || type.isInterface()) {
            ++priority;
        }
        if (!AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(type)) {
            ++priority;
        }
        BugInstance bug = null;
        bug = this.visitingField() ? new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE") : (this.visitingMethod() ? new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClassAndMethod((PreorderVisitor)this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE") : new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClass((PreorderVisitor)this).addClass((PreorderVisitor)this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE"));
        this.potentialBugs.put(className, bug);
    }

    public void report() {
        Iterator<Map.Entry<String, BugInstance>> i$ = this.potentialBugs.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, BugInstance> e = i$.next();
            if (this.isHashableClassName(e.getKey())) continue;
            BugInstance bug = e.getValue();
            this.bugReporter.reportBug(bug);
        }
    }
}

