/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.roydesign.app.Application;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.OSXPaletteHandler;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AboutAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ClearRecentFilesAction;
import org.jhotdraw.app.action.CloseAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExitAction;
import org.jhotdraw.app.action.FocusAction;
import org.jhotdraw.app.action.MaximizeAction;
import org.jhotdraw.app.action.MinimizeAction;
import org.jhotdraw.app.action.NewAction;
import org.jhotdraw.app.action.OSXDropOnDockAction;
import org.jhotdraw.app.action.OSXTogglePaletteAction;
import org.jhotdraw.app.action.OpenAction;
import org.jhotdraw.app.action.OpenRecentAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.PrintAction;
import org.jhotdraw.app.action.RedoAction;
import org.jhotdraw.app.action.SaveAction;
import org.jhotdraw.app.action.SaveAsAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.UndoAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOSXApplication
extends AbstractApplication {
    private OSXPaletteHandler paletteHandler;
    private Project currentProject;
    private Preferences prefs;
    private LinkedList<Action> paletteActions;

    @Override
    public void init() {
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLookAndFeel();
        this.paletteHandler = new OSXPaletteHandler(this);
        this.initLabels();
        this.initApplicationActions();
        this.getModel().initApplication(this);
        this.paletteActions = new LinkedList();
        this.initPalettes(this.paletteActions);
        this.initScreenMenuBar();
    }

    @Override
    public void launch(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        super.launch(args);
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
    }

    protected void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initApplicationActions() {
        ApplicationModel mo = this.getModel();
        mo.putAction("about", new AboutAction(this));
        mo.putAction("exit", new ExitAction(this));
        mo.putAction("osxdrop", new OSXDropOnDockAction(this));
        mo.putAction("new", new NewAction(this));
        mo.putAction("open", new OpenAction(this));
        mo.putAction("clearRecentFiles", new ClearRecentFilesAction(this));
        mo.putAction("save", new SaveAction(this));
        mo.putAction("saveAs", new SaveAsAction(this));
        mo.putAction("print", new PrintAction(this));
        mo.putAction("close", new CloseAction(this));
        mo.putAction("undo", new UndoAction(this));
        mo.putAction("redo", new RedoAction(this));
        mo.putAction("cut", new CutAction());
        mo.putAction("copy", new CopyAction());
        mo.putAction("paste", new PasteAction());
        mo.putAction("delete", new DeleteAction());
        mo.putAction("duplicate", new DuplicateAction());
        mo.putAction("selectAll", new SelectAllAction());
        mo.putAction("maximize", new MaximizeAction(this));
        mo.putAction("minimize", new MinimizeAction(this));
    }

    @Override
    protected void initProjectActions(Project p) {
        p.putAction("focus", new FocusAction(p));
    }

    public void addPalette(Window palette) {
        this.paletteHandler.addPalette(palette);
    }

    public void removePalette(Window palette) {
        this.paletteHandler.removePalette(palette);
    }

    @Override
    public void show(final Project p) {
        if (!p.isShowing()) {
            boolean moved;
            p.setShowing(true);
            File file = p.getFile();
            final JFrame f = new JFrame();
            String title = file == null ? this.labels.getString("unnamedFile") : file.getName();
            f.setTitle(this.labels.getFormatted("frameTitle", title, this.getName(), p.getMultipleOpenId()));
            f.setDefaultCloseOperation(0);
            f.setPreferredSize(new Dimension(400, 400));
            PreferencesUtil.installFramePrefsHandler(this.prefs, "project", f);
            Point loc = f.getLocation();
            block0: do {
                moved = false;
                for (Project aProject : this.projects()) {
                    if (aProject == p || !aProject.isShowing() || !SwingUtilities.getWindowAncestor(aProject.getComponent()).getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block0;
                }
            } while (moved);
            f.setLocation(loc);
            this.paletteHandler.add(f, p);
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    DefaultOSXApplication.this.setCurrentProject(p);
                    DefaultOSXApplication.this.getModel().getAction("close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }
            });
            p.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("hasUnsavedChanges")) {
                        f.getRootPane().putClientProperty("windowModified", new Boolean(p.hasUnsavedChanges()));
                    } else if (name.equals("file")) {
                        f.setTitle(p.getFile() == null ? "Unnamed" : p.getFile().getName());
                    }
                }
            });
            f.setJMenuBar(this.createMenuBar(p));
            f.getContentPane().add(p.getComponent());
            f.setVisible(true);
        }
    }

    @Override
    public void hide(Project p) {
        if (p.isShowing()) {
            JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
            f.setVisible(false);
            f.remove(p.getComponent());
            this.paletteHandler.remove(f, p);
            f.dispose();
        }
    }

    protected JMenuBar createMenuBar(Project p) {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu(p));
        for (JMenu mm : this.getModel().createMenus(this, p)) {
            mb.add(mm);
        }
        mb.add(this.createWindowMenu(p));
        return mb;
    }

    protected JMenu createWindowMenu(final Project p) {
        JMenu m;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ApplicationModel model = this.getModel();
        JMenuBar mb = new JMenuBar();
        final JMenu windowMenu = m = new JMenu();
        labels.configureMenu(m, "window");
        JMenuItem mi = m.add(model.getAction("minimize"));
        mi.setIcon(null);
        mi = m.add(model.getAction("maximize"));
        mi.setIcon(null);
        m.addSeparator();
        for (Project pr : this.projects()) {
            if (pr.getAction("focus") == null) continue;
            windowMenu.add(pr.getAction("focus"));
        }
        if (this.paletteActions.size() > 0) {
            m.addSeparator();
            for (Action a : this.paletteActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                cbmi.setIcon(null);
                m.add(cbmi);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "projectCount" || name == "paletteCount") {
                    if (p == null || DefaultOSXApplication.this.projects().contains(p)) {
                        JMenu m = windowMenu;
                        m.removeAll();
                        m.add(DefaultOSXApplication.this.getModel().getAction("minimize"));
                        m.add(DefaultOSXApplication.this.getModel().getAction("maximize"));
                        m.addSeparator();
                        for (Project pr : DefaultOSXApplication.this.projects()) {
                            if (pr.getAction("focus") == null) continue;
                            m.add(pr.getAction("focus"));
                        }
                        if (DefaultOSXApplication.this.paletteActions.size() > 0) {
                            m.addSeparator();
                            for (Action a : DefaultOSXApplication.this.paletteActions) {
                                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                                Actions.configureJCheckBoxMenuItem(cbmi, a);
                                cbmi.setIcon(null);
                                m.add(cbmi);
                            }
                        }
                    } else {
                        DefaultOSXApplication.this.removePropertyChangeListener(this);
                    }
                }
            }
        });
        return m;
    }

    private void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new OpenRecentAction(this, f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    protected JMenu createFileMenu(Project p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ApplicationModel model = this.getModel();
        JMenu m = new JMenu();
        labels.configureMenu(m, "file");
        JMenuItem mi = m.add(model.getAction("new"));
        mi.setIcon(null);
        mi = m.add(model.getAction("open"));
        mi.setIcon(null);
        final JMenu openRecentMenu = new JMenu();
        labels.configureMenu(openRecentMenu, "openRecent");
        openRecentMenu.setIcon(null);
        openRecentMenu.add(model.getAction("clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        mi = m.add(model.getAction("close"));
        mi.setIcon(null);
        mi = m.add(model.getAction("save"));
        mi.setIcon(null);
        mi = m.add(model.getAction("saveAs"));
        mi.setIcon(null);
        if (model.getAction("export") != null) {
            mi = m.add(model.getAction("export"));
            mi.setIcon(null);
        }
        if (model.getAction("print") != null) {
            m.addSeparator();
            mi = m.add(model.getAction("print"));
            mi.setIcon(null);
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "recentFiles") {
                    DefaultOSXApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    @Override
    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project newValue) {
        Project oldValue = this.currentProject;
        this.currentProject = newValue;
        this.firePropertyChange("currentProject", oldValue, newValue);
    }

    protected void initScreenMenuBar() {
        ApplicationModel model = this.getModel();
        Application mrjapp = Application.getInstance();
        mrjapp.setFramelessJMenuBar(this.createMenuBar(null));
        this.paletteHandler.add(SwingUtilities.getWindowAncestor(mrjapp.getFramelessJMenuBar()), null);
        mrjapp.getAboutJMenuItem().setAction(model.getAction("about"));
        mrjapp.getQuitJMenuItem().setAction(model.getAction("exit"));
        mrjapp.addOpenDocumentListener((ActionListener)model.getAction("osxdrop"));
    }

    protected void initPalettes(final LinkedList<Action> paletteActions) {
        SwingUtilities.invokeLater(new Worker(){

            public Object construct() {
                LinkedList<JFrame> palettes = new LinkedList<JFrame>();
                LinkedList<JToolBar> toolBars = new LinkedList<JToolBar>(DefaultOSXApplication.this.getModel().createToolBars(DefaultOSXApplication.this, null));
                int i = 0;
                int x = 0;
                for (JToolBar tb : toolBars) {
                    ++i;
                    tb.setFloatable(false);
                    tb.setOrientation(1);
                    tb.setFocusable(false);
                    JFrame d = new JFrame();
                    d.setFocusable(false);
                    d.setResizable(false);
                    d.getContentPane().setLayout(new BorderLayout());
                    d.getContentPane().add((Component)tb, "Center");
                    d.setAlwaysOnTop(true);
                    d.setUndecorated(true);
                    d.getRootPane().setWindowDecorationStyle(1);
                    d.getRootPane().setFont(new Font("Lucida Grande", 0, 11));
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isVertical", Boolean.FALSE);
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
                    d.setJMenuBar(DefaultOSXApplication.this.createMenuBar(null));
                    d.pack();
                    d.setFocusableWindowState(false);
                    PreferencesUtil.installPalettePrefsHandler(DefaultOSXApplication.this.prefs, "toolbar." + i, d, x);
                    x += d.getWidth();
                    paletteActions.add(new OSXTogglePaletteAction(DefaultOSXApplication.this, d, tb.getName()));
                    palettes.add(d);
                }
                return palettes;
            }

            public void finished(Object result) {
                LinkedList palettes = (LinkedList)result;
                if (palettes != null) {
                    for (JFrame p : palettes) {
                        DefaultOSXApplication.this.addPalette(p);
                    }
                    DefaultOSXApplication.this.firePropertyChange("paletteCount", 0, palettes.size());
                }
            }
        });
    }

    @Override
    public boolean isSharingToolsAmongProjects() {
        return true;
    }

    @Override
    public Component getComponent() {
        return null;
    }
}

