/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Frame;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractSaveBeforeAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class LoadRecentAction
extends AbstractSaveBeforeAction {
    public static final String ID = "loadRecent";
    private File file;

    public LoadRecentAction(Application app, File file) {
        super(app);
        this.file = file;
        this.putValue("Name", file.getName());
    }

    public void doIt(final Project project) {
        Application app = this.getApplication();
        app.setEnabled(true);
        int multipleOpenId = 1;
        for (Project aProject : app.projects()) {
            if (aProject == project || aProject.getFile() == null || !aProject.getFile().equals(this.file)) continue;
            multipleOpenId = Math.max(multipleOpenId, aProject.getMultipleOpenId() + 1);
        }
        project.setMultipleOpenId(multipleOpenId);
        project.execute(new Worker(){

            public Object construct() {
                try {
                    project.read(LoadRecentAction.this.file);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                LoadRecentAction.this.fileOpened(project, LoadRecentAction.this.file, value);
            }
        });
    }

    protected void fileOpened(Project project, File file, Object value) {
        Application app = this.getApplication();
        if (value == null) {
            project.setFile(file);
            project.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(project.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            project.getComponent().requestFocus();
            if (app != null) {
                app.setEnabled(true);
            }
        } else {
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
            }
            JSheet.showMessageSheet(project.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                }
            });
        }
    }
}

