/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import org.jhotdraw.application.AbstractOSXApplication;
import org.jhotdraw.application.DocumentView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSXPaletteHandler {
    private HashSet<Window> palettes = new HashSet();
    private HashMap<Window, DocumentView> windows = new HashMap();
    private static OSXPaletteHandler instance;
    private Timer timer;
    private AbstractOSXApplication application;
    private WindowFocusListener focusHandler = new WindowFocusListener(){

        public void windowGainedFocus(WindowEvent e) {
            OSXPaletteHandler.this.timer.stop();
            if (OSXPaletteHandler.this.windows.containsKey(e.getWindow())) {
                OSXPaletteHandler.this.application.setCurrentView((DocumentView)OSXPaletteHandler.this.windows.get(e.getWindow()));
                OSXPaletteHandler.this.showPalettes();
            }
        }

        public void windowLostFocus(WindowEvent e) {
            OSXPaletteHandler.this.timer.restart();
        }
    };

    public OSXPaletteHandler(AbstractOSXApplication application) {
        this.application = application;
        this.timer = new Timer(60, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OSXPaletteHandler.this.maybeHidePalettes();
            }
        });
        this.timer.setRepeats(false);
    }

    public void add(Window window, DocumentView documentView) {
        window.addWindowFocusListener(this.focusHandler);
        this.windows.put(window, documentView);
    }

    public void remove(Window window, DocumentView documentView) {
        this.windows.remove(window);
        window.removeWindowFocusListener(this.focusHandler);
    }

    public void addPalette(Window palette) {
        palette.addWindowFocusListener(this.focusHandler);
        this.palettes.add(palette);
    }

    public void removePalette(Window palette) {
        this.palettes.remove(palette);
        palette.removeWindowFocusListener(this.focusHandler);
    }

    public Set<Window> getPalettes() {
        return Collections.unmodifiableSet(this.palettes);
    }

    private void showPalettes() {
        for (Window palette : this.palettes) {
            if (palette.isVisible()) continue;
            palette.setVisible(true);
        }
    }

    private boolean isFocused(Window w) {
        if (w.isFocused()) {
            return true;
        }
        Window[] ownedWindows = w.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            if (!this.isFocused(ownedWindows[i])) continue;
            return true;
        }
        return false;
    }

    private void maybeHidePalettes() {
        boolean hasFocus = false;
        for (Window window : this.windows.keySet()) {
            if (!this.isFocused(window)) continue;
            hasFocus = true;
            break;
        }
        if (!hasFocus && this.windows.size() > 0) {
            for (Window palette : this.palettes) {
                if (!this.isFocused(palette)) continue;
                hasFocus = true;
                break;
            }
        }
        if (!hasFocus) {
            for (Window palette : this.palettes) {
                palette.setVisible(false);
            }
        }
    }
}

