/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jhotdraw.application.EditableComponent;
import org.jhotdraw.application.action.AbstractApplicationAction;

public class DeleteAction
extends AbstractApplicationAction {
    public static final String ID = "Edit.delete";

    public DeleteAction() {
        this.initActionProperties(ID);
    }

    public void actionPerformed(ActionEvent evt) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (focusOwner != null && focusOwner instanceof EditableComponent) {
            ((EditableComponent)((Object)focusOwner)).delete();
        } else if (focusOwner instanceof JTextComponent) {
            this.deleteNextChar(evt, (JTextComponent)focusOwner);
        }
    }

    public void deleteNextChar(ActionEvent e, JTextComponent target) {
        boolean beep = true;
        if (target != null && target.isEditable()) {
            try {
                Document doc = target.getDocument();
                Caret caret = target.getCaret();
                int dot = caret.getDot();
                int mark = caret.getMark();
                if (dot != mark) {
                    doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    beep = false;
                } else if (dot < doc.getLength()) {
                    doc.remove(dot, 1);
                    beep = false;
                }
            }
            catch (BadLocationException bl) {
                // empty catch block
            }
        }
        if (beep) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

