/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import application.ApplicationContext;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import org.jhotdraw.application.AbstractOSXApplication;

public class OSXTogglePaletteAction
extends AbstractAction {
    private Window palette;
    private WindowListener windowHandler = new WindowAdapter(){

        public void windowClosing(WindowEvent evt) {
            OSXTogglePaletteAction.this.putValue("selected", false);
        }
    };

    public OSXTogglePaletteAction(Window palette, String label) {
        super(label);
        this.setPalette(palette);
        this.putValue("selected", true);
    }

    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
        if (key == "selected" && this.palette != null) {
            AbstractOSXApplication application = this.getApplication();
            boolean b = (Boolean)newValue;
            if (b) {
                application.addPalette(this.palette);
                this.palette.setVisible(true);
            } else {
                application.removePalette(this.palette);
                this.palette.setVisible(false);
            }
        }
    }

    public void setPalette(Window newValue) {
        AbstractOSXApplication application = this.getApplication();
        if (this.palette != null) {
            this.palette.removeWindowListener(this.windowHandler);
        }
        this.palette = newValue;
        if (this.palette != null) {
            this.palette.addWindowListener(this.windowHandler);
            if (this.getValue("selected") == Boolean.TRUE) {
                application.addPalette(this.palette);
                this.palette.setVisible(true);
            } else {
                application.removePalette(this.palette);
                this.palette.setVisible(false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.palette != null) {
            this.putValue("selected", !this.palette.isVisible());
        }
    }

    public AbstractOSXApplication getApplication() {
        return (AbstractOSXApplication)ApplicationContext.getInstance().getApplication();
    }
}

