/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDrawing
extends AbstractBean
implements Drawing {
    private static final Object lock = new JPanel().getTreeLock();
    protected EventListenerList listenerList = new EventListenerList();
    private FontRenderContext fontRenderContext;
    private List<InputFormat> inputFormats = new LinkedList<InputFormat>();
    private List<OutputFormat> outputFormats = new LinkedList<OutputFormat>();

    @Override
    public void addDrawingListener(DrawingListener listener) {
        this.listenerList.add(DrawingListener.class, listener);
    }

    @Override
    public void removeDrawingListener(DrawingListener listener) {
        this.listenerList.remove(DrawingListener.class, listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    @Override
    public final void addAll(Collection<Figure> figures) {
        this.addAll(this.getFigureCount(), figures);
    }

    @Override
    public final void addAll(int index, Collection<Figure> figures) {
        for (Figure f : figures) {
            this.add(index++, f);
        }
    }

    @Override
    public void clear() {
        this.removeAll(this.getFigures());
    }

    @Override
    public int getFigureCount() {
        return this.getFigures().size();
    }

    @Override
    public void removeAll(Collection<Figure> toBeRemoved) {
        CompositeEdit edit = new CompositeEdit("Figuren entfernen");
        for (Figure f : new ArrayList<Figure>(toBeRemoved)) {
            this.remove(f);
        }
    }

    @Override
    public void basicAddAll(int index, Collection<Figure> figures) {
        for (Figure f : figures) {
            this.basicAdd(index++, f);
        }
    }

    @Override
    public void basicRemoveAll(Collection<Figure> toBeOrphaned) {
        for (Figure f : new ArrayList<Figure>(toBeOrphaned)) {
            this.basicRemove(f);
        }
    }

    @Override
    public final void add(Figure figure) {
        this.add(this.getFigureCount(), figure);
    }

    @Override
    public final void add(int index, Figure figure) {
        this.basicAdd(index, figure);
        figure.addNotify(this);
        this.fireFigureAdded(figure, index);
        this.fireAreaInvalidated(figure.getDrawingArea());
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getFigureCount(), figure);
    }

    @Override
    public final void remove(Figure figure) {
        if (this.contains(figure)) {
            int index = this.indexOf(figure);
            this.basicRemove(figure);
            figure.removeNotify(this);
            this.fireFigureRemoved(figure, index);
        } else {
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    protected void fireAreaInvalidated(Rectangle2D.Double dirtyRegion) {
        DrawingEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrawingListener.class) continue;
            if (event == null) {
                event = new DrawingEvent(this, null, dirtyRegion);
            }
            ((DrawingListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    @Override
    public void fireUndoableEditHappened(UndoableEdit edit) {
        UndoableEditEvent event = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (event == null) {
                    event = new UndoableEditEvent(this, edit);
                }
                if (listeners[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(event);
            }
        }
    }

    protected void fireFigureAdded(Figure f, int zIndex) {
        DrawingEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrawingListener.class) continue;
            if (event == null) {
                event = new DrawingEvent(this, f, f.getDrawingArea(), zIndex);
            }
            ((DrawingListener)listeners[i + 1]).figureAdded(event);
        }
    }

    protected void fireFigureRemoved(Figure f, int zIndex) {
        DrawingEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrawingListener.class) continue;
            if (event == null) {
                event = new DrawingEvent(this, f, f.getDrawingArea(), zIndex);
            }
            ((DrawingListener)listeners[i + 1]).figureRemoved(event);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void setFontRenderContext(FontRenderContext frc) {
        this.fontRenderContext = frc;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement("figures");
        for (int i = 0; i < in.getElementCount(); ++i) {
            Figure f = (Figure)in.readObject(i);
            this.add(f);
        }
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("figures");
        for (Figure f : this.getFigures()) {
            out.writeObject(f);
        }
        out.closeElement();
    }

    @Override
    public Object getLock() {
        return lock;
    }

    @Override
    public void setOutputFormats(List<OutputFormat> formats) {
        this.outputFormats = formats;
    }

    @Override
    public void setInputFormats(List<InputFormat> formats) {
        this.inputFormats = formats;
    }

    @Override
    public List<InputFormat> getInputFormats() {
        return this.inputFormats;
    }

    @Override
    public List<OutputFormat> getOutputFormats() {
        return this.outputFormats;
    }
}

