/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.BezierOutlineHandle;
import org.jhotdraw.draw.BezierScaleHandle;
import org.jhotdraw.draw.ChopBezierConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierFigure
extends AbstractAttributedFigure {
    protected BezierPath path = new BezierPath();
    private transient BezierPath cappedPath;

    public BezierFigure() {
        this(false);
    }

    public BezierFigure(boolean isClosed) {
        AttributeKeys.CLOSED.basicSet(this, isClosed);
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopBezierConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return new ChopBezierConnector(this);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        if (this.isClosed()) {
            double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
            if (grow == 0.0) {
                g.draw(this.path);
            } else {
                GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT.get(this)));
                g.draw(gs.createStrokedShape(this.path));
            }
        } else {
            g.draw(this.getCappedPath());
        }
        this.drawCaps(g);
    }

    protected void drawCaps(Graphics2D g) {
        if (this.getNodeCount() > 1) {
            Point2D.Double p2;
            Point2D.Double p1;
            BezierPath cp;
            if (AttributeKeys.START_DECORATION.get(this) != null) {
                cp = this.getCappedPath();
                p1 = this.path.get(0, 0);
                p2 = cp.get(0, 0);
                if (p2.equals(p1)) {
                    p2 = this.path.get(1, 0);
                }
                AttributeKeys.START_DECORATION.get(this).draw(g, this, p1, p2);
            }
            if (AttributeKeys.END_DECORATION.get(this) != null) {
                cp = this.getCappedPath();
                p1 = this.path.get(this.path.size() - 1, 0);
                p2 = cp.get(this.path.size() - 1, 0);
                if (p2.equals(p1)) {
                    p2 = this.path.get(this.path.size() - 2, 0);
                }
                AttributeKeys.END_DECORATION.get(this).draw(g, this, p1, p2);
            }
        }
    }

    @Override
    protected void drawFill(Graphics2D g) {
        if (this.isClosed() || AttributeKeys.FILL_OPEN_PATH.get(this).booleanValue()) {
            double grow = AttributeKeys.getPerpendicularFillGrowth(this);
            if (grow == 0.0) {
                g.fill(this.path);
            } else {
                GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT.get(this)));
                g.fill(gs.createStrokedShape(this.path));
            }
        }
    }

    @Override
    public boolean contains(Point2D.Double p) {
        double tolerance = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (this.isClosed() || AttributeKeys.FILL_COLOR.get(this) != null && AttributeKeys.FILL_OPEN_PATH.get(this).booleanValue()) {
            if (this.path.contains(p)) {
                return true;
            }
            double grow = AttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT.get(this)));
            if (gs.createStrokedShape(this.path).contains(p)) {
                return true;
            }
            if (this.isClosed()) {
                return false;
            }
        }
        if (!this.isClosed()) {
            Point2D.Double p2;
            Point2D.Double p1;
            if (this.getCappedPath().outlineContains(p, tolerance)) {
                return true;
            }
            if (AttributeKeys.START_DECORATION.get(this) != null) {
                BezierPath cp = this.getCappedPath();
                p1 = this.path.get(0, 0);
                p2 = cp.get(0, 0);
                if (Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, p.x, p.y, tolerance)) {
                    return true;
                }
            }
            if (AttributeKeys.END_DECORATION.get(this) != null) {
                BezierPath cp = this.getCappedPath();
                p1 = this.path.get(this.path.size() - 1, 0);
                p2 = cp.get(this.path.size() - 1, 0);
                if (Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, p.x, p.y, tolerance)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean canConnect() {
        return this.isClosed();
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                handles.add(new BezierOutlineHandle(this));
                int n = this.path.size();
                for (int i = 0; i < n; ++i) {
                    handles.add(new BezierNodeHandle(this, i));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                handles.add(new BezierScaleHandle(this));
            }
        }
        return handles;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double bounds = this.path.getBounds2D();
        bounds.width = Math.max(1.0, bounds.width);
        bounds.height = Math.max(1.0, bounds.height);
        return bounds;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        if (this.getNodeCount() > 1) {
            Point2D.Double p2;
            Point2D.Double p1;
            if (AttributeKeys.START_DECORATION.get(this) != null) {
                p1 = this.getPoint(0, 0);
                p2 = this.getPoint(1, 0);
                r.add(AttributeKeys.START_DECORATION.get(this).getDrawingArea(this, p1, p2));
            }
            if (AttributeKeys.END_DECORATION.get(this) != null) {
                p1 = this.getPoint(this.getNodeCount() - 1, 0);
                p2 = this.getPoint(this.getNodeCount() - 2, 0);
                r.add(AttributeKeys.END_DECORATION.get(this).getDrawingArea(this, p1, p2));
            }
        }
        return r;
    }

    @Override
    protected void validate() {
        super.validate();
        this.path.invalidatePath();
        this.cappedPath = null;
    }

    public BezierPath getBezierPath() {
        return this.path.clone();
    }

    public void setBezierPath(BezierPath newValue) {
        this.path = newValue.clone();
        this.setClosed(newValue.isClosed());
    }

    public Point2D.Double getPointOnPath(float relative, double flatness) {
        return this.path.getPointOnPath(relative, flatness);
    }

    public boolean isClosed() {
        return (Boolean)this.getAttribute(AttributeKeys.CLOSED);
    }

    public void setClosed(boolean newValue) {
        AttributeKeys.CLOSED.set(this, (Boolean)newValue);
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        if (key == AttributeKeys.CLOSED) {
            this.path.setClosed((Boolean)newValue);
        } else if (key == AttributeKeys.WINDING_RULE) {
            this.path.setWindingRule(newValue == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
        }
        super.setAttribute(key, newValue);
        this.invalidate();
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.setStartPoint(anchor);
        this.setEndPoint(lead);
        this.invalidate();
    }

    @Override
    public void transform(AffineTransform tx) {
        this.path.transform(tx);
        this.invalidate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.path.invalidatePath();
        this.cappedPath = null;
    }

    protected BezierPath getCappedPath() {
        if (this.cappedPath == null) {
            this.cappedPath = this.path.clone();
            if (this.isClosed()) {
                this.cappedPath.setClosed(true);
            } else if (this.cappedPath.size() > 1) {
                double lineLength;
                double radius;
                Point2D.Double pp;
                BezierPath.Node p1;
                BezierPath.Node p0;
                if (AttributeKeys.START_DECORATION.get(this) != null) {
                    p0 = (BezierPath.Node)this.cappedPath.get(0);
                    p1 = (BezierPath.Node)this.cappedPath.get(1);
                    pp = (p0.getMask() & 2) != 0 ? p0.getControlPoint(2) : ((p1.getMask() & 1) != 0 ? p1.getControlPoint(1) : p1.getControlPoint(0));
                    radius = AttributeKeys.START_DECORATION.get(this).getDecorationRadius(this);
                    lineLength = Geom.length(p0.getControlPoint(0), pp);
                    this.cappedPath.set(0, 0, Geom.cap(pp, p0.getControlPoint(0), -Math.min(radius, lineLength)));
                }
                if (AttributeKeys.END_DECORATION.get(this) != null) {
                    p0 = (BezierPath.Node)this.cappedPath.get(this.cappedPath.size() - 1);
                    p1 = (BezierPath.Node)this.cappedPath.get(this.cappedPath.size() - 2);
                    pp = (p0.getMask() & 1) != 0 ? p0.getControlPoint(1) : ((p1.getMask() & 2) != 0 ? p1.getControlPoint(2) : p1.getControlPoint(0));
                    radius = AttributeKeys.END_DECORATION.get(this).getDecorationRadius(this);
                    lineLength = Geom.length(p0.getControlPoint(0), pp);
                    this.cappedPath.set(this.cappedPath.size() - 1, 0, Geom.cap(pp, p0.getControlPoint(0), -Math.min(radius, lineLength)));
                }
                this.cappedPath.invalidatePath();
            }
        }
        return this.cappedPath;
    }

    public void layout() {
    }

    public void addNode(BezierPath.Node p) {
        this.addNode(this.getNodeCount(), p);
    }

    public void addNode(int index, BezierPath.Node p) {
        BezierPath.Node newPoint = new BezierPath.Node(p);
        this.path.add(index, p);
        this.invalidate();
    }

    public void setNode(int index, BezierPath.Node p) {
        this.path.set(index, p);
        this.invalidate();
    }

    public BezierPath.Node getNode(int index) {
        return (BezierPath.Node)((BezierPath.Node)this.path.get(index)).clone();
    }

    public Point2D.Double getPoint(int index) {
        return ((BezierPath.Node)this.path.get(index)).getControlPoint(0);
    }

    public Point2D.Double getPoint(int index, int coord) {
        return ((BezierPath.Node)this.path.get(index)).getControlPoint(coord);
    }

    public void setPoint(int index, Point2D.Double p) {
        BezierPath.Node node = (BezierPath.Node)this.path.get(index);
        double dx = p.x - node.x[0];
        double dy = p.y - node.y[0];
        int i = 0;
        while (i < node.x.length) {
            int n = i;
            node.x[n] = node.x[n] + dx;
            int n2 = i++;
            node.y[n2] = node.y[n2] + dy;
        }
        this.invalidate();
    }

    public void setPoint(int index, int coord, Point2D.Double p) {
        BezierPath.Node cp = new BezierPath.Node((BezierPath.Node)this.path.get(index));
        cp.setControlPoint(coord, p);
        this.setNode(index, cp);
    }

    public void setStartPoint(Point2D.Double p) {
        for (int i = this.getNodeCount(); i < 2; ++i) {
            this.addNode(0, new BezierPath.Node(p.x, p.y));
        }
        this.setPoint(0, p);
    }

    public void setEndPoint(Point2D.Double p) {
        for (int i = this.getNodeCount(); i < 2; ++i) {
            this.addNode(0, new BezierPath.Node(p.x, p.y));
        }
        this.setPoint(this.getNodeCount() - 1, p);
    }

    @Override
    public Point2D.Double getStartPoint() {
        return this.getPoint(0, 0);
    }

    @Override
    public Point2D.Double getEndPoint() {
        return this.getPoint(this.getNodeCount() - 1, 0);
    }

    public int findNode(Point2D.Double p) {
        BezierPath tp = this.path;
        for (int i = 0; i < tp.size(); ++i) {
            BezierPath.Node p2 = (BezierPath.Node)tp.get(i);
            if (p2.x[0] != p.x || p2.y[0] != p.y) continue;
            return i;
        }
        return -1;
    }

    public int findSegment(Point2D.Double find) {
        int n = this.getNodeCount() - 1;
        for (int i = 0; i < n; ++i) {
            Point2D.Double p1 = this.path.get(i, 0);
            Point2D.Double p2 = this.path.get(i + 1, 0);
            if (!Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, find.x, find.y, 3.0)) continue;
            return i;
        }
        return -1;
    }

    public boolean joinSegments(Point2D.Double join) {
        int i = this.findSegment(join);
        if (i != -1 && i > 1) {
            this.removeNode(i);
            return true;
        }
        return false;
    }

    public int splitSegment(Point2D.Double split) {
        int i = this.findSegment(split);
        if (i != -1) {
            this.addNode(i + 1, new BezierPath.Node(split));
        }
        return i + 1;
    }

    protected BezierPath.Node removeNode(int index) {
        return (BezierPath.Node)this.path.remove(index);
    }

    protected void removeAllNodes() {
        this.path.clear();
    }

    public int getNodeCount() {
        return this.path.size();
    }

    @Override
    public BezierFigure clone() {
        BezierFigure that = (BezierFigure)super.clone();
        that.path = this.path.clone();
        that.invalidate();
        return that;
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.path.setTo((BezierPath)geometry);
    }

    @Override
    public Object getTransformRestoreData() {
        return this.path.clone();
    }

    public Point2D.Double chop(Point2D.Double p) {
        if (this.isClosed()) {
            double grow = AttributeKeys.getPerpendicularHitGrowth(this);
            if (grow == 0.0) {
                return this.path.chop(p);
            }
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT.get(this)));
            return Geom.chop(gs.createStrokedShape(this.path), p);
        }
        return this.path.chop(p);
    }

    public Point2D.Double getCenter() {
        return this.path.getCenter();
    }

    public Point2D.Double getOutermostPoint() {
        return ((BezierPath.Node)this.path.get(this.path.indexOfOutermostNode())).getControlPoint(0);
    }

    public int joinSegments(Point2D.Double join, float tolerance) {
        return this.path.joinSegments(join, tolerance);
    }

    public int splitSegment(Point2D.Double split, float tolerance) {
        return this.path.splitSegment(split, tolerance);
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() % 2 == 0) {
            this.willChange();
            final int index = this.splitSegment(p, (float)(5.0 / view.getScaleFactor()));
            if (index != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                        return labels.getString("bezierPath.splitSegment");
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        BezierFigure.this.willChange();
                        BezierFigure.this.addNode(index, newNode);
                        BezierFigure.this.changed();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        BezierFigure.this.willChange();
                        BezierFigure.this.removeNode(index);
                        BezierFigure.this.changed();
                    }
                });
                this.changed();
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        this.writePoints(out);
        this.writeAttributes(out);
    }

    protected void writePoints(DOMOutput out) throws IOException {
        out.openElement("points");
        if (this.isClosed()) {
            out.addAttribute("closed", true);
        }
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            BezierPath.Node node = this.getNode(i);
            out.openElement("p");
            out.addAttribute("mask", node.mask, 0);
            out.addAttribute("colinear", true);
            out.addAttribute("x", node.x[0]);
            out.addAttribute("y", node.y[0]);
            out.addAttribute("c1x", node.x[1], node.x[0]);
            out.addAttribute("c1y", node.y[1], node.y[0]);
            out.addAttribute("c2x", node.x[2], node.x[0]);
            out.addAttribute("c2y", node.y[2], node.y[0]);
            out.closeElement();
        }
        out.closeElement();
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.readPoints(in);
        this.readAttributes(in);
    }

    protected void readPoints(DOMInput in) throws IOException {
        this.path.clear();
        in.openElement("points");
        this.setClosed(in.getAttribute("closed", false));
        int n = in.getElementCount("p");
        for (int i = 0; i < n; ++i) {
            in.openElement("p", i);
            BezierPath.Node node = new BezierPath.Node(in.getAttribute("mask", 0), in.getAttribute("x", 0.0), in.getAttribute("y", 0.0), in.getAttribute("c1x", in.getAttribute("x", 0.0)), in.getAttribute("c1y", in.getAttribute("y", 0.0)), in.getAttribute("c2x", in.getAttribute("x", 0.0)), in.getAttribute("c2y", in.getAttribute("y", 0.0)));
            node.keepColinear = in.getAttribute("colinear", true);
            this.path.add(node);
            this.path.invalidatePath();
            in.closeElement();
        }
        in.closeElement();
    }
}

