/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;

public class DragTracker
extends AbstractTool {
    Figure anchorFigure;
    Point2D.Double oldPoint;
    Point2D.Double anchorPoint;
    private boolean isDragging;

    public DragTracker(Figure figure) {
        this.anchorFigure = figure;
    }

    public void mouseMoved(MouseEvent evt) {
        this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        DrawingView view = this.getView();
        if (evt.isShiftDown()) {
            view.setHandleDetailLevel(0);
            view.toggleSelection(this.anchorFigure);
            if (!view.isFigureSelected(this.anchorFigure)) {
                this.anchorFigure = null;
            }
        } else if (!view.isFigureSelected(this.anchorFigure)) {
            view.setHandleDetailLevel(0);
            view.clearSelection();
            view.addToSelection(this.anchorFigure);
        }
        Point2D.Double origin = new Point2D.Double(Double.MAX_VALUE, Double.MAX_VALUE);
        for (Figure f : view.getSelectedFigures()) {
            Rectangle2D.Double b = f.getBounds();
            origin.x = Math.min(origin.x, b.x);
            origin.y = Math.min(origin.y, b.y);
        }
        Point2D.Double constrainedOrigin = view.getConstrainer().constrainPoint(new Point2D.Double(origin.x, origin.y));
        this.oldPoint = view.getConstrainer().constrainPoint(view.viewToDrawing(new Point(evt.getX(), evt.getY())));
        this.oldPoint.x += origin.x - constrainedOrigin.x;
        this.oldPoint.y += origin.y - constrainedOrigin.y;
        this.anchorPoint = this.oldPoint;
    }

    public void mouseDragged(MouseEvent evt) {
        DrawingView view = this.getView();
        this.isDragging = false;
        if (false) {
            this.isDragging = true;
            this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
        }
        Point2D.Double newPoint = view.getConstrainer().constrainPoint(view.viewToDrawing(new Point(evt.getX(), evt.getY())));
        AffineTransform tx = new AffineTransform();
        tx.translate(newPoint.x - this.oldPoint.x, newPoint.y - this.oldPoint.y);
        for (Figure f : view.getSelectedFigures()) {
            f.willChange();
            f.transform(tx);
            f.changed();
        }
        this.oldPoint = newPoint;
    }

    public void mouseReleased(MouseEvent evt) {
        super.mouseReleased(evt);
        this.isDragging = false;
        int x = evt.getX();
        int y = evt.getY();
        this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
        Point2D.Double p = this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(new Point(x, y)));
        LinkedList<Figure> draggedFigures = new LinkedList<Figure>(this.getView().getSelectedFigures());
        Figure dropTarget = this.getDrawing().findFigureExcept(p, draggedFigures);
        if (dropTarget != null) {
            boolean snapBack = dropTarget.handleDrop(p, draggedFigures, this.getView());
            if (snapBack) {
                AffineTransform tx = new AffineTransform();
                tx.translate(this.anchorPoint.x - this.oldPoint.x, this.anchorPoint.y - this.oldPoint.y);
                for (Figure f : draggedFigures) {
                    f.willChange();
                    f.transform(tx);
                    f.changed();
                }
            } else {
                AffineTransform tx = new AffineTransform();
                tx.translate(-this.anchorPoint.x + this.oldPoint.x, -this.anchorPoint.y + this.oldPoint.y);
                if (!tx.isIdentity()) {
                    this.getDrawing().fireUndoableEditHappened(new TransformEdit(draggedFigures, tx));
                }
            }
        } else {
            AffineTransform tx = new AffineTransform();
            tx.translate(-this.anchorPoint.x + this.oldPoint.x, -this.anchorPoint.y + this.oldPoint.y);
            if (!tx.isIdentity()) {
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(draggedFigures, tx));
            }
        }
        this.fireToolDone();
    }
}

