/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractEditorAction
extends AbstractAction {
    protected DrawingEditor editor;
    protected static final ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                AbstractEditorAction.this.updateEnabledState();
            }
        }
    };

    public AbstractEditorAction(DrawingEditor editor) {
        this.editor = editor;
        if (editor != null) {
            editor.addPropertyChangeListener(this.propertyChangeHandler);
            this.updateEnabledState();
        }
    }

    public void setEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.propertyChangeHandler);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.propertyChangeHandler);
            this.updateEnabledState();
        }
    }

    public void updateEnabledState() {
        this.setEnabled(this.editor != null && this.editor.isEnabled());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.getDrawing().fireUndoableEditHappened(edit);
    }
}

