/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private Set<AttributeKey> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public ApplyAttributesAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, "attributesApply");
        this.setEnabled(true);
    }

    public void setExcludedAttributes(Set<AttributeKey> a) {
        this.excludedAttributes = a;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.applyAttributes();
    }

    public void applyAttributes() {
        DrawingEditor editor = this.getEditor();
        CompositeEdit edit = new CompositeEdit(this.labels.getString("attributesApply"));
        DrawingView view = this.getView();
        view.getDrawing().fireUndoableEditHappened(edit);
        for (Map.Entry<AttributeKey, Object> entry : editor.getDefaultAttributes().entrySet()) {
            if (this.excludedAttributes.contains(entry.getKey())) continue;
            for (Figure figure : view.getSelectedFigures()) {
                figure.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        view.getDrawing().fireUndoableEditHappened(edit);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

