/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jhotdraw.geom.BezierPath;

public class Bezier {
    private static final int MAXPOINTS = 1000;

    private Bezier() {
    }

    public static void main(String[] args) {
        Point2D.Double[] d = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.5), new Point2D.Double(1.1, 1.4), new Point2D.Double(2.1, 1.6), new Point2D.Double(3.2, 1.1), new Point2D.Double(4.0, 0.2), new Point2D.Double(4.0, 0.0)};
        double error = 4.0;
        GeneralPath path = Bezier.fitCurve(d, error);
        System.out.println(path);
    }

    public static GeneralPath fitCurve(Polygon p, double error) {
        Point2D.Double[] d = new Point2D.Double[p.npoints];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new Point2D.Double(p.xpoints[i], p.ypoints[i]);
        }
        return Bezier.fitCurve(d, error);
    }

    public static GeneralPath fitCurve(Point2D.Double[] d, double error) {
        Point2D.Double tHat1 = new Point2D.Double();
        Point2D.Double tHat2 = new Point2D.Double();
        GeneralPath bezierPath = new GeneralPath();
        bezierPath.moveTo((float)d[0].x, (float)d[0].y);
        tHat1 = Bezier.computeLeftTangent(d, 0);
        tHat2 = Bezier.computeRightTangent(d, d.length - 1);
        Bezier.fitCubic(d, 0, d.length - 1, tHat1, tHat2, error, bezierPath);
        return bezierPath;
    }

    public static BezierPath fitBezierCurve(BezierPath path, double error) {
        Point2D.Double[] d = path.toPolygonArray();
        Point2D.Double tHat1 = new Point2D.Double();
        Point2D.Double tHat2 = new Point2D.Double();
        BezierPath bezierPath = new BezierPath();
        bezierPath.add(new BezierPath.Node(d[0]));
        tHat1 = Bezier.computeLeftTangent(d, 0);
        tHat2 = Bezier.computeRightTangent(d, d.length - 1);
        Bezier.fitCubic(d, 0, d.length - 1, tHat1, tHat2, error, bezierPath);
        bezierPath.setClosed(path.isClosed());
        return bezierPath;
    }

    private static void fitCubic(Point2D.Double[] d, int first, int last, Point2D.Double tHat1, Point2D.Double tHat2, double error, GeneralPath bezierPath) {
        int[] splitPoint = new int[1];
        int maxIterations = 4;
        Point2D.Double tHatCenter = new Point2D.Double();
        double iterationError = error * error;
        int nPts = last - first + 1;
        if (nPts == 2) {
            double dist = Bezier.v2DistanceBetween2Points(d[last], d[first]) / 3.0;
            Point2D.Double[] bezCurve = new Point2D.Double[4];
            for (int i = 0; i < bezCurve.length; ++i) {
                bezCurve[i] = new Point2D.Double();
            }
            bezCurve[0] = d[first];
            bezCurve[3] = d[last];
            Bezier.v2Add(bezCurve[0], Bezier.v2Scale(tHat1, dist), bezCurve[1]);
            Bezier.v2Add(bezCurve[3], Bezier.v2Scale(tHat2, dist), bezCurve[2]);
            bezierPath.curveTo((float)bezCurve[1].x, (float)bezCurve[1].y, (float)bezCurve[2].x, (float)bezCurve[2].y, (float)bezCurve[3].x, (float)bezCurve[3].y);
            return;
        }
        double[] u = Bezier.chordLengthParameterize(d, first, last);
        Point2D.Double[] bezCurve = Bezier.generateBezier(d, first, last, u, tHat1, tHat2);
        double maxError = Bezier.computeMaxError(d, first, last, bezCurve, u, splitPoint);
        if (maxError < error) {
            bezierPath.curveTo((float)bezCurve[1].x, (float)bezCurve[1].y, (float)bezCurve[2].x, (float)bezCurve[2].y, (float)bezCurve[3].x, (float)bezCurve[3].y);
            return;
        }
        if (maxError < iterationError) {
            for (int i = 0; i < maxIterations; ++i) {
                double[] uPrime = Bezier.reparameterize(d, first, last, u, bezCurve);
                maxError = Bezier.computeMaxError(d, first, last, bezCurve = Bezier.generateBezier(d, first, last, uPrime, tHat1, tHat2), uPrime, splitPoint);
                if (maxError < error) {
                    bezierPath.curveTo((float)bezCurve[1].x, (float)bezCurve[1].y, (float)bezCurve[2].x, (float)bezCurve[2].y, (float)bezCurve[3].x, (float)bezCurve[3].y);
                    return;
                }
                u = uPrime;
            }
        }
        tHatCenter = Bezier.computeCenterTangent(d, splitPoint[0]);
        Bezier.fitCubic(d, first, splitPoint[0], tHat1, tHatCenter, error, bezierPath);
        Bezier.v2Negate(tHatCenter);
        Bezier.fitCubic(d, splitPoint[0], last, tHatCenter, tHat2, error, bezierPath);
    }

    private static void fitCubic(Point2D.Double[] d, int first, int last, Point2D.Double tHat1, Point2D.Double tHat2, double error, BezierPath bezierPath) {
        int[] splitPoint = new int[1];
        int maxIterations = 4;
        Point2D.Double tHatCenter = new Point2D.Double();
        double iterationError = error * error;
        int nPts = last - first + 1;
        if (nPts == 2) {
            double dist = Bezier.v2DistanceBetween2Points(d[last], d[first]) / 3.0;
            Point2D.Double[] bezCurve = new Point2D.Double[4];
            for (int i = 0; i < bezCurve.length; ++i) {
                bezCurve[i] = new Point2D.Double();
            }
            bezCurve[0] = d[first];
            bezCurve[3] = d[last];
            Bezier.v2Add(bezCurve[0], Bezier.v2Scale(tHat1, dist), bezCurve[1]);
            Bezier.v2Add(bezCurve[3], Bezier.v2Scale(tHat2, dist), bezCurve[2]);
            bezierPath.curveTo(bezCurve[1].x, bezCurve[1].y, bezCurve[2].x, bezCurve[2].y, bezCurve[3].x, bezCurve[3].y);
            return;
        }
        double[] u = Bezier.chordLengthParameterize(d, first, last);
        Point2D.Double[] bezCurve = Bezier.generateBezier(d, first, last, u, tHat1, tHat2);
        double maxError = Bezier.computeMaxError(d, first, last, bezCurve, u, splitPoint);
        if (maxError < error) {
            bezierPath.curveTo(bezCurve[1].x, bezCurve[1].y, bezCurve[2].x, bezCurve[2].y, bezCurve[3].x, bezCurve[3].y);
            return;
        }
        if (maxError < iterationError) {
            for (int i = 0; i < maxIterations; ++i) {
                double[] uPrime = Bezier.reparameterize(d, first, last, u, bezCurve);
                maxError = Bezier.computeMaxError(d, first, last, bezCurve = Bezier.generateBezier(d, first, last, uPrime, tHat1, tHat2), uPrime, splitPoint);
                if (maxError < error) {
                    bezierPath.curveTo(bezCurve[1].x, bezCurve[1].y, bezCurve[2].x, bezCurve[2].y, bezCurve[3].x, bezCurve[3].y);
                    return;
                }
                u = uPrime;
            }
        }
        tHatCenter = Bezier.computeCenterTangent(d, splitPoint[0]);
        Bezier.fitCubic(d, first, splitPoint[0], tHat1, tHatCenter, error, bezierPath);
        Bezier.v2Negate(tHatCenter);
        Bezier.fitCubic(d, splitPoint[0], last, tHatCenter, tHat2, error, bezierPath);
    }

    private static Point2D.Double[] generateBezier(Point2D.Double[] d, int first, int last, double[] uPrime, Point2D.Double tHat1, Point2D.Double tHat2) {
        int i;
        Point2D.Double[][] A = new Point2D.Double[1000][2];
        double[][] C = new double[2][2];
        double[] X = new double[2];
        Point2D.Double tmp = new Point2D.Double();
        Point2D.Double[] bezCurve = new Point2D.Double[4];
        for (i = 0; i < bezCurve.length; ++i) {
            bezCurve[i] = new Point2D.Double();
        }
        int nPts = last - first + 1;
        for (i = 0; i < nPts; ++i) {
            Point2D.Double v1 = (Point2D.Double)tHat1.clone();
            Point2D.Double v2 = (Point2D.Double)tHat2.clone();
            Bezier.v2Scale(v1, Bezier.b1(uPrime[i]));
            Bezier.v2Scale(v2, Bezier.b2(uPrime[i]));
            A[i][0] = v1;
            A[i][1] = v2;
        }
        C[0][0] = 0.0;
        C[0][1] = 0.0;
        C[1][0] = 0.0;
        C[1][1] = 0.0;
        X[0] = 0.0;
        X[1] = 0.0;
        for (i = 0; i < nPts; ++i) {
            double[] dArray = C[0];
            dArray[0] = dArray[0] + Bezier.v2Dot(A[i][0], A[i][0]);
            double[] dArray2 = C[0];
            dArray2[1] = dArray2[1] + Bezier.v2Dot(A[i][0], A[i][1]);
            C[1][0] = C[0][1];
            double[] dArray3 = C[1];
            dArray3[1] = dArray3[1] + Bezier.v2Dot(A[i][1], A[i][1]);
            tmp = Bezier.v2SubII(d[first + i], Bezier.v2AddII(Bezier.v2ScaleIII(d[first], Bezier.b0(uPrime[i])), Bezier.v2AddII(Bezier.v2ScaleIII(d[first], Bezier.b1(uPrime[i])), Bezier.v2AddII(Bezier.v2ScaleIII(d[last], Bezier.b2(uPrime[i])), Bezier.v2ScaleIII(d[last], Bezier.b3(uPrime[i]))))));
            X[0] = X[0] + Bezier.v2Dot(A[i][0], tmp);
            X[1] = X[1] + Bezier.v2Dot(A[i][1], tmp);
        }
        double det_C0_C1 = C[0][0] * C[1][1] - C[1][0] * C[0][1];
        double det_C0_X = C[0][0] * X[1] - C[0][1] * X[0];
        double det_X_C1 = X[0] * C[1][1] - X[1] * C[0][1];
        if (det_C0_C1 == 0.0) {
            det_C0_C1 = C[0][0] * C[1][1] * 1.0E-11;
        }
        double alpha_l = det_X_C1 / det_C0_C1;
        double alpha_r = det_C0_X / det_C0_C1;
        if (alpha_l < 1.0E-6 || alpha_r < 1.0E-6) {
            double dist = Bezier.v2DistanceBetween2Points(d[last], d[first]) / 3.0;
            bezCurve[0] = d[first];
            bezCurve[3] = d[last];
            Bezier.v2Add(bezCurve[0], Bezier.v2Scale(tHat1, dist), bezCurve[1]);
            Bezier.v2Add(bezCurve[3], Bezier.v2Scale(tHat2, dist), bezCurve[2]);
            return bezCurve;
        }
        bezCurve[0] = d[first];
        bezCurve[3] = d[last];
        Bezier.v2Add(bezCurve[0], Bezier.v2Scale(tHat1, alpha_l), bezCurve[1]);
        Bezier.v2Add(bezCurve[3], Bezier.v2Scale(tHat2, alpha_r), bezCurve[2]);
        return bezCurve;
    }

    private static double[] reparameterize(Point2D.Double[] d, int first, int last, double[] u, Point2D.Double[] bezCurve) {
        int nPts = last - first + 1;
        double[] uPrime = new double[nPts];
        for (int i = first; i <= last; ++i) {
            uPrime[i - first] = Bezier.newtonRaphsonRootFind(bezCurve, d[i], u[i - first]);
        }
        return uPrime;
    }

    private static double newtonRaphsonRootFind(Point2D.Double[] Q, Point2D.Double P, double u) {
        int i;
        Point2D.Double[] Q1 = new Point2D.Double[3];
        Point2D.Double[] Q2 = new Point2D.Double[2];
        Point2D.Double Q_u = new Point2D.Double();
        Point2D.Double Q1_u = new Point2D.Double();
        Point2D.Double Q2_u = new Point2D.Double();
        Q_u = Bezier.bezierII(3, Q, u);
        for (i = 0; i <= 2; ++i) {
            Q1[i] = new Point2D.Double((Q[i + 1].x - Q[i].x) * 3.0, (Q[i + 1].y - Q[i].y) * 3.0);
        }
        for (i = 0; i <= 1; ++i) {
            Q2[i] = new Point2D.Double((Q1[i + 1].x - Q1[i].x) * 2.0, (Q1[i + 1].y - Q1[i].y) * 2.0);
        }
        Q1_u = Bezier.bezierII(2, Q1, u);
        Q2_u = Bezier.bezierII(1, Q2, u);
        double numerator = (Q_u.x - P.x) * Q1_u.x + (Q_u.y - P.y) * Q1_u.y;
        double denominator = Q1_u.x * Q1_u.x + Q1_u.y * Q1_u.y + (Q_u.x - P.x) * Q2_u.x + (Q_u.y - P.y) * Q2_u.y;
        double uPrime = u - numerator / denominator;
        return uPrime;
    }

    private static Point2D.Double bezierII(int degree, Point2D.Double[] V, double t) {
        int i;
        Point2D.Double[] Vtemp = new Point2D.Double[degree + 1];
        for (i = 0; i <= degree; ++i) {
            Vtemp[i] = (Point2D.Double)V[i].clone();
        }
        for (i = 1; i <= degree; ++i) {
            for (int j = 0; j <= degree - i; ++j) {
                Vtemp[j].x = (1.0 - t) * Vtemp[j].x + t * Vtemp[j + 1].x;
                Vtemp[j].y = (1.0 - t) * Vtemp[j].y + t * Vtemp[j + 1].y;
            }
        }
        Point2D.Double Q = Vtemp[0];
        return Q;
    }

    private static double b0(double u) {
        double tmp = 1.0 - u;
        return tmp * tmp * tmp;
    }

    private static double b1(double u) {
        double tmp = 1.0 - u;
        return 3.0 * u * (tmp * tmp);
    }

    private static double b2(double u) {
        double tmp = 1.0 - u;
        return 3.0 * u * u * tmp;
    }

    private static double b3(double u) {
        return u * u * u;
    }

    private static Point2D.Double computeLeftTangent(Point2D.Double[] d, int end) {
        Point2D.Double tHat1 = new Point2D.Double();
        tHat1 = Bezier.v2SubII(d[end + 1], d[end]);
        tHat1 = Bezier.v2Normalize(tHat1);
        return tHat1;
    }

    private static Point2D.Double computeRightTangent(Point2D.Double[] d, int end) {
        Point2D.Double tHat2 = new Point2D.Double();
        tHat2 = Bezier.v2SubII(d[end - 1], d[end]);
        tHat2 = Bezier.v2Normalize(tHat2);
        return tHat2;
    }

    private static Point2D.Double computeCenterTangent(Point2D.Double[] d, int center) {
        Point2D.Double V1 = new Point2D.Double();
        Point2D.Double V2 = new Point2D.Double();
        Point2D.Double tHatCenter = new Point2D.Double();
        V1 = Bezier.v2SubII(d[center - 1], d[center]);
        V2 = Bezier.v2SubII(d[center], d[center + 1]);
        tHatCenter.x = (V1.x + V2.x) / 2.0;
        tHatCenter.y = (V1.y + V2.y) / 2.0;
        tHatCenter = Bezier.v2Normalize(tHatCenter);
        return tHatCenter;
    }

    private static double[] chordLengthParameterize(Point2D.Double[] d, int first, int last) {
        int i;
        double[] u = new double[last - first + 1];
        u[0] = 0.0;
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first - 1] + Bezier.v2DistanceBetween2Points(d[i], d[i - 1]);
        }
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first] / u[last - first];
        }
        return u;
    }

    private static double computeMaxError(Point2D.Double[] d, int first, int last, Point2D.Double[] bezCurve, double[] u, int[] splitPoint) {
        Point2D.Double P = new Point2D.Double();
        Point2D.Double v = new Point2D.Double();
        splitPoint[0] = (last - first + 1) / 2;
        double maxDist = 0.0;
        for (int i = first + 1; i < last; ++i) {
            P = Bezier.bezierII(3, bezCurve, u[i - first]);
            v = Bezier.v2SubII(P, d[i]);
            double dist = Bezier.v2SquaredLength(v);
            if (!(dist >= maxDist)) continue;
            maxDist = dist;
            splitPoint[0] = i;
        }
        return maxDist;
    }

    private static Point2D.Double v2AddII(Point2D.Double a, Point2D.Double b) {
        Point2D.Double c = new Point2D.Double();
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        return c;
    }

    private static Point2D.Double v2ScaleIII(Point2D.Double v, double s) {
        Point2D.Double result = new Point2D.Double();
        result.x = v.x * s;
        result.y = v.y * s;
        return result;
    }

    private static Point2D.Double v2SubII(Point2D.Double a, Point2D.Double b) {
        Point2D.Double c = new Point2D.Double();
        c.x = a.x - b.x;
        c.y = a.y - b.y;
        return c;
    }

    private static double v2DistanceBetween2Points(Point2D.Double a, Point2D.Double b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static Point2D.Double v2Scale(Point2D.Double v, double newlen) {
        double len = Bezier.v2Length(v);
        if (len != 0.0) {
            v.x *= newlen / len;
            v.y *= newlen / len;
        }
        return v;
    }

    private static double v2Length(Point2D.Double a) {
        return Math.sqrt(Bezier.v2SquaredLength(a));
    }

    private static double v2SquaredLength(Point2D.Double a) {
        return a.x * a.x + a.y * a.y;
    }

    private static Point2D.Double v2Add(Point2D.Double a, Point2D.Double b, Point2D.Double c) {
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        return c;
    }

    private static Point2D.Double v2Negate(Point2D.Double v) {
        v.x = -v.x;
        v.y = -v.y;
        return v;
    }

    private static double v2Dot(Point2D.Double a, Point2D.Double b) {
        return a.x * b.x + a.y * b.y;
    }

    private static Point2D.Double v2Normalize(Point2D.Double v) {
        double len = Bezier.v2Length(v);
        if (len != 0.0) {
            v.x /= len;
            v.y /= len;
        }
        return v;
    }
}

