/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net.figures;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractConnector;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.ConnectorHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LocatorConnector;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFigure
extends TextFigure {
    private LinkedList<AbstractConnector> connectors;
    private static LocatorConnector north;
    private static LocatorConnector south;
    private static LocatorConnector east;
    private static LocatorConnector west;

    public NodeFigure() {
        RectangleFigure rf = new RectangleFigure();
        this.setDecorator(rf);
        this.createConnectors();
        AttributeKeys.DECORATOR_INSETS.basicSet(this, new Insets2D.Double(6.0, 10.0, 6.0, 10.0));
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.net.Labels");
        this.setText(labels.getString("nodeDefaultName"));
        this.setAttributeEnabled(AttributeKeys.DECORATOR_INSETS, false);
    }

    private void createConnectors() {
        this.connectors = new LinkedList();
        this.connectors.add(new LocatorConnector(this, RelativeLocator.north()));
        this.connectors.add(new LocatorConnector(this, RelativeLocator.east()));
        this.connectors.add(new LocatorConnector(this, RelativeLocator.west()));
        this.connectors.add(new LocatorConnector(this, RelativeLocator.south()));
    }

    public Collection getConnectors(ConnectionFigure prototype) {
        return Collections.unmodifiableList(this.connectors);
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeLocator.southWest()));
            handles.add(new MoveHandle(this, RelativeLocator.southEast()));
            for (AbstractConnector c : this.connectors) {
                handles.add(new ConnectorHandle(c, new LineConnectionFigure()));
            }
        }
        return handles;
    }

    @Override
    public Rectangle2D.Double getFigureDrawingArea() {
        Rectangle2D.Double b = super.getFigureDrawingArea();
        Geom.grow(b, 10.0, 10.0);
        return b;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure figure) {
        double min = Double.MAX_VALUE;
        AbstractConnector closest = null;
        for (AbstractConnector c : this.connectors) {
            Point2D.Double p2 = Geom.center(c.getBounds());
            double d = Geom.length2(p.x, p.y, p2.x, p2.y);
            if (!(d < min)) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return this.connectors.getFirst();
    }

    @Override
    public NodeFigure clone() {
        NodeFigure that = (NodeFigure)super.clone();
        that.createConnectors();
        return that;
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    protected void writeDecorator(DOMOutput out) throws IOException {
    }

    @Override
    protected void readDecorator(DOMInput in) throws IOException {
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
        if (this.getDecorator() != null) {
            key.basicSet(this.getDecorator(), newValue);
        }
    }
}

