/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.io;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.odg.figures.ODGFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODGInputFormat
implements InputFormat {
    private static final boolean DEBUG = false;
    private LinkedList<Figure> figures;
    private IXMLElement document;

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Open Document Drawing (ODG)", "odg");
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.read(in, drawing);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public void read(InputStream in, Drawing drawing) throws IOException {
        drawing.addAll(this.readFigures(in));
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("vnd.oasis.opendocument.graphics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Figure> readFigures(Transferable t) throws UnsupportedFlavorException, IOException {
        InputStream in = null;
        try {
            in = (InputStream)t.getTransferData(new DataFlavor("application/vnd.oasis.opendocument.graphics", "Image SVG"));
            LinkedList<Figure> linkedList = this.readFigures(in);
            return linkedList;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public LinkedList<Figure> readFigures(InputStream in) throws IOException {
        return this.readFiguresFromDocumentContent(in);
    }

    public LinkedList<Figure> readFiguresFromDocumentContent(InputStream in) throws IOException {
        IXMLParser parser;
        this.figures = new LinkedList();
        try {
            parser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception ex) {
            InternalError e = new InternalError("Unable to instantiate NanoXML Parser");
            e.initCause(ex);
            throw e;
        }
        StdXMLReader reader = new StdXMLReader(in);
        parser.setReader(reader);
        try {
            this.document = (IXMLElement)parser.parse();
        }
        catch (XMLException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        IXMLElement drawing = this.document;
        Stack stack = new Stack();
        LinkedList<IXMLElement> ll = new LinkedList<IXMLElement>();
        ll.add(this.document);
        stack.push(ll.iterator());
        while (!stack.empty() && ((Iterator)stack.peek()).hasNext()) {
            Iterator iter = (Iterator)stack.peek();
            IXMLElement node = (IXMLElement)iter.next();
            Iterator<IXMLElement> children = node.getChildren().iterator();
            if (!iter.hasNext()) {
                stack.pop();
            }
            if (children.hasNext()) {
                stack.push(children);
            }
            if (node.getName() == null || !node.getName().equals("drawing") || node.getNamespace() != null && !node.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) continue;
            drawing = node;
            break;
        }
        if (drawing.getName() == null || !drawing.getName().equals("drawing") || drawing.getNamespace() != null && !drawing.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) {
            throw new IOException("'office:drawing' element expected: " + drawing.getName());
        }
        this.readDrawingElement(drawing);
        return this.figures;
    }

    private void readDrawingElement(IXMLElement elem) throws IOException {
        for (IXMLElement node : elem.getChildren()) {
            String name;
            IXMLElement child;
            if (!(node instanceof IXMLElement) || (child = node).getNamespace() != null && !child.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0") || !(name = child.getName()).equals("page")) continue;
            this.readPageElement(elem);
        }
    }

    private void readPageElement(IXMLElement elem) throws IOException {
        for (IXMLElement node : elem.getChildren()) {
            if (!(node instanceof IXMLElement)) continue;
            IXMLElement child = node;
            this.readElement(child);
        }
    }

    private Figure readElement(IXMLElement elem) throws IOException {
        Figure f = null;
        if (elem.getNamespace() == null || elem.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            String name = elem.getName();
            if (name.equals("caption")) {
                f = this.readCaptionElement(elem);
            } else if (name.equals("circle")) {
                f = this.readCircleElement(elem);
            } else if (name.equals("connector")) {
                f = this.readCircleElement(elem);
            } else if (name.equals("customShape")) {
                f = this.readCustomShapeElement(elem);
            } else if (name.equals("ellipse")) {
                f = this.readEllipseElement(elem);
            } else if (name.equals("g")) {
                f = this.readGElement(elem);
            } else if (name.equals("line")) {
                f = this.readLineElement(elem);
            } else if (name.equals("measure")) {
                f = this.readMeasureElement(elem);
            } else if (name.equals("path")) {
                f = this.readPathElement(elem);
            } else if (name.equals("polygon")) {
                f = this.readPolygonElement(elem);
            } else if (name.equals("polyline")) {
                f = this.readPolylineElement(elem);
            } else if (name.equals("rect")) {
                f = this.readRectElement(elem);
            } else if (name.equals("regularPolygon")) {
                f = this.readRegularPolygonElement(elem);
            }
        }
        if (f instanceof ODGFigure) {
            if (((ODGFigure)f).isEmpty()) {
                return null;
            }
        } else if (f != null) {
            // empty if block
        }
        return f;
    }

    private Figure readEllipseElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readCircleElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readCustomShapeElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readGElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readLineElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readPathElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readPolygonElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readPolylineElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readRectElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readRegularPolygonElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readMeasureElement(IXMLElement elem) throws IOException {
        return null;
    }

    private Figure readCaptionElement(IXMLElement elem) throws IOException {
        return null;
    }
}

