/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierTool;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;

public class PathTool
extends BezierTool {
    private static final boolean DEBUG = false;
    private SVGPathFigure pathPrototype;

    public PathTool(SVGPathFigure pathPrototype, SVGBezierFigure bezierPrototype) {
        this(pathPrototype, bezierPrototype, null);
    }

    public PathTool(SVGPathFigure pathPrototype, SVGBezierFigure bezierPrototype, Map attributes) {
        super(bezierPrototype, attributes);
        this.pathPrototype = pathPrototype;
    }

    protected SVGPathFigure createPath() {
        SVGPathFigure f = this.pathPrototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                ((AttributeKey)entry.getKey()).basicSet(f, entry.getValue());
            }
        }
        return f;
    }

    protected void finishCreation(BezierFigure createdFigure) {
        this.getDrawing().remove(createdFigure);
        SVGPathFigure createdPath = this.createPath();
        createdPath.removeAllChildren();
        createdPath.add(createdFigure);
        this.getDrawing().add(createdPath);
        this.getView().addToSelection(createdPath);
        this.fireUndoEvent(createdPath);
    }
}

