/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.gui.JDoubleAttributeField;
import org.jhotdraw.gui.JDoubleAttributeSlider;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.JStringAttributeField;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGPropertiesPanel
extends JPanel {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
    private DrawingEditor editor;
    private JDoubleAttributeSlider opacitySlider;
    private JStringAttributeField linkField;
    private JLabel linkLabel;
    private JDoubleAttributeField opacityField;
    private JLabel opacityLabel;
    private JPopupButton opacityPopupButton;

    public SVGPropertiesPanel() {
        this.initComponents();
        this.opacitySlider = new JDoubleAttributeSlider(1, 0, 100, 100);
        this.opacityPopupButton.add(this.opacitySlider);
        this.opacityPopupButton.putClientProperty("JButton.buttonType", "toolbar");
        this.add(this.opacityPopupButton);
        this.opacityField.setAttributeKey(SVGAttributeKeys.OPACITY);
        this.opacitySlider.setAttributeKey(SVGAttributeKeys.OPACITY);
        this.opacitySlider.setScaleFactor(100.0);
        this.opacityField.setScaleFactor(100.0);
        this.opacityField.setMinimum(0.0);
        this.opacityField.setMaximum(100.0);
        this.linkField.setAttributeKey(SVGAttributeKeys.LINK);
        Font font = this.getFont().deriveFont(11.0f);
        for (Component c : this.getComponents()) {
            c.setFont(font);
        }
        this.opacitySlider.setFont(font);
    }

    public void setEditor(DrawingEditor editor) {
        this.editor = editor;
        this.linkField.setEditor(editor);
        this.opacitySlider.setEditor(editor);
        this.opacityField.setEditor(editor);
    }

    public void setView(DrawingView view) {
        this.opacityField.setView(view);
    }

    private void initComponents() {
        this.linkLabel = new JLabel();
        this.linkField = new JStringAttributeField();
        this.opacityLabel = new JLabel();
        this.opacityField = new JDoubleAttributeField();
        this.opacityPopupButton = new JPopupButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.linkLabel.setLabelFor(this.linkField);
        this.linkLabel.setText(this.labels.getString("link"));
        this.add((Component)this.linkLabel, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.linkField, gridBagConstraints);
        this.opacityLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/attributeOpacity.png")));
        this.opacityLabel.setToolTipText(this.labels.getString("opacity"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.opacityLabel, gridBagConstraints);
        this.opacityField.setColumns(3);
        this.add((Component)this.opacityField, new GridBagConstraints());
        this.opacityPopupButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/popupIcon.png")));
        this.add((Component)this.opacityPopupButton, new GridBagConstraints());
    }
}

