/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class ClassAnnotation
extends PackageMemberAnnotation {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ROLE = "CLASS_DEFAULT";
    private static final String ELEMENT_NAME = "Class";

    public ClassAnnotation(String className) {
        super(className, DEFAULT_ROLE);
    }

    public static ClassAnnotation fromClassDescriptor(ClassDescriptor classDescriptor) {
        return new ClassAnnotation(classDescriptor.toDottedClassName());
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitClassAnnotation(this);
    }

    protected String formatPackageMember(String key, ClassAnnotation primaryClass) {
        if (key.equals("") || key.equals("hash")) {
            return this.className;
        }
        if (key.equals("givenClass")) {
            return ClassAnnotation.shorten(primaryClass.getPackageName(), this.className);
        }
        if (key.equals("excludingPackage")) {
            return ClassAnnotation.shorten(this.getPackageName(), this.className);
        }
        throw new IllegalArgumentException("unknown key " + key);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassAnnotation)) {
            return false;
        }
        ClassAnnotation other = (ClassAnnotation)o;
        return this.className.equals(other.className);
    }

    public boolean contains(ClassAnnotation other) {
        return other.className.startsWith(this.className);
    }

    public ClassAnnotation getTopLevelClass() {
        int firstDollar = this.className.indexOf(36);
        if (firstDollar == -1) {
            return this;
        }
        return new ClassAnnotation(this.className.substring(0, firstDollar));
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof ClassAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        ClassAnnotation other = (ClassAnnotation)o;
        return this.className.compareTo(other.className);
    }

    public SourceLineAnnotation getSourceLines() {
        if (this.sourceLines == null) {
            SourceInfoMap.SourceLineRange classLine;
            AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
            this.sourceLines = currentAnalysisContext == null ? new SourceLineAnnotation(this.className, this.sourceFileName, -1, -1, -1, -1) : ((classLine = currentAnalysisContext.getSourceInfoMap().getClassLine(this.className)) == null ? SourceLineAnnotation.getSourceAnnotationForClass(this.className, this.sourceFileName) : new SourceLineAnnotation(this.className, this.sourceFileName, classLine.getStart(), classLine.getEnd(), -1, -1));
        }
        return this.sourceLines;
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", this.getClassName());
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        xmlOutput.openTag(ELEMENT_NAME, attributeList);
        this.getSourceLines().writeXML(xmlOutput, addMessages);
        if (addMessages) {
            xmlOutput.openTag("Message");
            xmlOutput.writeText(this.toString());
            xmlOutput.closeTag("Message");
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((BugAnnotation)x0);
    }
}

