/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorToDetector2Adapter;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.JavaVersion;
import edu.umd.cs.findbugs.JavaVersionException;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactory {
    private static final boolean DEBUG_JAVA_VERSION = SystemProperties.getBoolean("findbugs.debug.javaversion");
    private static final Class[] constructorArgTypes = new Class[]{class$edu$umd$cs$findbugs$BugReporter == null ? (class$edu$umd$cs$findbugs$BugReporter = DetectorFactory.class$("edu.umd.cs.findbugs.BugReporter")) : class$edu$umd$cs$findbugs$BugReporter};
    private Plugin plugin;
    private final ReflectionDetectorCreator detectorCreator;
    private int positionSpecifiedInPluginDescriptor;
    private boolean defEnabled;
    private final String speed;
    private final String reports;
    private final String requireJRE;
    private String detailHTML;
    private int priorityAdjustment;
    private boolean enabledButNonReporting;
    private boolean hidden;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$BugReporter;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$AnalysisContext;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$Detector2;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$Detector;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$TrainingDetector;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$NonReportingDetector;

    public DetectorFactory(Plugin plugin, Class<?> detectorClass, boolean enabled, String speed, String reports, String requireJRE) {
        this.plugin = plugin;
        this.detectorCreator = new ReflectionDetectorCreator(detectorClass);
        this.defEnabled = enabled;
        this.speed = speed;
        this.reports = reports;
        this.requireJRE = requireJRE;
        this.priorityAdjustment = 0;
        this.hidden = false;
    }

    public void setPositionSpecifiedInPluginDescriptor(int positionSpecifiedInPluginDescriptor) {
        this.positionSpecifiedInPluginDescriptor = positionSpecifiedInPluginDescriptor;
    }

    public int getPositionSpecifiedInPluginDescriptor() {
        return this.positionSpecifiedInPluginDescriptor;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isDetectorClassSubtypeOf(Class<?> otherClass) {
        return otherClass.isAssignableFrom(this.detectorCreator.getDetectorClass());
    }

    public boolean isReportingDetector() {
        return !this.isDetectorClassSubtypeOf(class$edu$umd$cs$findbugs$TrainingDetector == null ? (class$edu$umd$cs$findbugs$TrainingDetector = DetectorFactory.class$("edu.umd.cs.findbugs.TrainingDetector")) : class$edu$umd$cs$findbugs$TrainingDetector) && !this.isDetectorClassSubtypeOf(class$edu$umd$cs$findbugs$NonReportingDetector == null ? (class$edu$umd$cs$findbugs$NonReportingDetector = DetectorFactory.class$("edu.umd.cs.findbugs.NonReportingDetector")) : class$edu$umd$cs$findbugs$NonReportingDetector);
    }

    public boolean isEnabledForCurrentJRE() {
        if (this.requireJRE.equals("")) {
            return true;
        }
        try {
            JavaVersion requiredVersion = new JavaVersion(this.requireJRE);
            JavaVersion runtimeVersion = JavaVersion.getRuntimeVersion();
            if (DEBUG_JAVA_VERSION) {
                System.out.println(new StringBuffer().append("Checking JRE version for ").append(this.getShortName()).append(" (requires ").append(requiredVersion).append(", running on ").append(runtimeVersion).append(")").toString());
            }
            boolean enabledForCurrentJRE = runtimeVersion.isSameOrNewerThan(requiredVersion);
            if (DEBUG_JAVA_VERSION) {
                System.out.println(new StringBuffer().append("\t==> ").append(enabledForCurrentJRE).toString());
            }
            return enabledForCurrentJRE;
        }
        catch (JavaVersionException e) {
            if (DEBUG_JAVA_VERSION) {
                System.out.println(new StringBuffer().append("Couldn't check Java version: ").append(e.toString()).toString());
                e.printStackTrace(System.out);
            }
            return false;
        }
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDefaultEnabled() {
        return this.defEnabled;
    }

    public void setPriorityAdjustment(int priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
    }

    public void setEnabledButNonReporting(boolean notReporting) {
        this.enabledButNonReporting = notReporting;
    }

    public int getPriorityAdjustment() {
        if (this.enabledButNonReporting) {
            return 100;
        }
        return this.priorityAdjustment;
    }

    public String getSpeed() {
        return this.speed;
    }

    public String getReportedBugPatternCodes() {
        return this.reports;
    }

    public Collection<BugPattern> getReportedBugPatterns() {
        LinkedList<BugPattern> result = new LinkedList<BugPattern>();
        StringTokenizer tok = new StringTokenizer(this.reports, ",");
        while (tok.hasMoreTokens()) {
            String type = tok.nextToken();
            BugPattern bugPattern = I18N.instance().lookupBugPattern(type);
            if (bugPattern == null) continue;
            result.add(bugPattern);
        }
        return result;
    }

    public String getDetailHTML() {
        return this.detailHTML;
    }

    public void setDetailHTML(String detailHTML) {
        this.detailHTML = detailHTML;
    }

    public Detector create(BugReporter bugReporter) {
        return this.detectorCreator.createDetector(bugReporter);
    }

    public Detector2 createDetector2(BugReporter bugReporter) {
        return this.detectorCreator.createDetector2(bugReporter);
    }

    public String getShortName() {
        String className = this.detectorCreator.getDetectorClass().getName();
        int endOfPkg = className.lastIndexOf(46);
        if (endOfPkg >= 0) {
            className = className.substring(endOfPkg + 1);
        }
        return className;
    }

    public String getFullName() {
        return this.detectorCreator.getDetectorClass().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionDetectorCreator {
        private Class<?> detectorClass;
        private Method setAnalysisContext;

        ReflectionDetectorCreator(Class<?> detectorClass) {
            this.detectorClass = detectorClass;
            try {
                this.setAnalysisContext = detectorClass.getDeclaredMethod("setAnalysisContext", class$edu$umd$cs$findbugs$ba$AnalysisContext == null ? (class$edu$umd$cs$findbugs$ba$AnalysisContext = DetectorFactory.class$("edu.umd.cs.findbugs.ba.AnalysisContext")) : class$edu$umd$cs$findbugs$ba$AnalysisContext);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public Detector createDetector(BugReporter bugReporter) {
            try {
                Constructor<?> constructor = this.detectorClass.getConstructor(constructorArgTypes);
                Detector detector = (Detector)constructor.newInstance(bugReporter);
                if (this.setAnalysisContext != null) {
                    this.setAnalysisContext.invoke((Object)detector, AnalysisContext.currentAnalysisContext());
                }
                return detector;
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuffer().append("Could not instantiate ").append(this.detectorClass.getName()).append(" as Detector").toString(), e);
            }
        }

        public Detector2 createDetector2(BugReporter bugReporter) {
            if ((class$edu$umd$cs$findbugs$Detector2 == null ? (class$edu$umd$cs$findbugs$Detector2 = DetectorFactory.class$("edu.umd.cs.findbugs.Detector2")) : class$edu$umd$cs$findbugs$Detector2).isAssignableFrom(this.detectorClass)) {
                try {
                    Constructor<?> constructor = this.detectorClass.getConstructor(constructorArgTypes);
                    return (Detector2)constructor.newInstance(bugReporter);
                }
                catch (Exception e) {
                    throw new RuntimeException(new StringBuffer().append("Could not instantiate ").append(this.detectorClass.getName()).append(" as Detector2").toString(), e);
                }
            }
            if ((class$edu$umd$cs$findbugs$Detector == null ? (class$edu$umd$cs$findbugs$Detector = DetectorFactory.class$("edu.umd.cs.findbugs.Detector")) : class$edu$umd$cs$findbugs$Detector).isAssignableFrom(this.detectorClass)) {
                DetectorToDetector2Adapter adapter = new DetectorToDetector2Adapter(this.createDetector(bugReporter));
                return adapter;
            }
            throw new RuntimeException(new StringBuffer().append("Class ").append(this.detectorClass.getName()).append(" is not a detector class").toString());
        }

        public Class<?> getDetectorClass() {
            return this.detectorClass;
        }
    }
}

