/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassScreener;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ErrorCountingBugReporter;
import edu.umd.cs.findbugs.ExitCodes;
import edu.umd.cs.findbugs.FilterBugReporter;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.NoOpFindBugsProgress;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.RecursiveFileSearch;
import edu.umd.cs.findbugs.ShowHelp;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.URLClassPath;
import edu.umd.cs.findbugs.ba.URLClassPathRepository;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IClassObserver;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import edu.umd.cs.findbugs.util.Archive;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.Constants2;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugs
implements Constants2,
ExitCodes,
IFindBugsEngine {
    public static final AnalysisFeatureSetting[] MIN_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, true), new AnalysisFeatureSetting(0, false), new AnalysisFeatureSetting(2, false), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, false), new AnalysisFeatureSetting(5, false), new AnalysisFeatureSetting(6, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] LESS_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, false), new AnalysisFeatureSetting(6, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] DEFAULT_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] MORE_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] MAX_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, false), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, true)};
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.debug");
    public static final boolean TIMEDEBUG = SystemProperties.getBoolean("findbugs.time");
    public static final int TIMEQUANTUM = SystemProperties.getInteger("findbugs.time.quantum", 1000);
    private static String home;
    public static final Set<String> knownURLProtocolSet;
    private ErrorCountingBugReporter bugReporter;
    private boolean relaxedReportingMode = false;
    private Project project;
    private DetectorFactoryCollection detectorFactoryCollection;
    private UserPreferences userPreferences;
    private List<IClassObserver> classObserverList;
    private ExecutionPlan executionPlan;
    private FindBugsProgress progressCallback;
    private IClassScreener classScreener;
    private AnalysisContext analysisContext;
    private String currentClass;
    private Map<String, Long> detectorTimings;
    private boolean useTrainingInput;
    private boolean emitTrainingOutput;
    private String trainingInputDir;
    private String trainingOutputDir;
    private AnalysisFeatureSetting[] settingList = DEFAULT_EFFORT;
    private String releaseName;
    private String projectName;
    private int passCount;
    private String sourceInfoFile;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$TrainingDetector;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$NonReportingDetector;
    static /* synthetic */ Class class$java$lang$String;

    public FindBugs() {
        this.classObserverList = new LinkedList<IClassObserver>();
        this.progressCallback = new NoOpFindBugsProgress();
        this.classScreener = new ClassScreener();
    }

    public FindBugs(BugReporter bugReporter, Project project) {
        this();
        if (bugReporter == null) {
            throw new IllegalArgumentException("null bugReporter");
        }
        if (project == null) {
            throw new IllegalArgumentException("null project");
        }
        this.setBugReporter(bugReporter);
        this.setProject(project);
    }

    @Override
    public void setDetectorFactoryCollection(DetectorFactoryCollection detectorFactoryCollection) {
        this.detectorFactoryCollection = detectorFactoryCollection;
    }

    @Override
    public BugReporter getBugReporter() {
        return this.bugReporter;
    }

    @Override
    public void setBugReporter(BugReporter bugReporter) {
        this.bugReporter = new ErrorCountingBugReporter(bugReporter);
        this.addClassObserver(bugReporter);
    }

    @Override
    public void setProject(Project project) {
        this.project = project.duplicate();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProgressCallback(FindBugsProgress progressCallback) {
        this.progressCallback = progressCallback;
    }

    @Override
    public void addFilter(String filterFileName, boolean include) throws IOException, FilterException {
        FindBugs.configureFilter(this.bugReporter, filterFileName, include);
    }

    @Override
    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    @Override
    public void addClassObserver(IClassObserver classObserver) {
        this.classObserverList.add(classObserver);
    }

    @Override
    public void setClassScreener(IClassScreener classScreener) {
        this.classScreener = classScreener;
    }

    @Override
    public void setRelaxedReportingMode(boolean relaxedReportingMode) {
        this.relaxedReportingMode = relaxedReportingMode;
    }

    @Override
    public void enableTrainingOutput(String trainingOutputDir) {
        this.emitTrainingOutput = true;
        this.trainingOutputDir = trainingOutputDir;
    }

    @Override
    public void enableTrainingInput(String trainingInputDir) {
        this.useTrainingInput = true;
        this.trainingInputDir = trainingInputDir;
    }

    @Override
    public void setAnalysisFeatureSettings(AnalysisFeatureSetting[] settingList) {
        if (settingList != null) {
            this.settingList = settingList;
        }
    }

    @Override
    public String getReleaseName() {
        return this.releaseName;
    }

    @Override
    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    @Override
    public void setSourceInfoFile(String sourceInfoFile) {
        this.sourceInfoFile = sourceInfoFile;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        Iterator<AnalysisPass> i;
        this.analysisContext = AnalysisContext.create(this.bugReporter);
        this.analysisContext.setSourcePath(this.project.getSourceDirList());
        if (this.sourceInfoFile != null) {
            this.analysisContext.getSourceInfoMap().read(new FileInputStream(this.sourceInfoFile));
        }
        FindBugsAnalysisFeatures.setRelaxedMode(this.relaxedReportingMode);
        FindBugs.configureTrainingDatabases(this);
        this.configureAnalysisFeatures();
        FindBugs.configureBugCollection(this);
        try {
            this.createExecutionPlan();
        }
        catch (OrderingConstraintException e) {
            IOException ioe = new IOException("Invalid detector ordering constraints");
            ioe.initCause(e);
            throw ioe;
        }
        this.analysisContext.clearRepository();
        LinkedList<ArchiveWorkListItem> archiveWorkList = new LinkedList<ArchiveWorkListItem>();
        for (String fileName : this.project.getFileList()) {
            archiveWorkList.add(new ArchiveWorkListItem(fileName, true));
        }
        this.progressCallback.reportNumberOfArchives(archiveWorkList.size());
        LinkedList<String> repositoryClassList = new LinkedList<String>();
        this.setRepositoryClassPath();
        LinkedList<String> additionalAuxClasspathEntryList = new LinkedList<String>();
        while (!archiveWorkList.isEmpty()) {
            ArchiveWorkListItem item = (ArchiveWorkListItem)archiveWorkList.removeFirst();
            this.scanArchiveOrDirectory(item, archiveWorkList, repositoryClassList, additionalAuxClasspathEntryList);
        }
        this.addCollectionToClasspath(additionalAuxClasspathEntryList);
        this.analysisContext.initDatabases();
        if (DEBUG) {
            this.detectorTimings = new HashMap<String, Long>();
        }
        if ((i = this.executionPlan.passIterator()).hasNext()) {
            AnalysisPass firstPass = i.next();
            Set<JavaClass> allReferencedClasses = this.analysisContext.getSubtypes().getAllClasses();
            ArrayList<String> listOfReferencedClasses = new ArrayList<String>(allReferencedClasses.size());
            for (JavaClass c : allReferencedClasses) {
                listOfReferencedClasses.add(c.getClassName());
            }
            this.executeAnalysisPass(firstPass, listOfReferencedClasses);
            this.analysisContext.clearClassContextCache();
        } else if (DEBUG) {
            System.err.println("execution plan has no passes");
        }
        while (i.hasNext()) {
            AnalysisPass analysisPass = i.next();
            this.executeAnalysisPass(analysisPass, repositoryClassList);
            this.analysisContext.clearClassContextCache();
        }
        this.bugReporter.finish();
        this.bugReporter.reportQueuedErrors();
        this.analysisContext.clearRepository();
    }

    @Override
    public String getCurrentClass() {
        return this.currentClass;
    }

    @Override
    public int getBugCount() {
        return this.bugReporter.getBugCount();
    }

    @Override
    public int getErrorCount() {
        return this.bugReporter.getErrorCount();
    }

    @Override
    public int getMissingClassCount() {
        return this.bugReporter.getMissingClassCount();
    }

    @Override
    public boolean emitTrainingOutput() {
        return this.emitTrainingOutput;
    }

    @Override
    public UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.userPreferences = UserPreferences.createDefaultUserPreferences();
        }
        return this.userPreferences;
    }

    @Override
    public String getTrainingInputDir() {
        return this.trainingInputDir;
    }

    @Override
    public String getTrainingOutputDir() {
        return this.trainingOutputDir;
    }

    @Override
    public boolean useTrainingInput() {
        return this.useTrainingInput;
    }

    @Override
    public void setScanNestedArchives(boolean scanNestedArchives) {
    }

    public static void setHome(String home) {
        FindBugs.home = home;
    }

    public static String getHome() {
        if (home == null && (home = SystemProperties.getProperty("findbugs.home")) == null) {
            System.err.println("Error: The findbugs.home property is not set!");
        }
        return home;
    }

    private void configureAnalysisFeatures() {
        for (AnalysisFeatureSetting setting : this.settingList) {
            setting.configure(this.analysisContext);
        }
    }

    public static void configureTrainingDatabases(IFindBugsEngine findBugs) throws IOException {
        if (findBugs.emitTrainingOutput()) {
            String trainingOutputDir = findBugs.getTrainingOutputDir();
            if (!new File(trainingOutputDir).isDirectory()) {
                throw new IOException(new StringBuffer().append("Training output directory ").append(trainingOutputDir).append(" does not exist").toString());
            }
            AnalysisContext.currentAnalysisContext().setDatabaseOutputDir(trainingOutputDir);
            System.setProperty("findbugs.checkreturn.savetraining", new File(trainingOutputDir, "checkReturn.db").getPath());
        }
        if (findBugs.useTrainingInput()) {
            String trainingInputDir = findBugs.getTrainingInputDir();
            if (!new File(trainingInputDir).isDirectory()) {
                throw new IOException(new StringBuffer().append("Training input directory ").append(trainingInputDir).append(" does not exist").toString());
            }
            AnalysisContext.currentAnalysisContext().setDatabaseInputDir(trainingInputDir);
            AnalysisContext.currentAnalysisContext().loadInterproceduralDatabases();
            System.setProperty("findbugs.checkreturn.loadtraining", new File(trainingInputDir, "checkReturn.db").getPath());
        } else {
            AnalysisContext.currentAnalysisContext().loadDefaultInterproceduralDatabases();
        }
    }

    private void createExecutionPlan() throws OrderingConstraintException {
        this.executionPlan = new ExecutionPlan();
        this.executionPlan.setDetectorFactoryChooser(new DetectorFactoryChooser(){
            HashSet<DetectorFactory> forcedEnabled = new HashSet();

            public boolean choose(DetectorFactory factory) {
                return FindBugs.isDetectorEnabled(FindBugs.this, factory) || this.forcedEnabled.contains(factory);
            }

            public void enable(DetectorFactory factory) {
                this.forcedEnabled.add(factory);
                factory.setEnabledButNonReporting(true);
            }
        });
        Iterator<Plugin> i = this.detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            this.executionPlan.addPlugin(plugin);
        }
        this.executionPlan.build();
    }

    public static boolean isDetectorEnabled(IFindBugsEngine findBugs, DetectorFactory factory) {
        if (!factory.getPlugin().isEnabled()) {
            return false;
        }
        if (!findBugs.getUserPreferences().isDetectorEnabled(factory)) {
            return false;
        }
        if (!factory.isEnabledForCurrentJRE()) {
            return false;
        }
        if (!AnalysisContext.currentAnalysisContext().getBoolProperty(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS) && factory.isDetectorClassSubtypeOf(class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector == null ? (class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector = FindBugs.class$("edu.umd.cs.findbugs.InterproceduralFirstPassDetector")) : class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector)) {
            return false;
        }
        boolean isTrainingDetector = factory.isDetectorClassSubtypeOf(class$edu$umd$cs$findbugs$TrainingDetector == null ? (class$edu$umd$cs$findbugs$TrainingDetector = FindBugs.class$("edu.umd.cs.findbugs.TrainingDetector")) : class$edu$umd$cs$findbugs$TrainingDetector);
        boolean isNonReportingDetector = factory.isDetectorClassSubtypeOf(class$edu$umd$cs$findbugs$NonReportingDetector == null ? (class$edu$umd$cs$findbugs$NonReportingDetector = FindBugs.class$("edu.umd.cs.findbugs.NonReportingDetector")) : class$edu$umd$cs$findbugs$NonReportingDetector);
        if (findBugs.emitTrainingOutput()) {
            return isTrainingDetector || isNonReportingDetector;
        }
        return !isTrainingDetector;
    }

    private void setRepositoryClassPath() {
        this.addCollectionToClasspath(this.project.getAuxClasspathEntryList());
        this.addCollectionToClasspath(this.project.getImplicitClasspathEntryList());
        String systemClassPath = ClassPath.getClassPath();
        StringTokenizer tok = new StringTokenizer(systemClassPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String entry = tok.nextToken();
            try {
                this.analysisContext.addClasspathEntry(entry);
            }
            catch (IOException e) {
                this.bugReporter.logError(new StringBuffer().append("Warning: could not add URL ").append(entry).append(" to classpath").toString(), e);
            }
        }
    }

    private void addCollectionToClasspath(Collection<String> collection) {
        for (String entry : collection) {
            try {
                this.analysisContext.addClasspathEntry(entry);
            }
            catch (IOException e) {
                this.bugReporter.logError(new StringBuffer().append("Warning: could not add URL ").append(entry).append(" to classpath").toString(), e);
            }
        }
    }

    private void scanArchiveOrDirectory(ArchiveWorkListItem item, LinkedList<ArchiveWorkListItem> archiveWorkList, List<String> repositoryClassList, List<String> additionalAuxClasspathEntryList) throws IOException, InterruptedException {
        String fileName = item.getFileName();
        ClassProducer classProducer = null;
        try {
            String protocol = URLClassPath.getURLProtocol(fileName);
            if (protocol == null) {
                protocol = "file";
                fileName = new StringBuffer().append("file:").append(fileName).toString();
            }
            URL url = new URL(fileName);
            String fileExtension = null;
            int lastDot = fileName.lastIndexOf(46);
            if (lastDot >= 0) {
                fileExtension = fileName.substring(lastDot);
            }
            if (fileExtension != null && URLClassPath.isArchiveExtension(fileExtension)) {
                classProducer = new ZipClassProducer(url, archiveWorkList, additionalAuxClasspathEntryList);
            } else if (fileExtension != null && fileExtension.equals(".class")) {
                classProducer = new SingleClassProducer(url);
            } else if (protocol.equals("file")) {
                File dir = new File(fileName = fileName.substring("file:".length()));
                if (!dir.isDirectory()) {
                    throw new IOException(new StringBuffer().append("Path ").append(fileName).append(" is not an archive, class file, or directory").toString());
                }
                classProducer = new DirectoryClassProducer(fileName, additionalAuxClasspathEntryList);
            } else {
                throw new IOException(new StringBuffer().append("URL ").append(fileName).append(" is not an archive, class file, or directory").toString());
            }
            if (DEBUG || URLClassPathRepository.DEBUG) {
                System.out.println(new StringBuffer().append("Scanning ").append(url).append(" for classes").toString());
            }
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    JavaClass jclass = classProducer.getNextClass();
                    if (jclass == null) break;
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Scanned ").append(jclass.getClassName()).toString());
                    }
                    this.analysisContext.addApplicationClassToRepository(jclass);
                    repositoryClassList.add(jclass.getClassName());
                }
                catch (ClassFormatException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    this.bugReporter.logError("Invalid classfile format", e);
                }
            }
            if (item.isExplicit()) {
                this.progressCallback.finishArchive();
            }
            if (classProducer.containsSourceFiles()) {
                this.project.addSourceDir(fileName);
            }
            this.project.addTimestamp(classProducer.getLastModificationTime());
        }
        catch (IOException e) {
            IOException ioe = new IOException(new StringBuffer().append("Could not analyze ").append(fileName).toString());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (classProducer != null) {
                classProducer.close();
            }
        }
    }

    private void executeAnalysisPass(AnalysisPass analysisPass, List<String> repositoryClassList) throws InterruptedException {
        this.progressCallback.startAnalysis(repositoryClassList.size());
        int thisPass = this.passCount++;
        if (ExecutionPlan.DEBUG) {
            System.out.println(new StringBuffer().append("************* Analysis pass ").append(thisPass).append(" *************").toString());
            Iterator<DetectorFactory> i = analysisPass.iterator();
            while (i.hasNext()) {
                DetectorFactory factory = i.next();
                System.out.println(new StringBuffer().append("\t").append(factory.getFullName()).toString());
            }
        }
        Detector[] detectors = analysisPass.instantiateDetectorsInPass(this.bugReporter);
        HashSet<String> examinedClassSet = new HashSet<String>();
        for (String className : repositoryClassList) {
            if (!examinedClassSet.add(className)) continue;
            this.examineClass(detectors, className);
        }
        if (DEBUG) {
            long total = 0L;
            for (Long l : this.detectorTimings.values()) {
                total += l.longValue();
            }
            System.out.println();
            System.out.println("Detector Timings");
            for (Map.Entry entry : this.detectorTimings.entrySet()) {
                String detectorName = (String)entry.getKey();
                long detectorTime = (Long)entry.getValue();
                System.out.println(new StringBuffer().append(detectorName).append(": ").append(detectorTime).append(" ms  -> (").append((float)detectorTime * 100.0f / (float)total).append(") %").toString());
            }
            System.out.println();
            this.detectorTimings = new HashMap<String, Long>();
        }
        this.progressCallback.finishPerClassAnalysis();
        this.reportFinal(detectors);
        AnalysisContext.currentAnalysisContext().updateDatabases(thisPass);
    }

    private void examineClass(Detector[] detectors, String className) throws InterruptedException {
        long classSetupTime;
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Examining class ").append(className).toString());
        }
        long entireClassAnalysisStart = 0L;
        if (TIMEDEBUG || DEBUG) {
            entireClassAnalysisStart = System.currentTimeMillis();
        }
        this.currentClass = className;
        try {
            JavaClass javaClass = Repository.lookupClass(className);
            for (IClassObserver aClassObserver : this.classObserverList) {
                ClassDescriptor classDescriptor = new ClassDescriptor(ClassName.toSlashedClassName(javaClass.getClassName()));
                aClassObserver.observeClass(classDescriptor);
            }
            ClassContext classContext = this.analysisContext.getClassContext(javaClass);
            for (Detector detector1 : detectors) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Detector detector = detector1;
                try {
                    long start = 0L;
                    if (TIMEDEBUG || DEBUG) {
                        start = System.currentTimeMillis();
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("  running ").append(detector.getClass().getName()).toString());
                        }
                    }
                    detector.visitClassContext(classContext);
                    if (!TIMEDEBUG && !DEBUG) continue;
                    long end = System.currentTimeMillis();
                    long delta = end - start;
                    entireClassAnalysisStart += delta;
                    if (delta > (long)TIMEQUANTUM) {
                        System.out.println(new StringBuffer().append("TIME: ").append(detector.getClass().getName()).append(" ").append(className).append(" ").append(delta).toString());
                    }
                    if (!DEBUG) continue;
                    String detectorName = detector.getClass().getName();
                    Long total = this.detectorTimings.get(detectorName);
                    total = total == null ? new Long(delta) : new Long(total + delta);
                    this.detectorTimings.put(detectorName, total);
                }
                catch (AnalysisException e) {
                    this.reportRecoverableDetectorException(className, detector, e);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.reportRecoverableDetectorException(className, detector, e);
                }
                catch (ClassCastException e) {
                    this.reportRecoverableDetectorException(className, detector, e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            this.reportRecoverableException(className, e);
        }
        catch (ClassFormatException e) {
            this.reportRecoverableException(className, e);
        }
        catch (RuntimeException re) {
            RuntimeException annotatedEx;
            try {
                String sep = SystemProperties.getProperty("line.separator");
                Constructor<?> c = re.getClass().getConstructor(class$java$lang$String == null ? (class$java$lang$String = FindBugs.class$("java.lang.String")) : class$java$lang$String);
                String msg = re.getMessage();
                msg = new StringBuffer().append(sep).append("While finding bugs in class: ").append(className).append(msg == null ? "" : new StringBuffer().append(sep).append(msg).toString()).toString();
                annotatedEx = (RuntimeException)c.newInstance(msg);
                annotatedEx.setStackTrace(re.getStackTrace());
            }
            catch (RuntimeException e) {
                throw re;
            }
            catch (Exception e) {
                throw re;
            }
            throw annotatedEx;
        }
        if ((TIMEDEBUG || DEBUG) && (classSetupTime = System.currentTimeMillis() - entireClassAnalysisStart) > (long)TIMEQUANTUM) {
            System.out.println(new StringBuffer().append("TIME:  setup ").append(className).append(" ").append(classSetupTime).toString());
        }
        this.progressCallback.finishClass();
    }

    private void reportRecoverableException(String className, Exception e) {
        if (DEBUG) {
            e.printStackTrace();
        }
        this.bugReporter.logError(new StringBuffer().append("Exception analyzing ").append(className).toString(), e);
    }

    private void reportRecoverableDetectorException(String className, Detector detector, Exception e) {
        if (DEBUG) {
            e.printStackTrace();
        }
        this.bugReporter.logError(new StringBuffer().append("Exception analyzing ").append(className).append(" using detector ").append(detector.getClass().getName()).toString(), e);
    }

    private void reportFinal(Detector[] detectors) throws InterruptedException {
        for (Detector detector : detectors) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            detector.report();
        }
    }

    private static JavaClass parseClass(String archiveName, InputStream in, String fileName) throws IOException {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("About to parse ").append(fileName).append(" in ").append(archiveName).toString());
        }
        return FindBugs.parseFromStream(in, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaClass parseClass(URL url) throws IOException {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("About to parse ").append(url.toString()).toString());
        }
        InputStream in = null;
        try {
            in = url.openStream();
            JavaClass javaClass = FindBugs.parseFromStream(in, url.toString());
            return javaClass;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaClass parseFromStream(InputStream in, String fileName) throws IOException {
        try {
            JavaClass javaClass = new ClassParser(in, fileName).parse();
            return javaClass;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static Set<String> handleBugCategories(UserPreferences userPreferences, String categories) {
        HashSet<String> categorySet = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(categories, ",");
        while (tok.hasMoreTokens()) {
            categorySet.add(tok.nextToken());
        }
        return categorySet;
    }

    public static void main(String[] argv) {
        try {
            TextUICommandLine commandLine = new TextUICommandLine();
            FindBugs findBugs = FindBugs.createEngine(commandLine, argv);
            try {
                FindBugs.runMain(findBugs, commandLine);
            }
            catch (RuntimeException e) {
                System.err.println(new StringBuffer().append("Fatal exception: ").append(e.toString()).toString());
                String currentClass = findBugs.getCurrentClass();
                if (currentClass != null) {
                    System.err.println(new StringBuffer().append("\tWhile analyzing ").append(currentClass).toString());
                }
                e.printStackTrace();
                System.err.println("Please report the failure to http://findbugs.sourceforge.net/reportingBugs.html");
                System.exit(1);
            }
        }
        catch (IOException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            System.err.println(new StringBuffer().append("IO Error: ").append(e.getMessage()).toString());
            System.exit(1);
        }
        catch (FilterException e) {
            System.err.println(new StringBuffer().append("Filter exception: ").append(e.getMessage()).toString());
        }
        catch (IllegalArgumentException e) {
            System.err.println(new StringBuffer().append("Illegal argument: ").append(e.getMessage()).toString());
            System.exit(1);
        }
    }

    private static FindBugs createEngine(TextUICommandLine commandLine, String[] argv) throws IOException, FilterException {
        FindBugs findBugs = new FindBugs();
        FindBugs.processCommandLine(commandLine, argv, findBugs);
        return findBugs;
    }

    public static void processCommandLine(TextUICommandLine commandLine, String[] argv, IFindBugsEngine findBugs) throws IOException, FilterException {
        argv = CommandLine.expandOptionFiles(argv, true, true);
        int argCount = 0;
        try {
            argCount = commandLine.parse(argv);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            FindBugs.showHelp(commandLine);
        }
        catch (CommandLine.HelpRequestedException e) {
            FindBugs.showHelp(commandLine);
        }
        Project project = commandLine.getProject();
        for (int i = argCount; i < argv.length; ++i) {
            project.addFile(argv[i]);
        }
        commandLine.handleXArgs();
        if (project.getFileCount() == 0) {
            FindBugs.showHelp(commandLine);
        }
        commandLine.configureEngine(findBugs);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public static void showHelp(TextUICommandLine commandLine) {
        FindBugs.showSynopsis();
        ShowHelp.showGeneralOptions();
        FindBugs.showCommandLineOptions(commandLine);
        System.exit(1);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public static void runMain(IFindBugsEngine findBugs, TextUICommandLine commandLine) throws IOException, RuntimeException {
        try {
            findBugs.execute();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int bugCount = findBugs.getBugCount();
        int missingClassCount = findBugs.getMissingClassCount();
        int errorCount = findBugs.getErrorCount();
        if (!commandLine.quiet() || commandLine.setExitCode()) {
            if (bugCount > 0) {
                System.err.println(new StringBuffer().append("Warnings generated: ").append(bugCount).toString());
            }
            if (missingClassCount > 0) {
                System.err.println(new StringBuffer().append("Missing classes: ").append(missingClassCount).toString());
            }
            if (errorCount > 0) {
                System.err.println(new StringBuffer().append("Analysis errors: ").append(errorCount).toString());
            }
        }
        if (commandLine.setExitCode()) {
            int exitCode = 0;
            if (errorCount > 0) {
                exitCode |= 4;
            }
            if (missingClassCount > 0) {
                exitCode |= 2;
            }
            if (bugCount > 0) {
                exitCode |= 1;
            }
            System.exit(exitCode);
        }
    }

    public static void showCommandLineOptions() {
        FindBugs.showCommandLineOptions(new TextUICommandLine());
    }

    public static void showCommandLineOptions(TextUICommandLine commandLine) {
        System.out.println("Command line options:");
        commandLine.printUsage(System.out);
    }

    public static void showSynopsis() {
        System.out.println("Usage: findbugs [general options] -textui [command line options...] [jar/zip/class files, directories...]");
    }

    public static void configureFilter(DelegatingBugReporter bugReporter, String filterFileName, boolean include) throws IOException, FilterException {
        Filter filter = new Filter(filterFileName);
        BugReporter origBugReporter = bugReporter.getDelegate();
        FilterBugReporter filterBugReporter = new FilterBugReporter(origBugReporter, filter, include);
        bugReporter.setDelegate(filterBugReporter);
    }

    public static void configureBugCollection(IFindBugsEngine findBugs) {
        BugReporter realBugReporter = findBugs.getBugReporter().getRealBugReporter();
        if (realBugReporter instanceof BugCollectionBugReporter) {
            BugCollectionBugReporter bugCollectionBugReporter = (BugCollectionBugReporter)realBugReporter;
            bugCollectionBugReporter = (BugCollectionBugReporter)realBugReporter;
            bugCollectionBugReporter.getBugCollection().setReleaseName(findBugs.getReleaseName());
            Project project = findBugs.getProject();
            if (project.getProjectName() == null) {
                project.setProjectName(findBugs.getProjectName());
            }
            if (project.getTimestamp() != 0L) {
                bugCollectionBugReporter.getBugCollection().setTimestamp(project.getTimestamp());
                bugCollectionBugReporter.getBugCollection().getProjectStats().setTimestamp(project.getTimestamp());
            }
        }
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void setAbridgedMessages(boolean xmlWithAbridgedMessages) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        knownURLProtocolSet = new HashSet<String>();
        knownURLProtocolSet.add("file");
        knownURLProtocolSet.add("http");
        knownURLProtocolSet.add("https");
        knownURLProtocolSet.add("jar");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryClassProducer
    implements ClassProducer {
        private String dirName;
        private List<String> additionalAuxClasspathEntryList;
        private Iterator<String> rfsIter;
        private boolean containsSourceFiles;
        private long time;

        public DirectoryClassProducer(String dirName, List<String> additionalAuxClasspathEntryList) throws InterruptedException {
            this.dirName = dirName;
            this.additionalAuxClasspathEntryList = additionalAuxClasspathEntryList;
            FileFilter filter = new FileFilter(){

                public boolean accept(File file) {
                    String fileName = file.getName();
                    if (file.isDirectory() || fileName.endsWith(".class")) {
                        return true;
                    }
                    if (fileName.endsWith(".java")) {
                        DirectoryClassProducer.this.containsSourceFiles = true;
                    }
                    return false;
                }
            };
            RecursiveFileSearch rfs = new RecursiveFileSearch(dirName, filter).search();
            this.rfsIter = rfs.fileNameIterator();
            this.containsSourceFiles = false;
        }

        @Override
        public JavaClass getNextClass() throws IOException, InterruptedException {
            String fileName;
            while (true) {
                if (!this.rfsIter.hasNext()) {
                    return null;
                }
                fileName = this.rfsIter.next();
                if (FindBugs.this.classScreener.matches(fileName)) break;
                String dirURL = new StringBuffer().append("file:").append(this.dirName).toString();
                if (this.additionalAuxClasspathEntryList.contains(dirURL)) continue;
                this.additionalAuxClasspathEntryList.add(dirURL);
            }
            try {
                long modTime = new File(fileName).lastModified();
                if (this.time < modTime) {
                    this.time = modTime;
                }
                return FindBugs.parseClass(new URL(new StringBuffer().append("file:").append(fileName).toString()));
            }
            catch (ClassFormatException e) {
                throw new ClassFormatException(new StringBuffer().append("Invalid class file format for ").append(fileName).append(": ").append(e.getMessage()).toString());
            }
        }

        @Override
        public boolean containsSourceFiles() {
            return this.containsSourceFiles;
        }

        @Override
        public void close() {
        }

        @Override
        public long getLastModificationTime() {
            return this.time;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZipClassProducer
    implements ClassProducer {
        private URL url;
        private LinkedList<ArchiveWorkListItem> archiveWorkList;
        private List<String> additionalAuxClasspathEntryList;
        private ZipInputStream zipInputStream;
        private boolean containsSourceFiles;
        private long time = 0L;
        private long zipTime = 0L;
        static final long millisecondsInAYear = 31556926000L;

        public ZipClassProducer(URL url, LinkedList<ArchiveWorkListItem> archiveWorkList, List<String> additionalAuxClasspathEntryList) throws IOException {
            this.url = url;
            this.archiveWorkList = archiveWorkList;
            this.additionalAuxClasspathEntryList = additionalAuxClasspathEntryList;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Opening jar/zip input stream for ").append(url.toString()).toString());
            }
            URLConnection u = url.openConnection();
            this.zipTime = u.getLastModified();
            this.zipInputStream = new ZipInputStream(u.getInputStream());
            this.containsSourceFiles = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JavaClass getNextClass() throws IOException, InterruptedException {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ZipEntry zipEntry = this.zipInputStream.getNextEntry();
                if (zipEntry == null) {
                    return null;
                }
                try {
                    String entryName = zipEntry.getName();
                    if (!FindBugs.this.classScreener.matches(entryName)) {
                        if (this.additionalAuxClasspathEntryList.contains(this.url.toString())) continue;
                        this.additionalAuxClasspathEntryList.add(this.url.toString());
                        continue;
                    }
                    String fileExtension = URLClassPath.getFileExtension(entryName);
                    if (fileExtension == null) continue;
                    if (fileExtension.equals(".class")) {
                        long modTime = zipEntry.getTime();
                        if (modTime > this.time) {
                            this.time = modTime;
                        }
                        JavaClass javaClass = FindBugs.parseClass(this.url.toString(), new NoCloseInputStream(this.zipInputStream), entryName);
                        return javaClass;
                    }
                    if (Archive.ARCHIVE_EXTENSION_SET.contains(fileExtension)) {
                        if (this.url.toString().indexOf("!/") >= 0) continue;
                        ArchiveWorkListItem nestedItem = new ArchiveWorkListItem(new StringBuffer().append("jar:").append(this.url.toString()).append("!/").append(entryName).toString(), false);
                        this.archiveWorkList.addFirst(nestedItem);
                        continue;
                    }
                    if (!fileExtension.equals(".java")) continue;
                    this.containsSourceFiles = true;
                    continue;
                }
                finally {
                    this.zipInputStream.closeEntry();
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean containsSourceFiles() {
            return this.containsSourceFiles;
        }

        @Override
        public void close() {
            if (this.zipInputStream != null) {
                try {
                    this.zipInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public long getLastModificationTime() {
            if (this.time + 31556926000L > this.zipTime) {
                return this.time;
            }
            return this.zipTime;
        }
    }

    private class SingleClassProducer
    implements ClassProducer {
        private URL url;
        long time = 0L;

        public SingleClassProducer(URL url) {
            this.url = url;
        }

        public JavaClass getNextClass() throws IOException, InterruptedException {
            if (this.url == null) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            URL urlToParse = this.url;
            this.url = null;
            if (!FindBugs.this.classScreener.matches(urlToParse.toString())) {
                return null;
            }
            try {
                URLConnection u = urlToParse.openConnection();
                this.time = u.getLastModified();
                return FindBugs.parseFromStream(u.getInputStream(), urlToParse.toString());
            }
            catch (ClassFormatException e) {
                throw new ClassFormatException("Invalid class file format for " + urlToParse.toString() + ": " + e.getMessage());
            }
        }

        public boolean containsSourceFiles() {
            return false;
        }

        public void close() {
        }

        public long getLastModificationTime() {
            return this.time;
        }
    }

    private static interface ClassProducer {
        public JavaClass getNextClass() throws IOException, InterruptedException;

        public boolean containsSourceFiles();

        public long getLastModificationTime();

        public void close();
    }

    private static class ArchiveWorkListItem {
        private String fileName;
        private boolean explicit;

        public ArchiveWorkListItem(String fileName, boolean explicit) {
            this.fileName = fileName;
            this.explicit = explicit;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isExplicit() {
            return this.explicit;
        }
    }

    private static class NoCloseInputStream
    extends DataInputStream {
        public NoCloseInputStream(InputStream in) {
            super(in);
        }

        public void close() {
        }
    }
}

