/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SAXBugCollectionHandler;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.model.ClassFeatureSet;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.Dom4JXMLOutput;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutputUtil;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.TransformerException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.aelfred.SAXDriver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedBugCollection
implements BugCollection {
    long analysisTimestamp = System.currentTimeMillis();
    String analysisVersion = Version.RELEASE;
    private boolean withMessages = false;
    private static final boolean REPORT_SUMMARY_HTML;
    private Comparator<BugInstance> comparator;
    private TreeSet<BugInstance> bugSet;
    private List<AnalysisError> errorList;
    private TreeSet<String> missingClassSet;
    @CheckForNull
    private String summaryHTML;
    private ProjectStats projectStats;
    private Map<String, ClassFeatureSet> classFeatureSetMap;
    private List<AppVersion> appVersionList;
    private boolean preciseHashOccurrenceNumbersAvailable = false;
    private long sequence;
    private String releaseName;
    private long timestamp;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$SortedBugCollection;

    @Override
    public long getAnalysisTimestamp() {
        return this.analysisTimestamp;
    }

    @Override
    public void setAnalysisTimestamp(long timestamp) {
        this.analysisTimestamp = timestamp;
    }

    public void addAll(Collection<BugInstance> collection) {
        for (BugInstance aCollection : collection) {
            this.add(aCollection);
        }
    }

    public void addAll(Collection<BugInstance> collection, boolean updateActiveTime) {
        for (BugInstance warning : collection) {
            this.add(warning, updateActiveTime);
        }
    }

    @Override
    public boolean add(BugInstance bugInstance) {
        return this.add(bugInstance, true);
    }

    @Override
    public void addError(String message) {
        this.addError(message, null);
    }

    @Override
    public AppVersion getCurrentAppVersion() {
        return new AppVersion(this.getSequenceNumber()).setReleaseName(this.getReleaseName()).setTimestamp(this.getTimestamp()).setNumClasses(this.getProjectStats().getNumClasses()).setCodeSize(this.getProjectStats().getCodeSize());
    }

    @Override
    public void readXML(String fileName, Project project) throws IOException, DocumentException {
        this.readXML(new File(fileName), project);
    }

    public void readXML(File file, Project project) throws IOException, DocumentException {
        FilterInputStream in = new BufferedInputStream(new FileInputStream(file));
        if (file.getName().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        this.readXML(in, project, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXML(InputStream in, Project project, File base) throws IOException, DocumentException {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (project == null) {
                throw new IllegalArgumentException();
            }
            this.doReadXML(in, project, base);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void readXML(InputStream in, Project project) throws IOException, DocumentException {
        this.doReadXML(in, project, null);
    }

    private void doReadXML(InputStream in, Project project, File base) throws IOException, DocumentException {
        this.checkInputStream(in);
        try {
            SAXBugCollectionHandler handler = new SAXBugCollectionHandler(this, project, base);
            XMLReader xr = null;
            try {
                xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                AnalysisContext.logError("Couldn't create XMLReaderFactory", e);
            }
            if (xr == null) {
                xr = new SAXDriver();
            }
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            Reader reader = Util.getReader(in);
            xr.parse(new InputSource(reader));
        }
        catch (SAXParseException e) {
            throw new DocumentException(new StringBuffer().append("Parse error at line ").append(e.getLineNumber()).append(" : ").append(e.getColumnNumber()).toString(), e);
        }
        catch (SAXException e) {
            throw new DocumentException("Sax error ", e);
        }
        finally {
            in.close();
        }
        project.setModified(false);
    }

    @Override
    public void writeXML(String fileName, Project project) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
        this.writeXML(out, project);
    }

    public void writeXML(File file, Project project) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        this.writeXML(out, project);
    }

    @Override
    public Document toDocument(Project project) {
        if (project == null) {
            throw new NullPointerException("No project");
        }
        DocumentFactory docFactory = new DocumentFactory();
        Document document = docFactory.createDocument();
        Dom4JXMLOutput treeBuilder = new Dom4JXMLOutput(document);
        try {
            this.writeXML(treeBuilder, project);
        }
        catch (IOException e) {
            // empty catch block
        }
        return document;
    }

    @Override
    public void writeXML(OutputStream out, Project project) throws IOException {
        if (project == null) {
            throw new NullPointerException("No project");
        }
        OutputStreamXMLOutput xmlOutput = this.withMessages ? new OutputStreamXMLOutput(out, "http://findbugs.sourceforge.net/xsl/default.xsl") : new OutputStreamXMLOutput(out);
        this.writeXML(xmlOutput, project);
    }

    @Override
    public void writePrologue(XMLOutput xmlOutput, Project project) throws IOException {
        xmlOutput.beginDocument();
        xmlOutput.openTag("BugCollection", new XMLAttributeList().addAttribute("version", this.analysisVersion).addAttribute("sequence", String.valueOf(this.getSequenceNumber())).addAttribute("timestamp", String.valueOf(this.getTimestamp())).addAttribute("analysisTimestamp", String.valueOf(this.getAnalysisTimestamp())).addAttribute("release", this.getReleaseName()));
        project.writeXML(xmlOutput);
    }

    private String getQuickInstanceHash(BugInstance bugInstance) {
        String hash = bugInstance.getInstanceHash();
        if (hash != null) {
            return hash;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e2) {
            // empty catch block
        }
        hash = bugInstance.getInstanceKey();
        if (digest != null) {
            String tmp;
            byte[] data = digest.digest(hash.getBytes());
            hash = tmp = new BigInteger(1, data).toString(16);
        }
        bugInstance.setInstanceHash(hash);
        return hash;
    }

    public void computeBugHashes() {
        if (this.preciseHashOccurrenceNumbersAvailable) {
            return;
        }
        this.invalidateHashes();
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e2) {
            // empty catch block
        }
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        for (BugInstance bugInstance : this.getCollection()) {
            Integer count;
            String hash = bugInstance.getInstanceHash();
            if (hash == null) {
                hash = bugInstance.getInstanceKey();
                if (digest != null) {
                    String tmp;
                    byte[] data = digest.digest(hash.getBytes());
                    hash = tmp = new BigInteger(1, data).toString(16);
                }
                bugInstance.setInstanceHash(hash);
            }
            if ((count = (Integer)seen.get(hash)) == null) {
                bugInstance.setInstanceOccurrenceNum(0);
                seen.put(hash, new Integer(0));
                continue;
            }
            bugInstance.setInstanceOccurrenceNum(count + 1);
            seen.put(hash, new Integer(count + 1));
        }
        for (BugInstance bugInstance : this.getCollection()) {
            bugInstance.setInstanceOccurrenceMax((Integer)seen.get(bugInstance.getInstanceHash()));
        }
        this.preciseHashOccurrenceNumbersAvailable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXML(XMLOutput xmlOutput, @NonNull Project project) throws IOException {
        if (project == null) {
            throw new NullPointerException("No project");
        }
        try {
            this.writePrologue(xmlOutput, project);
            if (this.withMessages) {
                this.computeBugHashes();
            }
            for (BugInstance bugInstance : this.getCollection()) {
                bugInstance.writeXML(xmlOutput, this.withMessages);
            }
            this.writeEpilogue(xmlOutput);
        }
        finally {
            xmlOutput.finish();
        }
    }

    @Override
    public void writeEpilogue(XMLOutput xmlOutput) throws IOException {
        String html;
        if (this.withMessages) {
            this.writeBugCategories(xmlOutput);
            this.writeBugPatterns(xmlOutput);
            this.writeBugCodes(xmlOutput);
        }
        this.emitErrors(xmlOutput);
        this.getProjectStats().writeXML(xmlOutput);
        xmlOutput.openTag("ClassFeatures");
        Iterator<XMLWriteable> i = this.classFeatureSetIterator();
        while (i.hasNext()) {
            ClassFeatureSet classFeatureSet = i.next();
            classFeatureSet.writeXML(xmlOutput);
        }
        xmlOutput.closeTag("ClassFeatures");
        xmlOutput.openTag("History");
        i = this.appVersionIterator();
        while (i.hasNext()) {
            AppVersion appVersion = (AppVersion)i.next();
            appVersion.writeXML(xmlOutput);
        }
        xmlOutput.closeTag("History");
        if (REPORT_SUMMARY_HTML && (html = this.getSummaryHTML()) != null && !html.equals("")) {
            xmlOutput.openTag("SummaryHTML");
            xmlOutput.writeCDATA(html);
            xmlOutput.closeTag("SummaryHTML");
        }
        xmlOutput.closeTag("BugCollection");
    }

    private void writeBugPatterns(XMLOutput xmlOutput) throws IOException {
        BugPattern bugPattern;
        HashSet<String> bugTypeSet = new HashSet<String>();
        Iterator<BugInstance> i = this.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = i.next();
            bugPattern = bugInstance.getBugPattern();
            if (bugPattern == null) continue;
            bugTypeSet.add(bugPattern.getType());
        }
        for (String bugType : bugTypeSet) {
            bugPattern = I18N.instance().lookupBugPattern(bugType);
            if (bugPattern == null) continue;
            XMLAttributeList attributeList = new XMLAttributeList();
            attributeList.addAttribute("type", bugType);
            attributeList.addAttribute("abbrev", bugPattern.getAbbrev());
            attributeList.addAttribute("category", bugPattern.getCategory());
            xmlOutput.openTag("BugPattern", attributeList);
            xmlOutput.openTag("ShortDescription");
            xmlOutput.writeText(bugPattern.getShortDescription());
            xmlOutput.closeTag("ShortDescription");
            xmlOutput.openTag("Details");
            xmlOutput.writeCDATA(bugPattern.getDetailText());
            xmlOutput.closeTag("Details");
            xmlOutput.closeTag("BugPattern");
        }
    }

    private void writeBugCodes(XMLOutput xmlOutput) throws IOException {
        HashSet<String> bugCodeSet = new HashSet<String>();
        Iterator<BugInstance> i = this.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = i.next();
            String bugCode = bugInstance.getAbbrev();
            if (bugCode == null) continue;
            bugCodeSet.add(bugCode);
        }
        for (String bugCode : bugCodeSet) {
            String bugCodeDescription = I18N.instance().getBugTypeDescription(bugCode);
            if (bugCodeDescription == null) continue;
            XMLAttributeList attributeList = new XMLAttributeList();
            attributeList.addAttribute("abbrev", bugCode);
            xmlOutput.openTag("BugCode", attributeList);
            xmlOutput.openTag("Description");
            xmlOutput.writeText(bugCodeDescription);
            xmlOutput.closeTag("Description");
            xmlOutput.closeTag("BugCode");
        }
    }

    private void writeBugCategories(XMLOutput xmlOutput) throws IOException {
        HashSet<String> bugCatSet = new HashSet<String>();
        Iterator<BugInstance> i = this.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = i.next();
            BugPattern bugPattern = bugInstance.getBugPattern();
            if (bugPattern == null) continue;
            bugCatSet.add(bugPattern.getCategory());
        }
        for (String bugCat : bugCatSet) {
            String bugCatDescription = I18N.instance().getBugCategoryDescription(bugCat);
            if (bugCatDescription == null) continue;
            XMLAttributeList attributeList = new XMLAttributeList();
            attributeList.addAttribute("category", bugCat);
            xmlOutput.openTag("BugCategory", attributeList);
            xmlOutput.openTag("Description");
            xmlOutput.writeText(bugCatDescription);
            xmlOutput.closeTag("Description");
            xmlOutput.closeTag("BugCategory");
        }
    }

    private void emitErrors(XMLOutput xmlOutput) throws IOException {
        xmlOutput.openTag("Errors");
        Iterator<AnalysisError> i = this.errorIterator();
        while (i.hasNext()) {
            String[] stackTrace;
            AnalysisError error = i.next();
            xmlOutput.openTag("Error");
            xmlOutput.openTag("ErrorMessage");
            xmlOutput.writeText(error.getMessage());
            xmlOutput.closeTag("ErrorMessage");
            if (error.getExceptionMessage() != null) {
                xmlOutput.openTag("Exception");
                xmlOutput.writeText(error.getExceptionMessage());
                xmlOutput.closeTag("Exception");
            }
            if ((stackTrace = error.getStackTrace()) != null) {
                for (String aStackTrace : stackTrace) {
                    xmlOutput.openTag("StackTrace");
                    xmlOutput.writeText(aStackTrace);
                    xmlOutput.closeTag("StackTrace");
                }
            }
            xmlOutput.closeTag("Error");
        }
        XMLOutputUtil.writeElementList(xmlOutput, "MissingClass", this.missingClassIterator());
        xmlOutput.closeTag("Errors");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputStream(InputStream in) throws IOException {
        if (in.markSupported()) {
            int n;
            byte[] buf = new byte[200];
            in.mark(buf.length);
            for (int numRead = 0; numRead < buf.length; numRead += n) {
                n = in.read(buf, numRead, buf.length - numRead);
                if (n >= 0) continue;
                throw new IOException("XML does not contain saved bug data");
            }
            in.reset();
            BufferedReader reader = new BufferedReader(Util.getReader(new ByteArrayInputStream(buf)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("<BugCollection")) continue;
                    return;
                }
            }
            finally {
                reader.close();
            }
            throw new IOException("XML does not contain saved bug data");
        }
    }

    public static void cloneAll(Collection<BugInstance> dest, Collection<BugInstance> source) {
        for (BugInstance obj : source) {
            dest.add((BugInstance)obj.clone());
        }
    }

    public SortedBugCollection() {
        this(new ProjectStats());
    }

    public SortedBugCollection(Comparator<BugInstance> comparator) {
        this(new ProjectStats(), comparator);
    }

    public SortedBugCollection(ProjectStats projectStats) {
        this(projectStats, MultiversionBugInstanceComparator.instance);
    }

    public SortedBugCollection(ProjectStats projectStats, Comparator<BugInstance> comparator) {
        this.projectStats = projectStats;
        this.comparator = comparator;
        this.bugSet = new TreeSet<BugInstance>(comparator);
        this.errorList = new LinkedList<AnalysisError>();
        this.missingClassSet = new TreeSet();
        this.summaryHTML = null;
        this.classFeatureSetMap = new TreeMap<String, ClassFeatureSet>();
        this.sequence = 0L;
        this.appVersionList = new LinkedList<AppVersion>();
        this.releaseName = "";
        this.timestamp = -1L;
    }

    @Override
    public boolean add(BugInstance bugInstance, boolean updateActiveTime) {
        this.preciseHashOccurrenceNumbersAvailable = false;
        if (updateActiveTime) {
            bugInstance.setFirstVersion(this.sequence);
        }
        return this.bugSet.add(bugInstance);
    }

    private void invalidateHashes() {
        this.preciseHashOccurrenceNumbersAvailable = false;
    }

    public boolean remove(BugInstance bugInstance) {
        this.invalidateHashes();
        return this.bugSet.remove(bugInstance);
    }

    @Override
    public Iterator<BugInstance> iterator() {
        return this.bugSet.iterator();
    }

    @Override
    public Collection<BugInstance> getCollection() {
        return this.bugSet;
    }

    public void addError(String message, Throwable exception) {
        if (exception instanceof MissingClassException) {
            MissingClassException e = (MissingClassException)exception;
            this.addMissingClass(AbstractBugReporter.getMissingClassName(e.getClassNotFoundException()));
            return;
        }
        if (exception instanceof ClassNotFoundException) {
            ClassNotFoundException e = (ClassNotFoundException)exception;
            this.addMissingClass(AbstractBugReporter.getMissingClassName(e));
            return;
        }
        this.errorList.add(new AnalysisError(message, exception));
    }

    @Override
    public void addError(AnalysisError error) {
        this.errorList.add(error);
    }

    @Override
    public void addMissingClass(String className) {
        if (className.startsWith("[")) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)new StringBuffer().append("Bad class name ").append(className).toString());
            }
            return;
        }
        this.missingClassSet.add(className);
    }

    public Iterator<AnalysisError> errorIterator() {
        return this.errorList.iterator();
    }

    public Iterator<String> missingClassIterator() {
        return this.missingClassSet.iterator();
    }

    public boolean contains(BugInstance bugInstance) {
        return this.bugSet.contains(bugInstance);
    }

    public BugInstance getMatching(BugInstance bugInstance) {
        SortedSet<BugInstance> tailSet = this.bugSet.tailSet(bugInstance);
        if (tailSet.isEmpty()) {
            return null;
        }
        BugInstance first = tailSet.first();
        return bugInstance.equals(first) ? first : null;
    }

    public String getSummaryHTML() throws IOException {
        if (this.summaryHTML == null) {
            try {
                StringWriter writer = new StringWriter();
                ProjectStats stats = this.getProjectStats();
                stats.transformSummaryToHTML(writer);
                this.summaryHTML = writer.toString();
            }
            catch (TransformerException e) {
                IOException ioe = new IOException("Couldn't generate summary HTML");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.summaryHTML;
    }

    @Override
    public ProjectStats getProjectStats() {
        return this.projectStats;
    }

    @Override
    @Deprecated
    public BugInstance lookupFromUniqueId(String uniqueId) {
        for (BugInstance bug : this.bugSet) {
            if (!bug.getInstanceHash().equals(uniqueId)) continue;
            return bug;
        }
        return null;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequence;
    }

    @Override
    public void setSequenceNumber(long sequence) {
        this.sequence = sequence;
    }

    public SortedBugCollection duplicate() {
        SortedBugCollection dup = new SortedBugCollection((ProjectStats)this.projectStats.clone(), this.comparator);
        SortedBugCollection.cloneAll(dup.bugSet, this.bugSet);
        dup.errorList.addAll(this.errorList);
        dup.missingClassSet.addAll(this.missingClassSet);
        dup.summaryHTML = this.summaryHTML;
        dup.classFeatureSetMap.putAll(this.classFeatureSetMap);
        dup.sequence = this.sequence;
        dup.timestamp = this.timestamp;
        dup.releaseName = this.releaseName;
        for (AppVersion appVersion : this.appVersionList) {
            dup.appVersionList.add((AppVersion)appVersion.clone());
        }
        return dup;
    }

    public void clearBugInstances() {
        this.bugSet.clear();
        this.invalidateHashes();
    }

    @Override
    public String getReleaseName() {
        if (this.releaseName == null) {
            return "";
        }
        return this.releaseName;
    }

    @Override
    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    @Override
    public Iterator<AppVersion> appVersionIterator() {
        return this.appVersionList.iterator();
    }

    @Override
    public void addAppVersion(AppVersion appVersion) {
        this.appVersionList.add(appVersion);
    }

    @Override
    public void clearAppVersions() {
        this.appVersionList.clear();
    }

    @Override
    public SortedBugCollection createEmptyCollectionWithMetadata() {
        SortedBugCollection dup = new SortedBugCollection((ProjectStats)this.projectStats.clone(), this.comparator);
        dup.errorList.addAll(this.errorList);
        dup.missingClassSet.addAll(this.missingClassSet);
        dup.summaryHTML = this.summaryHTML;
        dup.classFeatureSetMap.putAll(this.classFeatureSetMap);
        dup.sequence = this.sequence;
        dup.timestamp = this.timestamp;
        dup.releaseName = this.releaseName;
        for (AppVersion appVersion : this.appVersionList) {
            dup.appVersionList.add((AppVersion)appVersion.clone());
        }
        return dup;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public ClassFeatureSet getClassFeatureSet(String className) {
        return this.classFeatureSetMap.get(className);
    }

    @Override
    public void setClassFeatureSet(ClassFeatureSet classFeatureSet) {
        this.classFeatureSetMap.put(classFeatureSet.getClassName(), classFeatureSet);
    }

    public Iterator<ClassFeatureSet> classFeatureSetIterator() {
        return this.classFeatureSetMap.values().iterator();
    }

    @Override
    public void clearClassFeatures() {
        this.classFeatureSetMap.clear();
    }

    @Override
    public void setWithMessages(boolean withMessages) {
        this.withMessages = withMessages;
    }

    @Override
    public boolean getWithMessages() {
        return this.withMessages;
    }

    @Override
    public AppVersion getAppVersionFromSequenceNumber(long target) {
        for (AppVersion av : this.appVersionList) {
            if (av.getSequenceNumber() != target) continue;
            return av;
        }
        if (target == this.getSequenceNumber()) {
            return this.getCurrentAppVersion();
        }
        return null;
    }

    @Override
    public BugInstance findBug(String instanceHash, String bugType, int lineNumber) {
        for (BugInstance bug : this.bugSet) {
            if (!bug.getInstanceHash().equals(instanceHash) || !bug.getBugPattern().getType().equals(bugType) || bug.getPrimarySourceLineAnnotation().getStartLine() != lineNumber) continue;
            return bug;
        }
        return null;
    }

    public void setAnalysisVersion(String version) {
        this.analysisVersion = version;
    }

    @Override
    public /* synthetic */ BugCollection createEmptyCollectionWithMetadata() {
        return this.createEmptyCollectionWithMetadata();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$SortedBugCollection == null ? (class$edu$umd$cs$findbugs$SortedBugCollection = SortedBugCollection.class$("edu.umd.cs.findbugs.SortedBugCollection")) : class$edu$umd$cs$findbugs$SortedBugCollection).desiredAssertionStatus();
        REPORT_SUMMARY_HTML = SystemProperties.getBoolean("findbugs.report.SummaryHTML");
    }

    public static class MultiversionBugInstanceComparator
    extends BugInstanceComparator {
        public static final MultiversionBugInstanceComparator instance = new MultiversionBugInstanceComparator();

        public int compare(BugInstance lhs, BugInstance rhs) {
            int result = super.compare(lhs, rhs);
            if (result != 0) {
                return result;
            }
            long diff = lhs.getFirstVersion() - rhs.getFirstVersion();
            if (diff == 0L) {
                diff = lhs.getLastVersion() - rhs.getLastVersion();
            }
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BugInstanceComparator
    implements Comparator<BugInstance> {
        public static final BugInstanceComparator instance = new BugInstanceComparator();

        private BugInstanceComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            ClassAnnotation lca = lhs.getPrimaryClass();
            ClassAnnotation rca = rhs.getPrimaryClass();
            if (lca == null || rca == null) {
                throw new IllegalStateException(new StringBuffer().append("null class annotation: ").append(lca).append(",").append(rca).toString());
            }
            int cmp = lca.getClassName().compareTo(rca.getClassName());
            if (cmp != 0) {
                return cmp;
            }
            return lhs.compareTo(rhs);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }
}

