/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.npe.ReturnPathType;
import java.util.HashMap;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnPathTypeAnalysis
implements DataflowAnalysis<ReturnPathType> {
    private CFG cfg;
    private DepthFirstSearch dfs;
    private ReverseDepthFirstSearch rdfs;
    private HashMap<BasicBlock, ReturnPathType> startFactMap;
    private HashMap<BasicBlock, ReturnPathType> resultFactMap;

    public ReturnPathTypeAnalysis(CFG cfg, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        this.cfg = cfg;
        this.dfs = dfs;
        this.rdfs = rdfs;
        this.startFactMap = new HashMap();
        this.resultFactMap = new HashMap();
    }

    @Override
    public void copy(ReturnPathType source, ReturnPathType dest) {
        dest.copyFrom(source);
    }

    @Override
    public ReturnPathType createFact() {
        ReturnPathType fact = new ReturnPathType();
        fact.setTop();
        return fact;
    }

    @Override
    public void edgeTransfer(Edge edge, ReturnPathType fact) {
        if (edge.getTarget() == this.cfg.getExit()) {
            fact.setCanReturnNormally(!edge.isExceptionEdge());
        }
    }

    @Override
    public void finishIteration() {
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReverseDFSOrder(cfg, this.rdfs, this.dfs);
    }

    @Override
    public int getLastUpdateTimestamp(ReturnPathType fact) {
        return 0;
    }

    @Override
    public ReturnPathType getResultFact(BasicBlock block) {
        return this.getOrCreateFact(this.resultFactMap, block);
    }

    @Override
    public ReturnPathType getStartFact(BasicBlock block) {
        return this.getOrCreateFact(this.startFactMap, block);
    }

    private ReturnPathType getOrCreateFact(HashMap<BasicBlock, ReturnPathType> map, BasicBlock block) {
        ReturnPathType returnPathType = map.get(block);
        if (returnPathType == null) {
            returnPathType = this.createFact();
            map.put(block, returnPathType);
        }
        return returnPathType;
    }

    @Override
    public void initEntryFact(ReturnPathType result) throws DataflowAnalysisException {
        result.setCanReturnNormally(true);
    }

    @Override
    public void initResultFact(ReturnPathType result) {
        this.makeFactTop(result);
    }

    @Override
    public boolean isForwards() {
        return false;
    }

    @Override
    public boolean isTop(ReturnPathType fact) {
        return fact.isTop();
    }

    @Override
    public void makeFactTop(ReturnPathType fact) {
        fact.setTop();
    }

    @Override
    public void meetInto(ReturnPathType fact, Edge edge, ReturnPathType result) throws DataflowAnalysisException {
        result.mergeWith(fact);
    }

    @Override
    public boolean same(ReturnPathType fact1, ReturnPathType fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public void setLastUpdateTimestamp(ReturnPathType fact, int timestamp) {
    }

    @Override
    public void startIteration() {
    }

    @Override
    public void transfer(BasicBlock basicBlock, InstructionHandle end, ReturnPathType start, ReturnPathType result) throws DataflowAnalysisException {
        result.copyFrom(start);
    }

    @Override
    public /* synthetic */ void setLastUpdateTimestamp(Object x0, int x1) {
        this.setLastUpdateTimestamp((ReturnPathType)x0, x1);
    }

    @Override
    public /* synthetic */ int getLastUpdateTimestamp(Object x0) {
        return this.getLastUpdateTimestamp((ReturnPathType)x0);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((ReturnPathType)x0, x1, (ReturnPathType)x2);
    }

    @Override
    public /* synthetic */ void edgeTransfer(Edge x0, Object x1) throws DataflowAnalysisException {
        this.edgeTransfer(x0, (ReturnPathType)x1);
    }

    @Override
    public /* synthetic */ void transfer(BasicBlock x0, InstructionHandle x1, Object x2, Object x3) throws DataflowAnalysisException {
        this.transfer(x0, x1, (ReturnPathType)x2, (ReturnPathType)x3);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((ReturnPathType)x0, (ReturnPathType)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((ReturnPathType)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((ReturnPathType)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((ReturnPathType)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((ReturnPathType)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((ReturnPathType)x0, (ReturnPathType)x1);
    }

    @Override
    public /* synthetic */ Object getResultFact(BasicBlock x0) {
        return this.getResultFact(x0);
    }

    @Override
    public /* synthetic */ Object getStartFact(BasicBlock x0) {
        return this.getStartFact(x0);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }
}

