/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IDatabaseFactory;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisCache
implements IAnalysisCache {
    private static final int CACHE_SIZE = 5;
    private IClassPath classPath;
    private IErrorLogger errorLogger;
    private Map<Class<?>, IClassAnalysisEngine> classAnalysisEngineMap;
    private Map<Class<?>, IMethodAnalysisEngine> methodAnalysisEngineMap;
    private Map<Class<?>, IDatabaseFactory<?>> databaseFactoryMap;
    private Map<Class<?>, Map<ClassDescriptor, Object>> classAnalysisMap;
    private Map<Class<?>, Map<MethodDescriptor, Object>> methodAnalysisMap;
    private Map<Class<?>, Object> databaseMap;
    static final AbnormalAnalysisResult NULL_ANALYSIS_RESULT = new AbnormalAnalysisResult(true);

    AnalysisCache(IClassPath classPath, IErrorLogger errorLogger) {
        this.classPath = classPath;
        this.errorLogger = errorLogger;
        this.classAnalysisEngineMap = new HashMap();
        this.methodAnalysisEngineMap = new HashMap();
        this.databaseFactoryMap = new HashMap();
        this.classAnalysisMap = new HashMap();
        this.methodAnalysisMap = new HashMap();
        this.databaseMap = new HashMap();
    }

    @Override
    public IClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    public <E> E getClassAnalysis(Class<E> analysisClass, ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        return AnalysisCache.analyzeClassOrMethod(this, this.classAnalysisMap, this.classAnalysisEngineMap, classDescriptor, analysisClass);
    }

    @Override
    public <E> E probeClassAnalysis(Class<E> analysisClass, ClassDescriptor classDescriptor) {
        Map<ClassDescriptor, Object> descriptorMap = this.classAnalysisMap.get(analysisClass);
        if (descriptorMap == null) {
            return null;
        }
        return (E)descriptorMap.get(classDescriptor);
    }

    @Override
    public <E> E getMethodAnalysis(Class<E> analysisClass, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return AnalysisCache.analyzeClassOrMethod(this, this.methodAnalysisMap, this.methodAnalysisEngineMap, methodDescriptor, analysisClass);
    }

    @Override
    public <E> void eagerlyPutMethodAnalysis(Class<E> analysisClass, MethodDescriptor methodDescriptor, Object analysisObject) {
        Map descriptorMap = AnalysisCache.findOrCreateDescriptorMap(this.methodAnalysisMap, this.methodAnalysisEngineMap, analysisClass);
        descriptorMap.put(methodDescriptor, analysisObject);
    }

    @Override
    public void purgeMethodAnalyses(MethodDescriptor methodDescriptor) {
        for (Map.Entry<Class<?>, Map<MethodDescriptor, Object>> entry : this.methodAnalysisMap.entrySet()) {
            IMethodAnalysisEngine engine = this.methodAnalysisEngineMap.get(entry.getKey());
            if (engine.retainAnalysisResults()) continue;
            entry.getValue().remove(methodDescriptor);
        }
    }

    static <DescriptorType, E> E analyzeClassOrMethod(AnalysisCache analysisCache, Map<Class<?>, Map<DescriptorType, Object>> analysisClassToDescriptorMapMap, Map<Class<?>, ? extends IAnalysisEngine<DescriptorType>> engineMap, DescriptorType descriptor, Class<E> analysisClass) throws CheckedAnalysisException {
        Map<DescriptorType, Object> descriptorMap = AnalysisCache.findOrCreateDescriptorMap(analysisClassToDescriptorMapMap, engineMap, analysisClass);
        Object analysisResult = descriptorMap.get(descriptor);
        if (analysisResult == null) {
            IAnalysisEngine<DescriptorType> engine = engineMap.get(analysisClass);
            if (engine == null) {
                throw new IllegalArgumentException(new StringBuffer().append("No analysis engine registered to produce ").append(analysisClass.getName()).toString());
            }
            try {
                analysisResult = engine.analyze(analysisCache, descriptor);
                if (analysisResult == null) {
                    analysisResult = NULL_ANALYSIS_RESULT;
                }
            }
            catch (CheckedAnalysisException e) {
                analysisResult = new AbnormalAnalysisResult(e);
            }
            catch (RuntimeException e) {
                analysisResult = new AbnormalAnalysisResult(e);
            }
            descriptorMap.put(descriptor, analysisResult);
        }
        if (analysisResult instanceof AbnormalAnalysisResult) {
            if (analysisResult == NULL_ANALYSIS_RESULT) {
                return null;
            }
            AbnormalAnalysisResult abnormalAnalysisResult = (AbnormalAnalysisResult)analysisResult;
            if (abnormalAnalysisResult.checkedAnalysisException != null) {
                throw abnormalAnalysisResult.checkedAnalysisException;
            }
            if (abnormalAnalysisResult.runtimeException != null) {
                throw abnormalAnalysisResult.runtimeException;
            }
            throw new IllegalStateException("can't happen");
        }
        return (E)analysisResult;
    }

    private static <DescriptorType, E> Map<DescriptorType, Object> findOrCreateDescriptorMap(Map<Class<?>, Map<DescriptorType, Object>> analysisClassToDescriptorMapMap, final Map<Class<?>, ? extends IAnalysisEngine<DescriptorType>> engineMap, final Class<E> analysisClass) {
        MapCache descriptorMap = analysisClassToDescriptorMapMap.get(analysisClass);
        if (descriptorMap == null) {
            descriptorMap = new MapCache<DescriptorType, Object>(5){
                IAnalysisEngine<DescriptorType> engine;
                {
                    super(x0);
                    this.engine = (IAnalysisEngine)engineMap.get(analysisClass);
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<DescriptorType, Object> eldest) {
                    if (this.engine.retainAnalysisResults()) {
                        return false;
                    }
                    return super.removeEldestEntry(eldest);
                }
            };
            analysisClassToDescriptorMapMap.put(analysisClass, descriptorMap);
        }
        return descriptorMap;
    }

    @Override
    public <E> void registerClassAnalysisEngine(Class<E> analysisResultType, IClassAnalysisEngine classAnalysisEngine) {
        this.classAnalysisEngineMap.put(analysisResultType, classAnalysisEngine);
    }

    @Override
    public <E> void registerMethodAnalysisEngine(Class<E> analysisResultType, IMethodAnalysisEngine methodAnalysisEngine) {
        this.methodAnalysisEngineMap.put(analysisResultType, methodAnalysisEngine);
    }

    @Override
    public <E> void registerDatabaseFactory(Class<E> databaseClass, IDatabaseFactory<E> databaseFactory) {
        this.databaseFactoryMap.put(databaseClass, databaseFactory);
    }

    @Override
    public <E> E getDatabase(Class<E> databaseClass) throws CheckedAnalysisException {
        Object database = this.databaseMap.get(databaseClass);
        if (database == null) {
            try {
                IDatabaseFactory<?> databaseFactory = this.databaseFactoryMap.get(databaseClass);
                if (databaseFactory == null) {
                    throw new IllegalArgumentException(new StringBuffer().append("No database factory registered for ").append(databaseClass.getName()).toString());
                }
                database = databaseFactory.createDatabase();
            }
            catch (CheckedAnalysisException e) {
                database = new AbnormalAnalysisResult(e);
            }
            this.databaseMap.put(databaseClass, database);
        }
        if (database instanceof AbnormalAnalysisResult) {
            throw ((AbnormalAnalysisResult)database).checkedAnalysisException;
        }
        return (E)database;
    }

    @Override
    public IErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    static class AbnormalAnalysisResult {
        CheckedAnalysisException checkedAnalysisException;
        RuntimeException runtimeException;
        boolean isNull;

        AbnormalAnalysisResult(CheckedAnalysisException checkedAnalysisException) {
            this.checkedAnalysisException = checkedAnalysisException;
        }

        AbnormalAnalysisResult(RuntimeException runtimeException) {
            this.runtimeException = runtimeException;
        }

        AbnormalAnalysisResult(boolean isNull) {
            this.isNull = isNull;
        }
    }
}

