/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MemberMatcher;
import edu.umd.cs.findbugs.filter.SignatureUtil;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class FieldMatcher
extends MemberMatcher
implements Matcher {
    public FieldMatcher(String name) {
        super(name);
    }

    public FieldMatcher(String name, String type) {
        super(name, SignatureUtil.createFieldSignature(type));
    }

    public boolean match(BugInstance bugInstance) {
        FieldAnnotation fieldAnnotation = bugInstance.getPrimaryField();
        if (fieldAnnotation == null) {
            return false;
        }
        if (!this.name.match(fieldAnnotation.getFieldName())) {
            return false;
        }
        return this.signature == null || this.signature.equals(fieldAnnotation.getFieldSignature());
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.name.getSpec()).addAttribute("signature", this.signature);
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Field", attributes);
    }
}

