/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final Logger log = LoggerFactory.getLogger(GUIDGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        String sql = session.getFactory().getDialect().getSelectGUIDString();
        try {
            String string;
            PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
            try {
                String result;
                ResultSet rs = st.executeQuery();
                try {
                    rs.next();
                    result = rs.getString(1);
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                log.debug("GUID identifier generated: " + result);
                string = result;
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            return string;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve GUID", sql);
        }
    }
}

