/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.TokenStream;
import antlr.collections.AST;
import java.util.ArrayList;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.sql.ordering.antlr.CollationSpecification;
import org.hibernate.sql.ordering.antlr.Factory;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentParser;
import org.hibernate.sql.ordering.antlr.OrderingSpecification;
import org.hibernate.sql.ordering.antlr.SortKey;
import org.hibernate.sql.ordering.antlr.SortSpecification;
import org.hibernate.sql.ordering.antlr.TranslationContext;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByFragmentParser
extends GeneratedOrderByFragmentParser {
    private static final Logger log = LoggerFactory.getLogger(OrderByFragmentParser.class);
    private final TranslationContext context;
    private int traceDepth = 0;

    public OrderByFragmentParser(TokenStream lexer, TranslationContext context) {
        super(lexer);
        super.setASTFactory((ASTFactory)new Factory());
        this.context = context;
    }

    public void traceIn(String ruleName) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        log.trace(prefix + ruleName);
    }

    public void traceOut(String ruleName) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        log.trace(prefix + ruleName);
    }

    protected void trace(String msg) {
        log.trace(msg);
    }

    protected AST quotedIdentifier(AST ident) {
        return this.getASTFactory().create(17, "$PlaceHolder$." + this.context.getDialect().quote('`' + ident.getText() + '`'));
    }

    protected AST quotedString(AST ident) {
        return this.getASTFactory().create(17, this.context.getDialect().quote(ident.getText()));
    }

    protected boolean isFunctionName(AST ast) {
        AST child = ast.getFirstChild();
        if (child != null && "{param list}".equals(child.getText())) {
            return true;
        }
        SQLFunction function = this.context.getSqlFunctionRegistry().findSQLFunction(ast.getText());
        if (function == null) {
            return false;
        }
        return !function.hasParenthesesIfNoArguments();
    }

    protected AST resolveFunction(AST ast) {
        AST child = ast.getFirstChild();
        if (child != null) {
            assert ("{param list}".equals(child.getText()));
            child = child.getFirstChild();
        }
        String functionName = ast.getText();
        SQLFunction function = this.context.getSqlFunctionRegistry().findSQLFunction(functionName);
        if (function == null) {
            String text = functionName;
            if (child != null) {
                text = text + '(';
                while (child != null) {
                    text = text + child.getText();
                    if ((child = child.getNextSibling()) == null) continue;
                    text = text + ", ";
                }
                text = text + ')';
            }
            return this.getASTFactory().create(17, text);
        }
        ArrayList<String> expressions = new ArrayList<String>();
        while (child != null) {
            expressions.add(child.getText());
            child = child.getNextSibling();
        }
        String text = function.render(expressions, this.context.getSessionFactory());
        return this.getASTFactory().create(17, text);
    }

    protected AST resolveIdent(AST ident) {
        String[] replacements;
        String text = ident.getText();
        try {
            replacements = this.context.getColumnMapper().map(text);
        }
        catch (Throwable t) {
            replacements = null;
        }
        if (replacements == null || replacements.length == 0) {
            return this.getASTFactory().create(17, "$PlaceHolder$." + text);
        }
        if (replacements.length == 1) {
            return this.getASTFactory().create(17, "$PlaceHolder$." + replacements[0]);
        }
        AST root = this.getASTFactory().create(10, "{ident list}");
        for (int i = 0; i < replacements.length; ++i) {
            String identText = "$PlaceHolder$." + replacements[i];
            root.addChild(this.getASTFactory().create(17, identText));
        }
        return root;
    }

    protected AST postProcessSortSpecification(AST sortSpec) {
        assert (5 == sortSpec.getType());
        SortSpecification sortSpecification = (SortSpecification)sortSpec;
        SortKey sortKey = sortSpecification.getSortKey();
        if (10 == sortKey.getFirstChild().getType()) {
            AST identList = sortKey.getFirstChild();
            AST ident = identList.getFirstChild();
            CommonAST holder = new CommonAST();
            do {
                holder.addChild((AST)this.createSortSpecification(ident, sortSpecification.getCollation(), sortSpecification.getOrdering()));
            } while ((ident = ident.getNextSibling()) != null);
            sortSpec = holder.getFirstChild();
        }
        return sortSpec;
    }

    private SortSpecification createSortSpecification(AST ident, CollationSpecification collationSpecification, OrderingSpecification orderingSpecification) {
        AST sortSpecification = this.getASTFactory().create(5, "{{sort specification}}");
        AST sortKey = this.getASTFactory().create(7, "{{sort key}}");
        AST newIdent = this.getASTFactory().create(ident.getType(), ident.getText());
        sortKey.setFirstChild(newIdent);
        sortSpecification.setFirstChild(sortKey);
        if (collationSpecification != null) {
            sortSpecification.addChild((AST)collationSpecification);
        }
        if (orderingSpecification != null) {
            sortSpecification.addChild((AST)orderingSpecification);
        }
        return (SortSpecification)sortSpecification;
    }
}

