/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.WrappedClob;
import org.hibernate.type.AbstractType;
import org.hibernate.util.ArrayHelper;

public class ClobType
extends AbstractType {
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws SQLException {
        if (settable[0]) {
            this.set(st, value, index, session);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        this.set(st, value, index, session);
    }

    public void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        boolean useInputStream;
        if (value == null) {
            st.setNull(index, 2005);
            return;
        }
        Clob clob = (Clob)value;
        if (WrappedClob.class.isInstance(clob)) {
            clob = ((WrappedClob)value).getWrappedClob();
        }
        boolean bl = useInputStream = session.getFactory().getDialect().useInputStreamToInsertBlob() && ClobImplementer.class.isInstance(clob);
        if (useInputStream) {
            st.setCharacterStream(index, clob.getCharacterStream(), (int)clob.length());
        } else {
            st.setClob(index, clob);
        }
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws SQLException {
        return this.get(rs, name, Hibernate.getLobCreator(session));
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws SQLException {
        return this.get(rs, names[0], Hibernate.getLobCreator(session));
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        return this.get(rs, name, NonContextualLobCreator.INSTANCE);
    }

    public Clob get(ResultSet rs, String name, LobCreator lobCreator) throws SQLException {
        Clob value = rs.getClob(name);
        return rs.wasNull() ? null : lobCreator.wrap(value);
    }

    public Class getReturnedClass() {
        return Clob.class;
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode) {
        return x == y;
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        return System.identityHashCode(x);
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        return 0;
    }

    public String getName() {
        return "clob";
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        throw new UnsupportedOperationException("Clobs are not cacheable");
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) {
        return value;
    }

    public Object fromXMLNode(Node xml, Mapping factory) {
        return Hibernate.createClob(xml.getText());
    }

    public int getColumnSpan(Mapping mapping) {
        return 1;
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return target;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2005};
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) {
        if (value != null) {
            Clob clob = (Clob)value;
            try {
                int len = (int)clob.length();
                node.setText(clob.getSubString(0L, len));
            }
            catch (SQLException sqle) {
                throw new HibernateException("could not read XML from Clob", sqle);
            }
        }
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }
}

