/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import ucar.bufr.BufrData;
import ucar.bufr.BufrDataExtractor;
import ucar.unidata.io.RandomAccessFile;

public final class BufrGetData {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("BufrDatas:");
        System.out.println("<BufrFileContainingData> ");
        System.out.println("<OffsetToDDS> obtained from BufrIndexer program");
        System.out.println("<OffsetToObs> obtained from BufrIndexer program");
        System.out.println("<BitPos> obtained from BufrIndexer program");
        System.out.println("<BitBuf> obtained from BufrIndexer program");
        System.out.println("<output file>");
        System.out.println();
        System.out.println("java -Xmx256m ucar/bufr/" + className + " <BufrFileContainingData> <OffsetToDDS> <OffsetToObs> <BitPos> <BitBuf>");
        System.exit(0);
    }

    public static void main(String[] args) {
        BufrGetData func = new BufrGetData();
        if (args.length < 5) {
            Class<?> cl = func.getClass();
            BufrGetData.usage(cl.getName());
        }
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        try {
            BufrDataExtractor bde;
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            long DDSOffset = 0L;
            long ObsOffset = 0L;
            int bitPos = 0;
            int bitBuf = 0;
            if (args.length == 5 || args.length == 6) {
                raf = new RandomAccessFile(args[0], "r");
                raf.order(0);
                DDSOffset = Long.parseLong(args[1]);
                ObsOffset = Long.parseLong(args[2]);
                bitPos = Integer.parseInt(args[3]);
                bitBuf = Integer.parseInt(args[4]);
            } else {
                System.exit(0);
            }
            if (args.length == 6) {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[5], false)));
            }
            if ((bde = new BufrDataExtractor(raf, "B3M-000-009")).getData(DDSOffset, ObsOffset, bitPos, bitBuf)) {
                ArrayList dorder = bde.getDorder();
                HashMap bufrdatas = bde.getBufrDatas();
                boolean displayData = true;
                for (int j = 0; j < dorder.size(); ++j) {
                    int k;
                    Object[] data;
                    String bKey = (String)dorder.get(j);
                    BufrData bd = (BufrData)bufrdatas.get(bKey);
                    ps.print(bd.getKey() + " " + bd.getName());
                    if (bKey.equals("0-4-250")) {
                        data = bd.getLongData();
                        ps.println(" size =" + data.length + " varCount =" + bd.getVarCount());
                        if (!displayData) continue;
                        for (k = 0; k < data.length; ++k) {
                            ps.print(" " + data[k]);
                        }
                        ps.println();
                        continue;
                    }
                    if (bd.isNumeric()) {
                        data = bd.getFloatData();
                        ps.println(" size =" + data.length + " varCount =" + bd.getVarCount());
                        if (!displayData) continue;
                        for (k = 0; k < data.length; ++k) {
                            ps.print(" " + data[k]);
                        }
                        ps.println();
                        continue;
                    }
                    data = bd.getStringData();
                    ps.println(" size =" + data.length);
                    if (!displayData) continue;
                    for (k = 0; k < data.length; ++k) {
                        ps.print(" " + (String)data[k]);
                    }
                    ps.println();
                }
                ps.println();
            }
            raf.close();
            ps.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
    }
}

