/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.InitializationException;
import Ice.NotRegisteredException;
import Ice.Plugin;
import Ice.PluginFactory;
import Ice.PluginInitializationException;
import Ice.PluginManager;
import Ice.Properties;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.Util;
import IceUtilInternal.Options;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class PluginManagerI
implements PluginManager {
    private static String _kindOfObject = "plugin";
    private Communicator _communicator;
    private Instance _instance;
    private List<PluginInfo> _plugins = new ArrayList<PluginInfo>();
    private boolean _initialized;
    private Map<String, ClassLoader> _classLoaders;

    @Override
    public synchronized void initializePlugins() {
        if (this._initialized) {
            InitializationException ex = new InitializationException();
            ex.reason = "plug-ins already initialized";
            throw ex;
        }
        ArrayList<Plugin> initializedPlugins = new ArrayList<Plugin>();
        try {
            for (PluginInfo p : this._plugins) {
                try {
                    p.plugin.initialize();
                }
                catch (PluginInitializationException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    PluginInitializationException e = new PluginInitializationException();
                    e.reason = "plugin `" + p.name + "' initialization failed";
                    e.initCause(ex);
                    throw e;
                }
                initializedPlugins.add(p.plugin);
            }
        }
        catch (RuntimeException ex) {
            ListIterator i = initializedPlugins.listIterator(initializedPlugins.size());
            while (i.hasPrevious()) {
                Plugin p = (Plugin)i.previous();
                try {
                    p.destroy();
                }
                catch (RuntimeException runtimeException) {}
            }
            throw ex;
        }
        this._initialized = true;
    }

    @Override
    public synchronized String[] getPlugins() {
        ArrayList<String> names = new ArrayList<String>();
        for (PluginInfo p : this._plugins) {
            names.add(p.name);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public synchronized Plugin getPlugin(String name) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        Plugin p = this.findPlugin(name);
        if (p != null) {
            return p;
        }
        NotRegisteredException ex = new NotRegisteredException();
        ex.id = name;
        ex.kindOfObject = _kindOfObject;
        throw ex;
    }

    @Override
    public synchronized void addPlugin(String name, Plugin plugin) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        if (this.findPlugin(name) != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = name;
            ex.kindOfObject = _kindOfObject;
            throw ex;
        }
        PluginInfo info = new PluginInfo();
        info.name = name;
        info.plugin = plugin;
        this._plugins.add(info);
    }

    @Override
    public synchronized void destroy() {
        if (this._communicator != null) {
            if (this._initialized) {
                ListIterator<PluginInfo> i = this._plugins.listIterator(this._plugins.size());
                while (i.hasPrevious()) {
                    PluginInfo p = i.previous();
                    try {
                        p.plugin.destroy();
                    }
                    catch (RuntimeException ex) {
                        Ice.Util.getProcessLogger().warning("unexpected exception raised by plug-in `" + p.name + "' destruction:\n" + ex.toString());
                    }
                }
            }
            this._communicator = null;
        }
        this._plugins.clear();
        if (this._classLoaders != null) {
            this._classLoaders.clear();
        }
    }

    public PluginManagerI(Communicator communicator, Instance instance) {
        this._communicator = communicator;
        this._instance = instance;
        this._initialized = false;
    }

    public void loadPlugins(StringSeqHolder cmdArgs) {
        String[] loadOrder;
        assert (this._communicator != null);
        String prefix = "Ice.Plugin.";
        Properties properties = this._communicator.getProperties();
        Map<String, String> plugins = properties.getPropertiesForPrefix("Ice.Plugin.");
        for (String name : loadOrder = properties.getPropertyAsList("Ice.PluginLoadOrder")) {
            if (this.findPlugin(name) != null) {
                PluginInitializationException ex = new PluginInitializationException();
                ex.reason = "plug-in `" + name + "' already loaded";
                throw ex;
            }
            String key = "Ice.Plugin." + name + ".java";
            boolean hasKey = plugins.containsKey(key);
            if (hasKey) {
                plugins.remove("Ice.Plugin." + name);
            } else {
                key = "Ice.Plugin." + name;
                hasKey = plugins.containsKey(key);
            }
            if (!hasKey) {
                PluginInitializationException ex = new PluginInitializationException();
                ex.reason = "plug-in `" + name + "' not defined";
                throw ex;
            }
            String value = plugins.get(key);
            this.loadPlugin(name, value, cmdArgs);
            plugins.remove(key);
        }
        while (!plugins.isEmpty()) {
            Iterator<Map.Entry<String, String>> p = plugins.entrySet().iterator();
            Map.Entry<String, String> entry = p.next();
            String name = entry.getKey().substring("Ice.Plugin.".length());
            int dotPos = name.lastIndexOf(46);
            if (dotPos != -1) {
                String suffix = name.substring(dotPos + 1);
                if (suffix.equals("cpp") || suffix.equals("clr")) {
                    p.remove();
                } else if (suffix.equals("java")) {
                    name = name.substring(0, dotPos);
                    this.loadPlugin(name, entry.getValue(), cmdArgs);
                    p.remove();
                    plugins.remove("Ice.Plugin." + name);
                } else {
                    dotPos = -1;
                }
            }
            if (dotPos != -1) continue;
            String value = entry.getValue();
            p.remove();
            String javaValue = plugins.remove("Ice.Plugin." + name + ".java");
            if (javaValue != null) {
                value = javaValue;
            }
            this.loadPlugin(name, value, cmdArgs);
        }
    }

    private void loadPlugin(String name, String pluginSpec, StringSeqHolder cmdArgs) {
        String className;
        String[] args;
        assert (this._communicator != null);
        try {
            args = Options.split(pluginSpec);
        }
        catch (Options.BadQuote ex) {
            throw new PluginInitializationException("invalid arguments for plug-in `" + name + "':\n" + ex.getMessage());
        }
        assert (args.length > 0);
        String entryPoint = args[0];
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        boolean absolutePath = false;
        int pos = entryPoint.indexOf(58);
        if (isWindows) {
            String driveLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            if (pos == 1 && entryPoint.length() > 2 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(entryPoint.charAt(0)) != -1 && (entryPoint.charAt(2) == '\\' || entryPoint.charAt(2) == '/')) {
                absolutePath = true;
                pos = entryPoint.indexOf(58, pos + 1);
            }
            if (!absolutePath) {
                absolutePath = entryPoint.startsWith("\\\\");
            }
        } else {
            absolutePath = entryPoint.startsWith("/");
        }
        if (pos == -1 && absolutePath || pos != -1 && entryPoint.length() <= pos + 1) {
            throw new PluginInitializationException("invalid entry point for plug-in `" + name + "':\n" + entryPoint);
        }
        String classDir = null;
        if (pos == -1) {
            className = entryPoint;
        } else {
            classDir = entryPoint.substring(0, pos).trim();
            className = entryPoint.substring(pos + 1).trim();
        }
        String[] tmp = new String[args.length - 1];
        System.arraycopy(args, 1, tmp, 0, args.length - 1);
        args = tmp;
        Properties properties = this._communicator.getProperties();
        args = properties.parseCommandLineOptions(name, args);
        cmdArgs.value = properties.parseCommandLineOptions(name, (String[])cmdArgs.value);
        PluginFactory pluginFactory = null;
        try {
            Class<?> c = null;
            if (classDir != null) {
                try {
                    if (!absolutePath) {
                        classDir = new File(System.getProperty("user.dir") + File.separator + classDir).getCanonicalPath();
                    }
                    if (!classDir.endsWith(File.separator) && !classDir.toLowerCase().endsWith(".jar")) {
                        classDir = classDir + File.separator;
                    }
                    classDir = URLEncoder.encode(classDir, "UTF-8");
                    ClassLoader cl = null;
                    if (this._classLoaders == null) {
                        this._classLoaders = new HashMap<String, ClassLoader>();
                    } else {
                        cl = this._classLoaders.get(classDir);
                    }
                    if (cl == null) {
                        URL[] url = new URL[]{new URL("file:///" + classDir)};
                        cl = this._instance.initializationData().classLoader != null ? new URLClassLoader(url, this._instance.initializationData().classLoader) : new URLClassLoader(url);
                        this._classLoaders.put(classDir, cl);
                    }
                    c = cl.loadClass(className);
                }
                catch (MalformedURLException ex) {
                    throw new PluginInitializationException("invalid entry point format `" + pluginSpec + "'", ex);
                }
                catch (IOException ex) {
                    throw new PluginInitializationException("invalid path in entry point `" + pluginSpec + "'", ex);
                }
                catch (ClassNotFoundException ex) {}
            } else {
                c = Util.getInstance(this._communicator).findClass(className);
            }
            if (c == null) {
                throw new PluginInitializationException("class " + className + " not found");
            }
            Object obj = c.newInstance();
            try {
                pluginFactory = (PluginFactory)obj;
            }
            catch (ClassCastException ex) {
                throw new PluginInitializationException("class " + className + " does not implement Ice.PluginFactory", ex);
            }
        }
        catch (IllegalAccessException ex) {
            throw new PluginInitializationException("unable to access default constructor in class " + className, ex);
        }
        catch (InstantiationException ex) {
            throw new PluginInitializationException("unable to instantiate class " + className, ex);
        }
        Plugin plugin = null;
        try {
            plugin = pluginFactory.create(this._communicator, name, args);
        }
        catch (PluginInitializationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new PluginInitializationException("exception in factory " + className, ex);
        }
        if (plugin == null) {
            throw new PluginInitializationException("failure in factory " + className);
        }
        PluginInfo info = new PluginInfo();
        info.name = name;
        info.plugin = plugin;
        this._plugins.add(info);
    }

    private Plugin findPlugin(String name) {
        for (PluginInfo p : this._plugins) {
            if (!name.equals(p.name)) continue;
            return p.plugin;
        }
        return null;
    }

    static class PluginInfo {
        String name;
        Plugin plugin;

        PluginInfo() {
        }
    }
}

