/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ome.conditions.InternalException;
import ome.security.basic.CurrentDetails;
import ome.services.scheduler.ThreadPool;
import ome.services.util.ServiceHandler;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.tools.hibernate.SessionFactory;
import ome.tools.spring.InternalServiceFactory;
import ome.util.SqlAction;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public interface Executor
extends ApplicationContextAware {
    public OmeroContext getContext();

    public Principal principal();

    public <T> T execute(Principal var1, Work<T> var2);

    public <T> T execute(Map<String, String> var1, Principal var2, Work<T> var3);

    public <T> Future<T> submit(Callable<T> var1);

    public <T> Future<T> submit(Map<String, String> var1, Callable<T> var2);

    public <T> Future<T> submit(Priority var1, Callable<T> var2);

    public <T> Future<T> submit(Priority var1, Map<String, String> var2, Callable<T> var3);

    public <T> T get(Future<T> var1);

    public ExecutorService getService();

    public Object executeSql(SqlWork var1);

    public static class Impl
    implements Executor {
        private static final Logger log = LoggerFactory.getLogger(Executor.class);
        protected OmeroContext context;
        protected InternalServiceFactory isf;
        protected final List<Advice> advices = new ArrayList<Advice>();
        protected final CurrentDetails principalHolder;
        protected final String[] proxyNames;
        protected final SessionFactory factory;
        protected final SqlAction sqlAction;
        protected final ThreadPool service;
        protected final ExecutorService systemService;

        public Impl(CurrentDetails principalHolder, SessionFactory factory, SqlAction sqlAction, String[] proxyNames) {
            this(principalHolder, factory, sqlAction, proxyNames, new ThreadPool());
        }

        public Impl(CurrentDetails principalHolder, SessionFactory factory, SqlAction sqlAction, String[] proxyNames, ThreadPool service) {
            this.sqlAction = sqlAction;
            this.factory = factory;
            this.principalHolder = principalHolder;
            this.proxyNames = proxyNames;
            this.service = service;
            this.systemService = Executors.newCachedThreadPool();
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.context = (OmeroContext)applicationContext;
            this.isf = new InternalServiceFactory(this.context);
            for (String name : this.proxyNames) {
                this.advices.add((Advice)this.context.getBean(name));
            }
        }

        @Override
        public OmeroContext getContext() {
            return this.context;
        }

        @Override
        public Principal principal() {
            if (this.principalHolder.size() == 0) {
                return null;
            }
            EventContext ec = this.principalHolder.getCurrentEventContext();
            String session = ec.getCurrentSessionUuid();
            return new Principal(session);
        }

        @Override
        public <T> T execute(Principal p, Work<T> work) {
            return this.execute(null, p, work);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T execute(Map<String, String> callContext, Principal p, Work<T> work) {
            if (work instanceof SimpleWork) {
                ((SimpleWork)work).setSqlAction(this.sqlAction);
            }
            Interceptor i = new Interceptor(this.factory);
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget(work);
            factory.setInterfaces(new Class[]{Work.class});
            for (Advice advice : this.advices) {
                factory.addAdvice(advice);
            }
            factory.addAdvice((Advice)i);
            Work wrapper = (Work)factory.getProxy();
            if (p == null && this.principalHolder.size() == 0) {
                throw new IllegalStateException("Must provide principal");
            }
            if (p != null && this.principalHolder.size() > 0) {
                throw new IllegalStateException("Already logged in. Use Executor.submit() and .get().");
            }
            if (p != null) {
                this.principalHolder.login(p);
            }
            if (callContext != null) {
                this.principalHolder.setContext(callContext);
            }
            try {
                Object x = wrapper.doWork(null, this.isf);
                return (T)x;
            }
            finally {
                int left;
                if (callContext != null) {
                    this.principalHolder.setContext(null);
                }
                if (p != null && (left = this.principalHolder.logout()) > 0) {
                    log.warn("Logins left: " + left);
                    for (int j = 0; j < left; ++j) {
                        this.principalHolder.logout();
                    }
                }
            }
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            return this.submit(null, null, callable);
        }

        @Override
        public <T> Future<T> submit(Map<String, String> callContext, Callable<T> callable) {
            return this.submit(null, callContext, callable);
        }

        @Override
        public <T> Future<T> submit(Priority prio, Callable<T> callable) {
            return this.submit(prio, null, callable);
        }

        @Override
        public <T> Future<T> submit(Priority prio, final Map<String, String> callContext, final Callable<T> callable) {
            Callable wrapper = callable;
            if (callContext != null) {
                wrapper = new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        principalHolder.setContext(callContext);
                        try {
                            Object v = callable.call();
                            return v;
                        }
                        finally {
                            principalHolder.setContext(null);
                        }
                    }
                };
            }
            if (prio == null || prio == Priority.USER) {
                return this.service.submit(wrapper);
            }
            if (prio == Priority.BACKGROUND) {
                return this.service.background(wrapper);
            }
            if (prio == Priority.SYSTEM) {
                return this.systemService.submit(wrapper);
            }
            throw new InternalException("Unknown priority: " + (Object)((Object)prio));
        }

        @Override
        public <T> T get(Future<T> future) {
            try {
                return future.get();
            }
            catch (InterruptedException e1) {
                throw new InternalException("Future.get interrupted:" + e1.getMessage());
            }
            catch (ExecutionException e1) {
                if (e1.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e1.getCause();
                }
                throw new InternalException("Caught exception thrown by Future.get:" + e1.getMessage());
            }
        }

        @Override
        public ExecutorService getService() {
            return this.service;
        }

        @Override
        public Object executeSql(SqlWork work) {
            if (this.principalHolder.size() > 0) {
                throw new IllegalStateException("Currently logged in. \nJDBC will then take part in transaction directly. \nPlease have the proper JDBC or data source injected.");
            }
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget((Object)work);
            factory.setInterfaces(new Class[]{SqlWork.class});
            factory.addAdvice(this.advices.get(2));
            SqlWork wrapper = (SqlWork)factory.getProxy();
            return wrapper.doWork(this.sqlAction);
        }

        static class Interceptor
        implements MethodInterceptor {
            private final SessionFactory factory;

            public Interceptor(SessionFactory sf) {
                this.factory = sf;
            }

            public Object invoke(MethodInvocation mi) throws Throwable {
                Object[] args = mi.getArguments();
                args[0] = this.factory.getSession();
                return mi.proceed();
            }
        }
    }

    public static abstract class SimpleSqlWork
    extends Descriptive
    implements SqlWork {
        public SimpleSqlWork(Object o, String method, Object ... params) {
            super(o, method, params);
        }
    }

    public static abstract class SimpleWork<T>
    extends Descriptive
    implements LoggedWork<T> {
        private SqlAction sql;

        public SimpleWork(Object o, String method, Object ... params) {
            super(o, method, params);
        }

        public synchronized void setSqlAction(SqlAction sql) {
            if (this.sql != null) {
                throw new InternalException("Can only set SqlAction once!");
            }
            this.sql = sql;
        }

        public SqlAction getSqlAction() {
            return this.sql;
        }
    }

    public static abstract class Descriptive {
        protected final String description;

        public Descriptive(Object o, String method, Object ... params) {
            this(o.getClass().getName(), method, params);
        }

        public Descriptive(String name, String method, Object ... params) {
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append(".");
            sb.append(method);
            sb.append(ServiceHandler.getResultsString(params, new IdentityHashMap<Object, String>()));
            this.description = sb.toString();
        }

        public String description() {
            return this.description;
        }
    }

    public static interface SqlWork {
        public String description();

        public Object doWork(SqlAction var1);
    }

    public static interface StatefulWork {
        public Object getThis();
    }

    public static interface LoggedWork<X>
    extends Work<X> {
        public String description();
    }

    public static interface Work<X> {
        public X doWork(Session var1, ServiceFactory var2);
    }

    public static enum Priority {
        SYSTEM,
        USER,
        BACKGROUND;

    }
}

