/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.GraphVertex;
import edu.umd.cs.findbugs.graph.SearchTree;
import edu.umd.cs.findbugs.graph.SearchTreeCallback;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchTreeBuilder<VertexType extends GraphVertex<VertexType>>
implements SearchTreeCallback<VertexType> {
    private HashMap<VertexType, SearchTree<VertexType>> searchTreeMap = new HashMap();
    private LinkedList<SearchTree<VertexType>> searchTreeList = new LinkedList();

    @Override
    public void startSearchTree(VertexType vertex) {
        this.searchTreeList.add(this.createSearchTree(vertex));
    }

    @Override
    public void addToSearchTree(VertexType parent, VertexType child) {
        SearchTree<VertexType> parentTree = this.searchTreeMap.get(parent);
        if (parentTree == null) {
            throw new IllegalStateException();
        }
        SearchTree<VertexType> childTree = this.createSearchTree(child);
        parentTree.addChild(childTree);
    }

    public Iterator<SearchTree<VertexType>> searchTreeIterator() {
        return this.searchTreeList.iterator();
    }

    private SearchTree<VertexType> createSearchTree(VertexType vertex) {
        SearchTree<VertexType> searchTree = new SearchTree<VertexType>(vertex);
        this.searchTreeMap.put(vertex, searchTree);
        return searchTree;
    }
}

