/*
 *   $Id$
 * 
 *   Copyright 2007 Glencoe Software, Inc. All rights reserved.
 *   Use is subject to license terms supplied in LICENSE.txt
 *
 */
#undef  README_H
#ifndef README_H

/*

  The *.h header files included here are largely code-generated. To
  prevent the duplication of code generated documentation, the following
  sections apply to all files which are otherwise not documented.

  Classes matching omero/model/*I.h:
  =================================

  The *I.h files represent the concrete OMERO implementations of the 
  abstract classes generated by Ice (described in README.ice). Each
  class has several methods generated to make working with the OMERO
  hierarchies easier.

  A. Methods generated for all fields:
   * unloadField()
   * getField();     // possibly protected
   * setField(Type); // possibly protected

  B. Methods generated for sequences:
   * isSequenceLoaded();
   * sizeOfSequence();
   * beginSequence();
   * endSequence();
   * copySequence();

  C. Methods generated for non-link sequences:
   * addType(Type);
   * addTypeSet(Seq);
   * removeType(Type);
   * removeTypeSet(Seq);
   * clearSequence();

  D. Methods generated for link-sequences:
   * linkType( Type );
   * addLink( Link, bool );
   * findLink( Type );
   * unlinkType( Type );
   * removeLink( Link, bool );

   The booleans on add- and removeLink define whether or not a
   recursive add is performed. This functionality is used internally
   by linkType and unlinkType, but can be used directly by clients.

  -- 

  In addition to these methods, a typedef is defined which allows the
  same pointer handle IceUtil::Handle to be used with the concrete
  implementations as with the abstract Ice classes. Therefore rather
  than:

     ImagePtr img = new ImageI();
     
  which doesn't allow access to the generated methods, once can use:

     ImageIPtr img = new ImageI();
     img->getName();

  Two constructors are provided for each class. The no-args
  constructor manages the proper "loaded" status of all sequences, by
  setting the fieldLoaded properties. It also creates a Details
  instance which is available in every OMERO type. The second
  constructor which takes and omero::RLong and a boolean allows the
  creation of an unloaded entity (by passing in false) with a given
  id. This is useful, for example, to link a dataset to a project
  which has not yet been loaded.

  The destructor for all classes is marked protected as outlined in the
  Ice docs in order to prevent memory leaks.

  Classes matching omero/model/*[!I].h:
  ====================================

  These headers are generated by a call to slice2cpp and follow the
  mapping guidelines outlined in the Ice documentation. For
  understanding the inner workings of Ice they may be benefitial, but
  are complicated and eventually less useful than the matching *.ice
  files.

  All other headers:
  =================
  The other omero/ headers are individually documented (or will be in
  the short-term future).

*/

#endif//README_H
