/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ca;

import edu.umd.cs.findbugs.ba.AbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ReversePostOrder;
import edu.umd.cs.findbugs.ba.ca.Call;
import edu.umd.cs.findbugs.ba.ca.CallList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallListAnalysis
extends AbstractDataflowAnalysis<CallList> {
    private CFG cfg;
    private DepthFirstSearch dfs;
    private Map<InstructionHandle, Call> callMap;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$ca$CallListAnalysis;

    public CallListAnalysis(CFG cfg, DepthFirstSearch dfs, ConstantPoolGen cpg) {
        this.cfg = cfg;
        this.dfs = dfs;
        this.callMap = CallListAnalysis.buildCallMap(cfg, cpg);
    }

    private static Map<InstructionHandle, Call> buildCallMap(CFG cfg, ConstantPoolGen cpg) {
        HashMap<InstructionHandle, Call> callMap = new HashMap<InstructionHandle, Call>();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            InstructionHandle handle = i.next().getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            Call call = new Call(inv.getClassName(cpg), inv.getName(cpg), inv.getSignature(cpg));
            callMap.put(handle, call);
        }
        return callMap;
    }

    @Override
    public void initEntryFact(CallList fact) {
        fact.clear();
    }

    @Override
    public void initResultFact(CallList fact) {
        fact.setTop();
    }

    @Override
    public boolean isForwards() {
        return true;
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReversePostOrder(cfg, this.dfs);
    }

    @Override
    public void makeFactTop(CallList fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(CallList fact) {
        return fact.isTop();
    }

    @Override
    public CallList createFact() {
        return new CallList();
    }

    @Override
    public boolean same(CallList a, CallList b) {
        return a.equals(b);
    }

    @Override
    public void meetInto(CallList start, Edge edge, CallList result) throws DataflowAnalysisException {
        CallList merge = CallList.merge(start, result);
        result.copyFrom(merge);
    }

    @Override
    public void copy(CallList source, CallList dest) {
        dest.copyFrom(source);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, CallList fact) throws DataflowAnalysisException {
        Call call = this.callMap.get(handle);
        if (call != null) {
            fact.add(call);
        }
    }

    @Override
    public boolean isFactValid(CallList fact) {
        return fact.isValid();
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$ca$CallListAnalysis == null ? (class$edu$umd$cs$findbugs$ba$ca$CallListAnalysis = CallListAnalysis.class$("edu.umd.cs.findbugs.ba.ca.CallListAnalysis")) : class$edu$umd$cs$findbugs$ba$ca$CallListAnalysis).getName()).append(" <class file>").toString());
            System.exit(1);
        }
        DataflowTestDriver<CallList, CallListAnalysis> driver = new DataflowTestDriver<CallList, CallListAnalysis>(){

            @Override
            public Dataflow<CallList, CallListAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                CallListAnalysis analysis = new CallListAnalysis(classContext.getCFG(method), classContext.getDepthFirstSearch(method), classContext.getConstantPoolGen());
                Dataflow<CallList, CallListAnalysis> dataflow = new Dataflow<CallList, CallListAnalysis>(analysis.cfg, analysis);
                dataflow.execute();
                return dataflow;
            }
        };
        driver.execute(argv[0]);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((CallList)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (CallList)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((CallList)x0, x1, (CallList)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((CallList)x0, (CallList)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((CallList)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((CallList)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((CallList)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((CallList)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((CallList)x0, (CallList)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

