/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.StringSetMatch;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class DesignationMatcher
implements Matcher {
    private StringSetMatch designations;

    public DesignationMatcher(String designations) {
        this.designations = new StringSetMatch(designations);
    }

    public boolean match(BugInstance bugInstance) {
        return this.designations.match(bugInstance.getUserDesignationKey());
    }

    public int hashCode() {
        return this.designations.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DesignationMatcher)) {
            return false;
        }
        DesignationMatcher other = (DesignationMatcher)o;
        return this.designations.equals(other.designations);
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        xmlOutput.startTag("Designation");
        if (disabled) {
            xmlOutput.addAttribute("disabled", "true");
        }
        this.addAttribute(xmlOutput, "designation", this.designations);
        xmlOutput.stopTag(true);
    }

    public void addAttribute(XMLOutput xmlOutput, String name, StringSetMatch matches) throws IOException {
        String value = matches.toString();
        if (value.length() != 0) {
            xmlOutput.addAttribute(name, value);
        }
    }
}

