/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class EmptyZipFileEntry
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private int sawPutEntry;
    private String streamType;

    public EmptyZipFileEntry(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
        this.sawPutEntry = -10000;
        this.streamType = "";
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getNameConstantOperand().equals("putNextEntry")) {
            this.streamType = this.getClassConstantOperand();
            if (this.streamType.equals("java/util/zip/ZipOutputStream") || this.streamType.equals("java/util/jar/JarOutputStream")) {
                this.sawPutEntry = this.getPC();
            } else {
                this.streamType = "";
            }
        } else if (this.getPC() - this.sawPutEntry <= 7 && seen == 182 && this.getNameConstantOperand().equals("closeEntry") && this.getClassConstantOperand().equals(this.streamType)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, this.streamType.equals("java/util/zip/ZipOutputStream") ? "AM_CREATES_EMPTY_ZIP_FILE_ENTRY" : "AM_CREATES_EMPTY_JAR_FILE_ENTRY", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

