/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;
import org.hibernate.search.filter.EmptyDocIdBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDocIdSet
extends DocIdSet {
    private DocIdSet docIdBitSet;
    private final List<DocIdSet> andedDocIdSets;
    private final int maxDocNumber;

    public AndDocIdSet(List<DocIdSet> andedDocIdSets, int maxDocs) {
        if (andedDocIdSets == null || andedDocIdSets.size() < 2) {
            throw new IllegalArgumentException("To \"and\" some DocIdSet(s) they should be at least 2");
        }
        this.andedDocIdSets = new ArrayList<DocIdSet>(andedDocIdSets);
        this.maxDocNumber = maxDocs;
    }

    private synchronized DocIdSet buildBitset() throws IOException {
        if (this.docIdBitSet != null) {
            return this.docIdBitSet;
        }
        int size = this.andedDocIdSets.size();
        DocIdSetIterator[] iterators = new DocIdSetIterator[size];
        for (int i = 0; i < size; ++i) {
            iterators[i] = this.andedDocIdSets.get(i).iterator();
        }
        this.andedDocIdSets.clear();
        this.docIdBitSet = this.makeDocIdSetOnAgreedBits(iterators);
        return this.docIdBitSet;
    }

    private final DocIdSet makeDocIdSetOnAgreedBits(DocIdSetIterator[] iterators) throws IOException {
        int i;
        int iteratorSize = iterators.length;
        int targetPosition = Integer.MIN_VALUE;
        int votes = 0;
        for (i = 0; i < iteratorSize; ++i) {
            DocIdSetIterator iterator = iterators[i];
            if (!iterator.next()) {
                return EmptyDocIdBitSet.instance;
            }
            int position = iterator.doc();
            if (targetPosition == position) {
                ++votes;
                continue;
            }
            if ((targetPosition = Math.max(targetPosition, position)) != position) continue;
            votes = 1;
        }
        OpenBitSet result = new OpenBitSet((long)this.maxDocNumber);
        if (votes == iteratorSize) {
            result.fastSet(targetPosition);
            ++targetPosition;
        }
        i = 0;
        votes = 0;
        DocIdSetIterator iterator;
        boolean validPosition;
        while (validPosition = (iterator = iterators[i]).skipTo(targetPosition)) {
            int position = iterator.doc();
            if (position == targetPosition) {
                if (++votes == iteratorSize) {
                    result.fastSet(position);
                    votes = 0;
                    ++targetPosition;
                }
            } else {
                votes = 1;
                targetPosition = position;
            }
            ++i;
            i %= iteratorSize;
        }
        return result;
    }

    public DocIdSetIterator iterator() {
        return new AndingDocIdSetIterator();
    }

    private class AndingDocIdSetIterator
    extends DocIdSetIterator {
        private DocIdSetIterator iterator;

        private AndingDocIdSetIterator() {
        }

        public int doc() {
            assert (this.iterator != null) : "Illegal state, can't be called before next() or skipTo(int)";
            return this.iterator.doc();
        }

        public boolean next() throws IOException {
            this.ensureInitialized();
            return this.iterator.next();
        }

        public boolean skipTo(int target) throws IOException {
            this.ensureInitialized();
            return this.iterator.skipTo(target);
        }

        private final void ensureInitialized() throws IOException {
            if (this.iterator == null) {
                this.iterator = AndDocIdSet.this.buildBitset().iterator();
            }
        }
    }
}

