/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.quantum;

import java.util.List;
import ome.model.core.Pixels;
import ome.model.display.QuantumDef;
import ome.model.enums.Family;
import omeis.providers.re.quantum.Quantization_32_bit;
import omeis.providers.re.quantum.Quantization_8_16_bit;
import omeis.providers.re.quantum.Quantization_float;
import omeis.providers.re.quantum.QuantumStrategy;

public class QuantumFactory {
    public static final int DEPTH_1BIT = 1;
    public static final int DEPTH_2BIT = 3;
    public static final int DEPTH_3BIT = 7;
    public static final int DEPTH_4BIT = 15;
    public static final int DEPTH_5BIT = 31;
    public static final int DEPTH_6BIT = 63;
    public static final int DEPTH_7BIT = 127;
    public static final int DEPTH_8BIT = 255;
    @Deprecated
    public static final String LINEAR = "linear";
    @Deprecated
    public static final String EXPONENTIAL = "exponential";
    @Deprecated
    public static final String LOGARITHMIC = "logarithmic";
    @Deprecated
    public static final String POLYNOMIAL = "polynomial";
    public static final boolean NOISE_REDUCTION = true;
    private List<Family> families;

    public QuantumFactory(List<Family> families) {
        this.families = families;
    }

    public Family getFamily(String value) {
        for (Family family : this.families) {
            if (!family.getValue().equals(value)) continue;
            return family;
        }
        throw new IllegalArgumentException("Unknown family: " + value);
    }

    private void verifyDef(QuantumDef qd, Pixels pixels) {
        if (qd == null) {
            throw new NullPointerException("No quantum definition.");
        }
        this.verifyBitResolution(qd.getBitResolution());
    }

    private void verifyBitResolution(int bitResolution) {
        boolean b = false;
        switch (bitResolution) {
            case 1: 
            case 3: 
            case 7: 
            case 15: 
            case 31: 
            case 63: 
            case 127: 
            case 255: {
                b = true;
            }
        }
        if (!b) {
            throw new IllegalArgumentException("Unsupported bit resolution: " + bitResolution + ".");
        }
    }

    private QuantumStrategy getQuantization(QuantumDef qd, Pixels pixels) {
        String typeAsString = pixels.getPixelsType().getValue();
        if ("int32".equals(typeAsString) || "uint32".equals(typeAsString)) {
            return new Quantization_32_bit(qd, pixels);
        }
        if ("float".equals(typeAsString) || "double".equals(typeAsString)) {
            return new Quantization_float(qd, pixels);
        }
        return new Quantization_8_16_bit(qd, pixels);
    }

    public QuantumStrategy getStrategy(QuantumDef qd, Pixels pixels) {
        this.verifyDef(qd, pixels);
        QuantumStrategy strg = null;
        strg = this.getQuantization(qd, pixels);
        if (strg == null) {
            throw new IllegalArgumentException("Unsupported strategy");
        }
        return strg;
    }
}

