/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.util.Base64;
import org.subethamail.smtp.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    static List<String> MECHANISMS = new ArrayList<String>(1);
    private UsernamePasswordValidator helper;

    public LoginAuthenticationHandlerFactory(UsernamePasswordValidator helper) {
        this.helper = helper;
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return MECHANISMS;
    }

    @Override
    public AuthenticationHandler create() {
        return new Handler();
    }

    static {
        MECHANISMS.add("LOGIN");
    }

    class Handler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Handler() {
        }

        public String auth(String clientInput) throws RejectException {
            StringTokenizer stk = new StringTokenizer(clientInput);
            String token = stk.nextToken();
            if (token.trim().equalsIgnoreCase("AUTH")) {
                if (!stk.nextToken().trim().equalsIgnoreCase("LOGIN")) {
                    throw new RejectException(504, "AUTH mechanism mismatch");
                }
                if (stk.hasMoreTokens()) {
                    byte[] decoded = Base64.decode(stk.nextToken());
                    if (decoded == null) {
                        throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
                    }
                    this.username = TextUtils.getStringUtf8(decoded);
                    return "334 " + Base64.encodeToString(TextUtils.getAsciiBytes("Password:"), false);
                }
                return "334 " + Base64.encodeToString(TextUtils.getAsciiBytes("Username:"), false);
            }
            if (this.username == null) {
                byte[] decoded = Base64.decode(clientInput);
                if (decoded == null) {
                    throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
                }
                this.username = TextUtils.getStringUtf8(decoded);
                return "334 " + Base64.encodeToString(TextUtils.getAsciiBytes("Password:"), false);
            }
            byte[] decoded = Base64.decode(clientInput);
            if (decoded == null) {
                throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
            }
            this.password = TextUtils.getStringUtf8(decoded);
            try {
                LoginAuthenticationHandlerFactory.this.helper.login(this.username, this.password);
            }
            catch (LoginFailedException lfe) {
                throw new RejectException(535, "Authentication credentials invalid");
            }
            return null;
        }

        public Object getIdentity() {
            return this.username;
        }
    }
}

