/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pl;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.stempel.StempelFilter;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.apache.lucene.util.Version;
import org.egothor.stemmer.Trie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolishAnalyzer
extends StopwordAnalyzerBase {
    private final Set<?> stemExclusionSet;
    private final Trie stemTable = DefaultsHolder.DEFAULT_TABLE;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    public static final String DEFAULT_STEMMER_FILE = "stemmer_20000.tbl";

    public static Set<?> getDefaultStopSet() {
        return DefaultsHolder.DEFAULT_STOP_SET;
    }

    public PolishAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultsHolder.DEFAULT_STOP_SET);
    }

    public PolishAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public PolishAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)matchVersion, stemExclusionSet));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        Object result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new StempelFilter((TokenStream)result, new StempelStemmer(this.stemTable));
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private static class DefaultsHolder {
        static final Set<?> DEFAULT_STOP_SET;
        static final Trie DEFAULT_TABLE;

        private DefaultsHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(PolishAnalyzer.class, (String)PolishAnalyzer.DEFAULT_STOPWORD_FILE);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set", ex);
            }
            try {
                DEFAULT_TABLE = StempelStemmer.load(PolishAnalyzer.class.getResourceAsStream(PolishAnalyzer.DEFAULT_STEMMER_FILE));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stemming tables", ex);
            }
        }
    }
}

