/*
 * Decompiled with CFR 0.152.
 */
package ome.system.metrics;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.logback.InstrumentedAppender;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ome.system.metrics.Counter;
import ome.system.metrics.DefaultCounter;
import ome.system.metrics.DefaultHistogram;
import ome.system.metrics.DefaultTimer;
import ome.system.metrics.Histogram;
import ome.system.metrics.Metrics;
import ome.system.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultMetrics
implements Metrics,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(Metrics.class);
    private static String DOMAIN = Metrics.class.getPackage().getName();
    private MetricRegistry registry = new MetricRegistry();
    private int slf4jMinutes = 0;
    private boolean jmxReporter = true;
    private boolean jvmInstrumentation = true;
    private boolean logbackInstrumentation = true;
    private String graphiteAddress = null;
    private Collection<String> beginsWith = null;

    public void setSlf4jMinutes(int minutes) {
        this.slf4jMinutes = minutes;
    }

    public void setBeginsWith(Collection<String> prefixes) {
        this.beginsWith = prefixes;
    }

    public void setGraphiteAddress(String address) {
        this.graphiteAddress = address;
    }

    private MetricFilter filter() {
        return new MetricFilter(){

            public boolean matches(String arg0, Metric arg1) {
                if (DefaultMetrics.this.beginsWith == null) {
                    return true;
                }
                for (String b : DefaultMetrics.this.beginsWith) {
                    if (!arg0.startsWith(b)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
        if (this.slf4jMinutes > 0) {
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.registry).filter(this.filter()).outputTo(LoggerFactory.getLogger((String)DOMAIN)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start((long)this.slf4jMinutes, TimeUnit.MINUTES);
        }
        if (this.jmxReporter) {
            JmxReporter jmx = JmxReporter.forRegistry((MetricRegistry)this.registry).inDomain(DOMAIN).build();
            jmx.start();
        }
        if (this.jvmInstrumentation) {
            BufferPoolMetricSet bufferPoolMetrics = new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer());
            this.registerAll("jvm.buffers", (MetricSet)bufferPoolMetrics, this.registry);
            this.registerAll("jvm.gc", (MetricSet)new GarbageCollectorMetricSet(), this.registry);
            this.registerAll("jvm.memory", (MetricSet)new MemoryUsageGaugeSet(), this.registry);
            this.registerAll("jvm.threads", (MetricSet)new ThreadStatesGaugeSet(), this.registry);
            this.registry.register("jvm.fileDescriptorCountRatio", (Metric)new FileDescriptorRatioGauge());
        }
        if (this.logbackInstrumentation) {
            try {
                LoggerContext factory = (LoggerContext)LoggerFactory.getILoggerFactory();
                ch.qos.logback.classic.Logger root = factory.getLogger("ROOT");
                InstrumentedAppender metrics = new InstrumentedAppender(this.registry);
                metrics.setContext((Context)root.getLoggerContext());
                metrics.start();
                root.addAppender((Appender)metrics);
            }
            catch (Exception e) {
                log.error("Failed to instrument logback", (Throwable)e);
            }
        }
        if (this.graphiteAddress != null && !this.graphiteAddress.isEmpty()) {
            Graphite graphite = new Graphite(new InetSocketAddress(this.graphiteAddress, 2003));
            GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.registry).prefixedWith(System.getProperty("Ice.Admin.ServerId", "OMERO")).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
            reporter.start(1L, TimeUnit.MINUTES);
        }
    }

    @Override
    public Counter counter(Object obj, String name) {
        return new DefaultCounter(this.registry.counter(MetricRegistry.name(obj.getClass(), (String[])new String[]{name})));
    }

    @Override
    public Timer timer(Object obj, String name) {
        return new DefaultTimer(this.registry.timer(MetricRegistry.name(obj.getClass(), (String[])new String[]{name})));
    }

    @Override
    public Histogram histogram(Object obj, String name) {
        return new DefaultHistogram(this.registry.histogram(MetricRegistry.name(obj.getClass(), (String[])new String[]{name})));
    }

    private void registerAll(String prefix, MetricSet metrics, MetricRegistry registry) {
        for (Map.Entry entry : metrics.getMetrics().entrySet()) {
            String name = MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()});
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(name, (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(name, (Metric)entry.getValue());
        }
    }
}

