/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableDoubleField;
import org.apache.solr.schema.SortableFloatField;
import org.apache.solr.schema.SortableIntField;
import org.apache.solr.schema.SortableLongField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.BoundedTreeSet;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFacets {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrParams required;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;
    protected ResponseBuilder rb;
    protected SimpleOrderedMap facetResponse;
    public final Date NOW = new Date();
    SolrParams localParams;
    String facetValue;
    DocSet base;
    String key;
    private static final Comparator nullStrComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this(req, docs, params, null);
    }

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.base = this.docs = docs;
        this.params = params;
        this.required = new RequiredSolrParams(params);
        this.rb = rb;
    }

    void parseParams(String type, String param) throws ParseException, IOException {
        this.localParams = QueryParsing.getLocalParams(param, this.req.getParams());
        this.base = this.docs;
        this.facetValue = param;
        this.key = param;
        if (this.localParams == null) {
            return;
        }
        if (type != "facet.query") {
            this.facetValue = this.localParams.get("v");
        }
        this.key = this.facetValue;
        this.key = this.localParams.get("key", this.key);
        String excludeStr = this.localParams.get("ex");
        if (excludeStr == null) {
            return;
        }
        Map tagMap = (Map)this.req.getContext().get("tags");
        if (tagMap != null && this.rb != null) {
            List excludeTagList = StrUtils.splitSmart((String)excludeStr, (char)',');
            IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
            for (String excludeTag : excludeTagList) {
                Object olst = tagMap.get(excludeTag);
                if (!(olst instanceof Collection)) continue;
                for (Object o : (Collection)olst) {
                    if (!(o instanceof QParser)) continue;
                    QParser qp = (QParser)o;
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
            }
            if (excludeSet.size() == 0) {
                return;
            }
            ArrayList<Query> qlist = new ArrayList<Query>();
            if (!excludeSet.containsKey(this.rb.getQuery())) {
                qlist.add(this.rb.getQuery());
            }
            if (this.rb.getFilters() != null) {
                for (Query q : this.rb.getFilters()) {
                    if (excludeSet.containsKey(q)) continue;
                    qlist.add(q);
                }
            }
            this.base = this.searcher.getDocSet(qlist);
        }
    }

    public NamedList getFacetCounts() {
        if (!this.params.getBool("facet", true)) {
            return null;
        }
        this.facetResponse = new SimpleOrderedMap();
        try {
            this.facetResponse.add("facet_queries", (Object)this.getFacetQueryCounts());
            this.facetResponse.add("facet_fields", (Object)this.getFacetFieldCounts());
            this.facetResponse.add("facet_dates", (Object)this.getFacetDateCounts());
            this.facetResponse.add("facet_ranges", (Object)this.getFacetRangeCounts());
        }
        catch (Exception e) {
            SolrException.logOnce((Logger)SolrCore.log, (String)"Exception during facet counts", (Throwable)e);
            this.addException("Exception during facet counts", e);
        }
        return this.facetResponse;
    }

    public void addException(String msg, Exception e) {
        ArrayList<String> exceptions = (ArrayList<String>)this.facetResponse.get("exception");
        if (exceptions == null) {
            exceptions = new ArrayList<String>();
            this.facetResponse.add("exception", exceptions);
        }
        String entry = msg + '\n' + SolrException.toStr((Throwable)e);
        exceptions.add(entry);
    }

    public NamedList getFacetQueryCounts() throws IOException, ParseException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetQs = this.params.getParams("facet.query");
        if (null != facetQs && 0 != facetQs.length) {
            for (String q : facetQs) {
                try {
                    this.parseParams("facet.query", q);
                    Query qobj = QParser.getParser(q, null, this.req).getQuery();
                    res.add(this.key, (Object)this.searcher.numDocs(qobj, this.base));
                }
                catch (Exception e) {
                    String msg = "Exception during facet.query of " + q;
                    SolrException.logOnce((Logger)SolrCore.log, (String)msg, (Throwable)e);
                    this.addException(msg, e);
                }
            }
        }
        return res;
    }

    public NamedList getTermCounts(String field) throws IOException {
        NamedList counts;
        boolean multiToken;
        int offset = this.params.getFieldInt(field, "facet.offset", 0);
        int limit = this.params.getFieldInt(field, "facet.limit", 100);
        if (limit == 0) {
            return new NamedList();
        }
        Integer mincount = this.params.getFieldInt(field, "facet.mincount");
        if (mincount == null) {
            Boolean zeros = this.params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        boolean missing = this.params.getFieldBool(field, "facet.missing", false);
        String sort = this.params.getFieldParam(field, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = this.params.getFieldParam(field, "facet.prefix");
        SchemaField sf = this.searcher.getSchema().getField(field);
        FieldType ft = sf.getType();
        String method = this.params.getFieldParam(field, "facet.method");
        boolean enumMethod = "enum".equals(method);
        if (method == null && ft instanceof BoolField) {
            enumMethod = true;
        }
        boolean bl = multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        if (TrieField.getMainValuePrefix(ft) != null) {
            enumMethod = false;
            multiToken = true;
        }
        if (enumMethod) {
            counts = this.getFacetTermEnumCounts(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
        } else if (multiToken) {
            UnInvertedField uif = UnInvertedField.getUnInvertedField(field, this.searcher);
            counts = uif.getCounts(this.searcher, this.base, offset, limit, mincount, missing, sort, prefix);
        } else {
            counts = SimpleFacets.getFieldCacheCounts(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
        }
        return counts;
    }

    public NamedList getFacetFieldCounts() throws IOException, ParseException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetFs = this.params.getParams("facet.field");
        if (null != facetFs) {
            for (String f : facetFs) {
                try {
                    String termList;
                    this.parseParams("facet.field", f);
                    String string = termList = this.localParams == null ? null : this.localParams.get("terms");
                    if (termList != null) {
                        res.add(this.key, (Object)this.getListedTermCounts(this.facetValue, termList));
                        continue;
                    }
                    res.add(this.key, (Object)this.getTermCounts(this.facetValue));
                }
                catch (Exception e) {
                    String msg = "Exception during facet.field of " + f;
                    SolrException.logOnce((Logger)SolrCore.log, (String)msg, (Throwable)e);
                    this.addException(msg, e);
                }
            }
        }
        return res;
    }

    private NamedList getListedTermCounts(String field, String termList) throws IOException {
        FieldType ft = this.searcher.getSchema().getFieldType(field);
        List terms = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
        NamedList res = new NamedList();
        Term t = new Term(field);
        for (String term : terms) {
            String internal = ft.toInternal(term);
            int count = this.searcher.numDocs((Query)new TermQuery(t.createTerm(internal)), this.base);
            res.add(term, (Object)count);
        }
        return res;
    }

    public static int getFieldMissingCount(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        DocSet hasVal = searcher.getDocSet((Query)new TermRangeQuery(fieldName, null, null, false, false));
        return docs.andNotSize(hasVal);
    }

    public static NamedList getFieldCacheCounts(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        int endTermIndex;
        int startTermIndex;
        FieldType ft = searcher.getSchema().getFieldType(fieldName);
        NamedList res = new NamedList();
        FieldCache.StringIndex si = FieldCache.DEFAULT.getStringIndex((IndexReader)searcher.getReader(), fieldName);
        String[] terms = si.lookup;
        int[] termNum = si.order;
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        if (prefix != null) {
            startTermIndex = Arrays.binarySearch(terms, prefix, nullStrComparator);
            if (startTermIndex < 0) {
                startTermIndex = -startTermIndex - 1;
            }
            endTermIndex = Arrays.binarySearch(terms, prefix + "\uffff\uffff\uffff\uffff", nullStrComparator);
            endTermIndex = -endTermIndex - 1;
        } else {
            startTermIndex = 1;
            endTermIndex = terms.length;
        }
        int nTerms = endTermIndex - startTermIndex;
        if (nTerms > 0 && docs.size() >= mincount) {
            int lim;
            int[] counts = new int[nTerms];
            DocIterator iter = docs.iterator();
            while (iter.hasNext()) {
                int term = termNum[iter.nextDoc()];
                int arrIdx = term - startTermIndex;
                if (arrIdx < 0 || arrIdx >= nTerms) continue;
                int n = arrIdx;
                counts[n] = counts[n] + 1;
            }
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, nTerms);
                BoundedTreeSet<CountPair<String, Integer>> queue = new BoundedTreeSet<CountPair<String, Integer>>(maxsize);
                int min = mincount - 1;
                for (int i = 0; i < nTerms; ++i) {
                    int n2 = counts[i];
                    if (n2 <= min) continue;
                    queue.add(new CountPair<String, Integer>(terms[startTermIndex + i], n2));
                    if (queue.size() < maxsize) continue;
                    min = (Integer)((CountPair)queue.last()).val;
                }
                for (CountPair countPair : queue) {
                    if (--off >= 0) continue;
                    if (--lim >= 0) {
                        res.add(ft.indexedToReadable((String)countPair.key), countPair.val);
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                if (mincount <= 0) {
                    i = off;
                    off = 0;
                }
                while (i < nTerms) {
                    int c = counts[i];
                    if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        res.add(ft.indexedToReadable(terms[startTermIndex + i]), (Object)c);
                    }
                    ++i;
                }
            }
        }
        if (missing) {
            res.add(null, (Object)SimpleFacets.getFieldMissingCount(searcher, docs, fieldName));
        }
        return res;
    }

    public NamedList getFacetTermEnumCounts(SolrIndexSearcher searcher, DocSet docs, String field, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        int minDfFilterCache = this.params.getFieldInt(field, "facet.enum.cache.minDf", 0);
        IndexSchema schema = searcher.getSchema();
        SolrIndexReader r = searcher.getReader();
        FieldType ft = schema.getFieldType(field);
        int maxsize = limit >= 0 ? offset + limit : 0x7FFFFFFE;
        BoundedTreeSet<CountPair<String, Integer>> queue = sort.equals("count") || sort.equals("true") ? new BoundedTreeSet<CountPair<String, Integer>>(maxsize) : null;
        NamedList res = new NamedList();
        int min = mincount - 1;
        int off = offset;
        int lim = limit >= 0 ? limit : Integer.MAX_VALUE;
        String startTerm = prefix == null ? "" : ft.toInternal(prefix);
        TermEnum te = r.terms(new Term(field, startTerm));
        TermDocs td = r.termDocs();
        SolrIndexSearcher.TermDocsState tdState = new SolrIndexSearcher.TermDocsState();
        tdState.tenum = te;
        tdState.tdocs = td;
        if (docs.size() >= mincount) {
            Term t;
            while (null != (t = te.term()) && t.field().equals(field) && (prefix == null || t.text().startsWith(prefix))) {
                int n = te.docFreq();
                if (n > 0 && n > min) {
                    int c;
                    if (n >= minDfFilterCache) {
                        c = docs.intersectionSize(searcher.getPositiveDocSet((Query)new TermQuery(t), tdState));
                    } else {
                        td.seek(te);
                        c = 0;
                        while (td.next()) {
                            if (!docs.exists(td.doc())) continue;
                            ++c;
                        }
                    }
                    if (sort.equals("count") || sort.equals("true")) {
                        if (c > min) {
                            queue.add(new CountPair<String, Integer>(t.text(), c));
                            if (queue.size() >= maxsize) {
                                min = (Integer)((CountPair)queue.last()).val;
                            }
                        }
                    } else if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        res.add(ft.indexedToReadable(t.text()), (Object)c);
                    }
                }
                if (te.next()) continue;
            }
        }
        if (sort.equals("count") || sort.equals("true")) {
            for (CountPair countPair : queue) {
                if (--off >= 0) continue;
                if (--lim < 0) break;
                res.add(ft.indexedToReadable((String)countPair.key), countPair.val);
            }
        }
        if (missing) {
            res.add(null, (Object)SimpleFacets.getFieldMissingCount(searcher, docs, field));
        }
        te.close();
        td.close();
        return res;
    }

    @Deprecated
    public NamedList getFacetDateCounts() throws IOException, ParseException {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.date");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            try {
                this.getFacetDateCounts(f, (NamedList)resOuter);
            }
            catch (Exception e) {
                String msg = "Exception during facet.date of " + f;
                SolrException.logOnce((Logger)SolrCore.log, (String)msg, (Throwable)e);
                this.addException(msg, e);
            }
        }
        return resOuter;
    }

    @Deprecated
    public void getFacetDateCounts(String dateFacet, NamedList resOuter) throws IOException, ParseException {
        Date end;
        Date start;
        IndexSchema schema = this.searcher.getSchema();
        this.parseParams("facet.date", dateFacet);
        String f = this.facetValue;
        SimpleOrderedMap resInner = new SimpleOrderedMap();
        resOuter.add(this.key, (Object)resInner);
        SchemaField sf = schema.getField(f);
        if (!(sf.getType() instanceof DateField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not date facet on a field which is not a DateField: " + f);
        }
        DateField ft = (DateField)sf.getType();
        String startS = this.required.getFieldParam(f, "facet.date.start");
        try {
            start = ft.parseMath(this.NOW, startS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'start' is not a valid Date string: " + startS, (Throwable)e);
        }
        String endS = this.required.getFieldParam(f, "facet.date.end");
        try {
            end = ft.parseMath(this.NOW, endS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' is not a valid Date string: " + endS, (Throwable)e);
        }
        if (end.before(start)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' comes before 'start': " + endS + " < " + startS);
        }
        String gap = this.required.getFieldParam(f, "facet.date.gap");
        DateMathParser dmp = new DateMathParser(DateField.UTC, Locale.US);
        dmp.setNow(this.NOW);
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        String[] iStrs = this.params.getFieldParams(f, "facet.date.include");
        EnumSet include = null == iStrs || 0 == iStrs.length ? EnumSet.of(FacetParams.FacetRangeInclude.LOWER, FacetParams.FacetRangeInclude.UPPER, FacetParams.FacetRangeInclude.EDGE) : FacetParams.FacetRangeInclude.parseParam((String[])iStrs);
        try {
            Date low = start;
            while (low.before(end)) {
                boolean includeUpper;
                dmp.setNow(low);
                String label = ft.toExternal(low);
                Date high = dmp.parseMath(gap);
                if (end.before(high)) {
                    if (this.params.getFieldBool(f, "facet.date.hardend", false)) {
                        high = end;
                    } else {
                        end = high;
                    }
                }
                if (high.before(low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop (is gap negative?)");
                }
                boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && low.equals(start);
                int count = this.rangeCount(sf, low, high, includeLower, includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && high.equals(end));
                if (count >= minCount) {
                    resInner.add(label, (Object)count);
                }
                low = high;
            }
        }
        catch (java.text.ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'gap' is not a valid Date Math string: " + gap, (Throwable)e);
        }
        resInner.add("gap", (Object)gap);
        resInner.add("start", (Object)start);
        resInner.add("end", (Object)end);
        String[] othersP = this.params.getFieldParams(f, "facet.date.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
                if (all || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                    resInner.add(FacetParams.FacetRangeOther.BEFORE.toString(), (Object)this.rangeCount(sf, null, start, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                    resInner.add(FacetParams.FacetRangeOther.AFTER.toString(), (Object)this.rangeCount(sf, end, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    resInner.add(FacetParams.FacetRangeOther.BETWEEN.toString(), (Object)this.rangeCount(sf, start, end, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
    }

    public NamedList getFacetRangeCounts() {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.range");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            try {
                this.getFacetRangeCounts(f, (NamedList)resOuter);
            }
            catch (Exception e) {
                String msg = "Exception during facet.range of " + f;
                SolrException.logOnce((Logger)SolrCore.log, (String)msg, (Throwable)e);
                this.addException(msg, e);
            }
        }
        return resOuter;
    }

    void getFacetRangeCounts(String facetRange, NamedList resOuter) throws IOException, ParseException {
        IndexSchema schema = this.searcher.getSchema();
        this.parseParams("facet.range", facetRange);
        String f = this.facetValue;
        SchemaField sf = schema.getField(f);
        FieldType ft = sf.getType();
        RangeEndpointCalculator calc = null;
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    calc = new FloatRangeEndpointCalculator(sf);
                    break;
                }
                case DOUBLE: {
                    calc = new DoubleRangeEndpointCalculator(sf);
                    break;
                }
                case INTEGER: {
                    calc = new IntegerRangeEndpointCalculator(sf);
                    break;
                }
                case LONG: {
                    calc = new LongRangeEndpointCalculator(sf);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on tried field of unexpected type:" + f);
                }
            }
        } else if (ft instanceof DateField) {
            calc = new DateRangeEndpointCalculator(sf, this.NOW);
        } else if (ft instanceof SortableIntField) {
            calc = new IntegerRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableLongField) {
            calc = new LongRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableFloatField) {
            calc = new FloatRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableDoubleField) {
            calc = new DoubleRangeEndpointCalculator(sf);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + sf);
        }
        resOuter.add(this.key, (Object)this.getFacetRangeCounts(sf, calc));
    }

    private <T extends Comparable<T>> NamedList getFacetRangeCounts(SchemaField sf, RangeEndpointCalculator<T> calc) throws IOException {
        String f = sf.getName();
        SimpleOrderedMap res = new SimpleOrderedMap();
        NamedList counts = new NamedList();
        res.add("counts", (Object)counts);
        T start = calc.getValue(this.required.getFieldParam(f, "facet.range.start"));
        T end = calc.getValue(this.required.getFieldParam(f, "facet.range.end"));
        if (end.compareTo(start) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + start);
        }
        String gap = this.required.getFieldParam(f, "facet.range.gap");
        res.add("gap", calc.getGap(gap));
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        EnumSet include = FacetParams.FacetRangeInclude.parseParam((String[])this.params.getFieldParams(f, "facet.range.include"));
        T low = start;
        while (low.compareTo(end) < 0) {
            String highS;
            T high = calc.addGap(low, gap);
            if (end.compareTo(high) < 0) {
                if (this.params.getFieldBool(f, "facet.range.hardend", false)) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            boolean includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            String lowS = calc.formatValue(low);
            int count = this.rangeCount(sf, lowS, highS = calc.formatValue(high), includeLower, includeUpper);
            if (count >= minCount) {
                counts.add(lowS, (Object)count);
            }
            low = high;
        }
        res.add("start", start);
        res.add("end", end);
        String[] othersP = this.params.getFieldParams(f, "facet.range.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
                String startS = calc.formatValue(start);
                String endS = calc.formatValue(end);
                if (all || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                    res.add(FacetParams.FacetRangeOther.BEFORE.toString(), (Object)this.rangeCount(sf, null, startS, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                    res.add(FacetParams.FacetRangeOther.AFTER.toString(), (Object)this.rangeCount(sf, endS, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    res.add(FacetParams.FacetRangeOther.BETWEEN.toString(), (Object)this.rangeCount(sf, startS, endS, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
        return res;
    }

    protected int rangeCount(SchemaField sf, String low, String high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = sf.getType().getRangeQuery(null, sf, low, high, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, this.base);
    }

    @Deprecated
    protected int rangeCount(SchemaField sf, Date low, Date high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = ((DateField)sf.getType()).getRangeQuery(null, sf, low, high, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, this.base);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateRangeEndpointCalculator
    extends RangeEndpointCalculator<Date> {
        private final Date now;

        public DateRangeEndpointCalculator(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof DateField)) {
                throw new IllegalArgumentException("SchemaField must use filed type extending DateField");
            }
        }

        @Override
        public String formatValue(Date val) {
            return ((DateField)this.field.getType()).toExternal(val);
        }

        @Override
        protected Date parseVal(String rawval) {
            return ((DateField)this.field.getType()).parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws java.text.ParseException {
            DateMathParser dmp = new DateMathParser(DateField.UTC, Locale.US);
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongRangeEndpointCalculator
    extends RangeEndpointCalculator<Long> {
        public LongRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Long parseVal(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Long value, String gap) {
            return new Long(value.intValue() + Long.valueOf(gap).intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerRangeEndpointCalculator
    extends RangeEndpointCalculator<Integer> {
        public IntegerRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Integer parseVal(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Integer value, String gap) {
            return new Integer(value + Integer.valueOf(gap));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleRangeEndpointCalculator
    extends RangeEndpointCalculator<Double> {
        public DoubleRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Double parseVal(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Double value, String gap) {
            return new Double(value.floatValue() + Double.valueOf(gap).floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatRangeEndpointCalculator
    extends RangeEndpointCalculator<Float> {
        public FloatRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Float parseVal(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Float value, String gap) {
            return new Float(value.floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class RangeEndpointCalculator<T extends Comparable<T>> {
        protected final SchemaField field;

        public RangeEndpointCalculator(SchemaField field) {
            this.field = field;
        }

        public String formatValue(T val) {
            return val.toString();
        }

        public final T getValue(String rawval) {
            try {
                return this.parseVal(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseVal(String var1) throws java.text.ParseException;

        public final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected Object parseGap(String rawval) throws java.text.ParseException {
            return this.parseVal(rawval);
        }

        public final T addGap(T value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseAndAddGap(T var1, String var2) throws java.text.ParseException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CountPair<K extends Comparable<? super K>, V extends Comparable<? super V>>
    implements Comparable<CountPair<K, V>> {
        public K key;
        public V val;

        public CountPair(K k, V v) {
            this.key = k;
            this.val = v;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CountPair && 0 == this.compareTo((CountPair)o);
        }

        @Override
        public int compareTo(CountPair<K, V> o) {
            int vc = o.val.compareTo(this.val);
            return 0 != vc ? vc : this.key.compareTo(o.key);
        }
    }
}

