/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class SimplePostTool {
    public static final String DEFAULT_POST_URL = "http://localhost:8983/solr/update";
    public static final String VERSION_OF_THIS_TOOL = "1.3";
    private static final String SOLR_OK_RESPONSE_EXCERPT = "<int name=\"status\">0</int>";
    private static final String DEFAULT_COMMIT = "yes";
    private static final String DEFAULT_OUT = "no";
    private static final String DEFAULT_DATA_TYPE = "application/xml";
    private static final String DATA_MODE_FILES = "files";
    private static final String DATA_MODE_ARGS = "args";
    private static final String DATA_MODE_STDIN = "stdin";
    private static final String DEFAULT_DATA_MODE = "files";
    private static final Set<String> DATA_MODES = new HashSet<String>();
    protected URL solrUrl;

    public static void main(String[] args) {
        SimplePostTool.info("version 1.3");
        if (0 < args.length && "-help".equals(args[0])) {
            System.out.println("This is a simple command line tool for POSTing raw data to a Solr\nport.  Data can be read from files specified as commandline args,\nas raw commandline arg strings, or via STDIN.\nExamples:\n  java -Ddata=files -jar post.jar *.xml\n  java -Ddata=args  -jar post.jar '<delete><id>42</id></delete>'\n  java -Ddata=stdin -jar post.jar < hd.xml\nOther options controlled by System Properties include the Solr\nURL to POST to, the Content-Type of the data, whether a commit\nshould be executed, and whether the response should be written\nto STDOUT. These are the defaults for all System Properties...\n  -Ddata=files\n  -Dtype=application/xml\n  -Durl=http://localhost:8983/solr/update\n  -Dcommit=yes\n  -Dout=no\n");
            return;
        }
        PrintStream out = null;
        URL u = null;
        try {
            u = new URL(System.getProperty("url", DEFAULT_POST_URL));
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("System Property 'url' is not a valid URL: " + u);
        }
        SimplePostTool t = new SimplePostTool(u);
        String mode = System.getProperty("data", "files");
        if (!DATA_MODES.contains(mode)) {
            SimplePostTool.fatal("System Property 'data' is not valid for this tool: " + mode);
        }
        String doOut = System.getProperty("out", DEFAULT_OUT);
        if (DEFAULT_COMMIT.equals(System.getProperty("out", DEFAULT_OUT))) {
            out = System.out;
        }
        try {
            if ("files".equals(mode)) {
                if (0 < args.length) {
                    SimplePostTool.info("POSTing files to " + u + "..");
                    int posted = t.postFiles(args, 0, out);
                }
            } else if (DATA_MODE_ARGS.equals(mode)) {
                if (0 < args.length) {
                    SimplePostTool.info("POSTing args to " + u + "..");
                    for (String a : args) {
                        t.postData(SimplePostTool.stringToStream(a), null, out);
                    }
                }
            } else if (DATA_MODE_STDIN.equals(mode)) {
                SimplePostTool.info("POSTing stdin to " + u + "..");
                t.postData(System.in, null, out);
            }
            if (DEFAULT_COMMIT.equals(System.getProperty("commit", DEFAULT_COMMIT))) {
                SimplePostTool.info("COMMITting Solr index changes..");
                t.commit(out);
            }
        }
        catch (RuntimeException e) {
            SimplePostTool.fatal("RuntimeException " + e);
        }
    }

    int postFiles(String[] args, int startIndexInArgs, OutputStream out) {
        int filesPosted = 0;
        for (int j = startIndexInArgs; j < args.length; ++j) {
            File srcFile = new File(args[j]);
            if (srcFile.canRead()) {
                SimplePostTool.info("POSTing file " + srcFile.getName());
                this.postFile(srcFile, out);
                ++filesPosted;
                continue;
            }
            SimplePostTool.warn("Cannot read input file: " + srcFile);
        }
        return filesPosted;
    }

    static void warn(String msg) {
        System.err.println("SimplePostTool: WARNING: " + msg);
    }

    static void info(String msg) {
        System.out.println("SimplePostTool: " + msg);
    }

    static void fatal(String msg) {
        System.err.println("SimplePostTool: FATAL: " + msg);
        System.exit(1);
    }

    public SimplePostTool(URL solrUrl) {
        this.solrUrl = solrUrl;
    }

    public void commit(OutputStream output) {
        this.postData(SimplePostTool.stringToStream("<commit/>"), null, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void postFile(File file, OutputStream output) {
        block11: {
            FileInputStream is = null;
            is = new FileInputStream(file);
            this.postData(is, (int)file.length(), output);
            Object var6_4 = null;
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
                break block11;
            }
            catch (IOException e2) {
                SimplePostTool.fatal("IOException while closing file: " + e2);
            }
            break block11;
            {
                catch (IOException e) {
                    SimplePostTool.fatal("Can't open/read file: " + file);
                    Object var6_5 = null;
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {
                        SimplePostTool.fatal("IOException while closing file: " + e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e2) {
                    SimplePostTool.fatal("IOException while closing file: " + e2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void postData(InputStream data, Integer length, OutputStream output) {
        String type = System.getProperty("type", DEFAULT_DATA_TYPE);
        HttpURLConnection urlc = null;
        try {
            block33: {
                block32: {
                    try {
                        urlc = (HttpURLConnection)this.solrUrl.openConnection();
                        try {
                            urlc.setRequestMethod("POST");
                        }
                        catch (ProtocolException e) {
                            SimplePostTool.fatal("Shouldn't happen: HttpURLConnection doesn't support POST??" + e);
                        }
                        urlc.setDoOutput(true);
                        urlc.setDoInput(true);
                        urlc.setUseCaches(false);
                        urlc.setAllowUserInteraction(false);
                        urlc.setRequestProperty("Content-type", type);
                        if (null != length) {
                            urlc.setFixedLengthStreamingMode(length);
                        }
                    }
                    catch (IOException e) {
                        SimplePostTool.fatal("Connection error (is Solr running at " + this.solrUrl + " ?): " + e);
                    }
                    OutputStream out = null;
                    out = urlc.getOutputStream();
                    SimplePostTool.pipe(data, out);
                    Object var9_9 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block32;
                    }
                    catch (IOException x) {}
                    break block32;
                    {
                        catch (IOException e) {
                            SimplePostTool.fatal("IOException while posting data: " + e);
                            Object var9_10 = null;
                            try {
                                if (out != null) {
                                    out.close();
                                }
                                break block32;
                            }
                            catch (IOException x) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException x) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                InputStream in = null;
                if (200 != urlc.getResponseCode()) {
                    SimplePostTool.fatal("Solr returned an error #" + urlc.getResponseCode() + " " + urlc.getResponseMessage());
                }
                in = urlc.getInputStream();
                SimplePostTool.pipe(in, output);
                Object var12_19 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block33;
                }
                catch (IOException x) {}
                break block33;
                {
                    catch (IOException e) {
                        SimplePostTool.fatal("IOException while reading response: " + e);
                        Object var12_20 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block33;
                        }
                        catch (IOException x) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var12_21 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Object var15_26 = null;
            if (urlc != null) {
                urlc.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var15_27 = null;
            if (urlc != null) {
                urlc.disconnect();
            }
            throw throwable;
        }
    }

    private static InputStream stringToStream(String s) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            SimplePostTool.fatal("Shouldn't happen: UTF-8 not supported?!?!?!");
        }
        return is;
    }

    private static void pipe(InputStream source, OutputStream dest) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = source.read(buf)) >= 0) {
            if (null == dest) continue;
            dest.write(buf, 0, read);
        }
        if (null != dest) {
            dest.flush();
        }
    }

    static {
        DATA_MODES.add("files");
        DATA_MODES.add(DATA_MODE_ARGS);
        DATA_MODES.add(DATA_MODE_STDIN);
    }
}

